/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.CompanionPetConfig;
import com.example.CompanionPetPlugin;
import com.example.PetData;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

@Singleton
public class CompanionPetPanel
extends PluginPanel {
    @Inject
    private CompanionPetPlugin plugin;
    @Inject
    private CompanionPetConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    private final JPanel sidePanel;
    private final JPanel titlePanel;
    private final JPanel petButtonsPanel;
    private final JPanel petSelectionTitlePanel;
    private final JPanel spacerPanelFavPets;
    private final JPanel favPetButtonsPanel;
    private final JPanel spacerPanelBottom;
    private final JPanel spacerPanelTop;
    private final JPanel currentPetTitle;
    private final JPanel thrallPanel;
    private final JPanel currentPetPanel;
    private final JPanel spacerAndTextForThralls;
    private final JPanel thrallTitlePanel;
    private final JPanel thrallSpacerTop;
    private final JLabel currentPetIcon;
    private static final BufferedImage DROP_DOWN_ICON = ImageUtil.loadImageResource(CompanionPetPlugin.class, (String)"/dropdown_icon.png");
    private static final BufferedImage DROP_DOWN_ICON_FLIPPED = ImageUtil.loadImageResource(CompanionPetPlugin.class, (String)"/dropdown_flipped_icon.png");
    private static final BufferedImage INVISIBLE_ICON = ImageUtil.loadImageResource(CompanionPetPlugin.class, (String)"/invisible_icon.png");
    private static final BufferedImage VISIBLE_ICON = ImageUtil.loadImageResource(CompanionPetPlugin.class, (String)"/visible_icon.png");
    private static final BufferedImage CHECKMARK = ImageUtil.loadImageResource(CompanionPetPlugin.class, (String)"/checkmark.png");
    private static final BufferedImage NO_CHECKMARK = ImageUtil.loadImageResource(CompanionPetPlugin.class, (String)"/no_checkmark.png");
    private static final String CONFIG_GROUP = "CompanionPetPlugin";

    @Inject
    public CompanionPetPanel(JPanel sidePanel, JPanel titlePanel, JPanel petButtonsPanel, JPanel petSelectionTitlePanel, JPanel currentPetTitle, JPanel currentPetPanel, JLabel currentPetIcon, JPanel spacerPanel, JPanel spacerPanelTop, JPanel favPetButtonsPanel, JPanel spacerPanelFavPets, JPanel thrallPanel, JPanel spacerAndTextForThralls, JPanel thrallTitlePanel, JPanel spacerThrallTop) {
        this.sidePanel = sidePanel;
        this.titlePanel = titlePanel;
        this.petButtonsPanel = petButtonsPanel;
        this.petSelectionTitlePanel = petSelectionTitlePanel;
        this.currentPetTitle = currentPetTitle;
        this.currentPetPanel = currentPetPanel;
        this.currentPetIcon = currentPetIcon;
        this.spacerPanelBottom = spacerPanel;
        this.spacerPanelTop = spacerPanelTop;
        this.favPetButtonsPanel = favPetButtonsPanel;
        this.spacerPanelFavPets = spacerPanelFavPets;
        this.thrallPanel = thrallPanel;
        this.spacerAndTextForThralls = spacerAndTextForThralls;
        this.thrallTitlePanel = thrallTitlePanel;
        this.thrallSpacerTop = spacerThrallTop;
    }

    public void sidePanelInitializer() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.sidePanel.setLayout(new BoxLayout(this.sidePanel, 1));
        this.sidePanel.add(this.buildTitlePanel());
        this.sidePanel.add(this.buildCurrentPetTitle());
        this.sidePanel.add(this.buildCurrentPetPanel());
        this.sidePanel.add(this.buildThrallTitlePanel());
        this.sidePanel.add(this.buildThrallSpacerTop());
        this.sidePanel.add(this.buildSpacerAndTextForThralls());
        this.sidePanel.add(this.buildThrallPanel());
        this.sidePanel.add(this.buildSpacerPanelTop());
        this.sidePanel.add(this.buildPetSelectionTitle());
        this.sidePanel.add(this.buildFavPetButtonsPanel());
        this.sidePanel.add(this.buildSpacerPanelFavPets());
        this.sidePanel.add(this.buildPetButtonsPanel());
        this.sidePanel.add(this.buildSpacerPanelBottom());
        this.add(this.sidePanel, "North");
    }

    private JPanel buildTitlePanel() {
        this.titlePanel.removeAll();
        this.titlePanel.setBorder(new CompoundBorder(new EmptyBorder(5, 0, 0, 0), new MatteBorder(0, 0, 1, 0, new Color(42, 255, 0, 89))));
        this.titlePanel.setLayout(new BorderLayout());
        PluginErrorPanel errorPanel = new PluginErrorPanel();
        errorPanel.setBorder((Border)new EmptyBorder(2, 0, 3, 0));
        errorPanel.setFont(FontManager.getRunescapeBoldFont());
        errorPanel.setContent("Companion Pet Plugin", "Spawn any pet as a follower or thrall");
        this.titlePanel.add((Component)errorPanel, "Center");
        return this.titlePanel;
    }

    private JPanel buildPetSelectionTitle() {
        this.petSelectionTitlePanel.removeAll();
        this.petSelectionTitlePanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.petSelectionTitlePanel.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 0), new MatteBorder(0, 0, 1, 0, new Color(42, 255, 0, 89))));
        this.petSelectionTitlePanel.setLayout(new FlowLayout());
        if (this.plugin.petData == null) {
            this.plugin.petData = PetData.pets.get(this.config.pet().getIdentifier());
        }
        BufferedImage bufferedIcon = this.config.filter() ? VISIBLE_ICON : INVISIBLE_ICON;
        String hoverText = this.config.filter() ? "Filter Pets" : "Un-Filter Pets";
        JButton button = new JButton(new ImageIcon(bufferedIcon));
        button.setRolloverIcon(new ImageIcon(ImageUtil.luminanceOffset((Image)bufferedIcon, (int)-80)));
        Dimension dimension = new Dimension(5, 5);
        button.setSize(dimension);
        button.setMaximumSize(dimension);
        button.setToolTipText(hoverText);
        SwingUtil.removeButtonDecorations((AbstractButton)button);
        button.addActionListener(e -> {
            this.update();
            BufferedImage icon = this.config.filter() ? VISIBLE_ICON : INVISIBLE_ICON;
            String text = this.config.filter() ? "Filter Pets" : "Un-Filter Pets";
            button.setToolTipText(text);
            button.setIcon(new ImageIcon(icon));
            button.setRolloverIcon(new ImageIcon(ImageUtil.luminanceOffset((Image)icon, (int)-80)));
        });
        BufferedImage dropdownIcon = this.config.showPetList() ? DROP_DOWN_ICON_FLIPPED : DROP_DOWN_ICON;
        String toolTipText = this.config.showPetList() ? "Hide Pet list" : "Show Pet list";
        JButton dropDownButton = new JButton(new ImageIcon(dropdownIcon));
        dropDownButton.setRolloverIcon(new ImageIcon(ImageUtil.luminanceOffset((Image)dropdownIcon, (int)-80)));
        dropDownButton.setSize(dimension);
        dropDownButton.setMaximumSize(dimension);
        dropDownButton.setToolTipText(toolTipText);
        SwingUtil.removeButtonDecorations((AbstractButton)dropDownButton);
        dropDownButton.addActionListener(e -> {
            if (this.config.showPetList()) {
                this.configManager.setConfiguration(CONFIG_GROUP, "showPets", (Object)false);
                this.petButtonsPanel.setVisible(false);
                this.spacerPanelBottom.setVisible(false);
            } else {
                this.configManager.setConfiguration(CONFIG_GROUP, "showPets", (Object)true);
                this.petButtonsPanel.setVisible(true);
                this.spacerPanelBottom.setVisible(true);
            }
            BufferedImage icon = this.config.showPetList() ? DROP_DOWN_ICON_FLIPPED : DROP_DOWN_ICON;
            String toolTip = this.config.showPetList() ? "Hide Pet list" : "Show Pet list";
            dropDownButton.setIcon(new ImageIcon(icon));
            dropDownButton.setRolloverIcon(new ImageIcon(ImageUtil.luminanceOffset((Image)icon, (int)-80)));
            dropDownButton.setToolTipText(toolTip);
        });
        if (!this.config.showPetList()) {
            this.petButtonsPanel.setVisible(false);
            this.spacerPanelBottom.setVisible(false);
        }
        JLabel title = new JLabel("Pet Selector");
        title.setFont(FontManager.getRunescapeBoldFont());
        title.setForeground(Color.LIGHT_GRAY);
        this.petSelectionTitlePanel.add((Component)dropDownButton, "Left");
        this.petSelectionTitlePanel.add(Box.createRigidArea(new Dimension(15, 0)), "Left");
        this.petSelectionTitlePanel.add((Component)title, "Center");
        this.petSelectionTitlePanel.add(Box.createRigidArea(new Dimension(15, 0)), "Right");
        this.petSelectionTitlePanel.add((Component)button, "Right");
        return this.petSelectionTitlePanel;
    }

    private void update() {
        this.configManager.setConfiguration(CONFIG_GROUP, "filter", (Object)(!this.config.filter() ? 1 : 0));
        this.buildPetButtonsPanel();
        this.clientThread.invokeAtTickEnd(() -> {
            this.petButtonsPanel.revalidate();
            this.petSelectionTitlePanel.revalidate();
            this.petButtonsPanel.repaint();
            this.petSelectionTitlePanel.repaint();
        });
    }

    private JPanel buildCurrentPetTitle() {
        this.currentPetTitle.removeAll();
        this.currentPetTitle.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 0), new MatteBorder(0, 0, 1, 0, new Color(42, 255, 0, 89))));
        this.currentPetTitle.setLayout(new FlowLayout());
        if (this.plugin.petData == null) {
            this.plugin.petData = PetData.pets.get(this.config.pet().getIdentifier());
        }
        JLabel title = new JLabel("Current Pet");
        title.setFont(FontManager.getRunescapeBoldFont());
        title.setForeground(Color.LIGHT_GRAY);
        this.currentPetTitle.add((Component)title, "Center");
        return this.currentPetTitle;
    }

    private JPanel buildCurrentPetPanel() {
        this.currentPetPanel.removeAll();
        this.currentPetPanel.setBorder(new CompoundBorder(new EmptyBorder(0, 20, 0, 0), new MatteBorder(0, 0, 0, 0, new Color(42, 255, 0, 89))));
        this.currentPetPanel.setLayout(new BorderLayout());
        this.updateCurrentPetIcon();
        this.currentPetPanel.add((Component)this.currentPetIcon, "Center");
        return this.currentPetPanel;
    }

    public void updateCurrentPetIcon() {
        if (this.plugin.petData == null) {
            this.plugin.petData = PetData.pets.get(this.config.pet().getIdentifier());
        }
        AsyncBufferedImage icon = this.itemManager.getImage(this.plugin.petData.getIconID());
        Runnable resize = () -> {
            this.currentPetIcon.setIcon(new ImageIcon(icon.getScaledInstance(200, 200, 4)));
            this.currentPetIcon.setToolTipText(this.plugin.petData.getName());
        };
        icon.onLoaded(resize);
        resize.run();
    }

    private JPanel buildThrallTitlePanel() {
        this.thrallTitlePanel.setBorder(new CompoundBorder(new EmptyBorder(0, 0, -3, 0), new MatteBorder(1, 0, 0, 0, new Color(42, 255, 0, 89))));
        JLabel title = new JLabel("Thralls");
        title.setFont(FontManager.getRunescapeBoldFont());
        BufferedImage dropdownIcon = this.config.showThralls() ? DROP_DOWN_ICON_FLIPPED : DROP_DOWN_ICON;
        String showHideThrallToolTip = this.config.showThralls() ? "Hide Thralls" : "Show Thralls";
        Dimension dimension = new Dimension(5, 5);
        JButton dropDownButton = new JButton(new ImageIcon(dropdownIcon));
        dropDownButton.setRolloverIcon(new ImageIcon(ImageUtil.luminanceOffset((Image)dropdownIcon, (int)-80)));
        dropDownButton.setSize(dimension);
        dropDownButton.setMaximumSize(dimension);
        dropDownButton.setToolTipText(showHideThrallToolTip);
        SwingUtil.removeButtonDecorations((AbstractButton)dropDownButton);
        dropDownButton.addActionListener(e -> {
            if (this.config.showThralls()) {
                this.configManager.setConfiguration(CONFIG_GROUP, "showThralls", (Object)false);
                this.thrallPanel.setVisible(false);
                this.spacerAndTextForThralls.setVisible(false);
                this.thrallSpacerTop.setVisible(false);
                this.thrallTitlePanel.setBorder(new CompoundBorder(new EmptyBorder(0, 0, -10, 0), new MatteBorder(1, 0, 0, 0, new Color(42, 255, 0, 89))));
            } else {
                this.configManager.setConfiguration(CONFIG_GROUP, "showThralls", (Object)true);
                this.thrallPanel.setVisible(true);
                this.spacerAndTextForThralls.setVisible(true);
                this.thrallSpacerTop.setVisible(true);
                this.thrallTitlePanel.setBorder(new CompoundBorder(new EmptyBorder(0, 0, -3, 0), new MatteBorder(1, 0, 0, 0, new Color(42, 255, 0, 89))));
            }
            BufferedImage icon = this.config.showThralls() ? DROP_DOWN_ICON_FLIPPED : DROP_DOWN_ICON;
            String toolTip = this.config.showThralls() ? "Hide Thralls" : "Show Thralls";
            dropDownButton.setIcon(new ImageIcon(icon));
            dropDownButton.setRolloverIcon(new ImageIcon(ImageUtil.luminanceOffset((Image)icon, (int)-80)));
            dropDownButton.setToolTipText(toolTip);
        });
        BufferedImage checkboxIcon = this.config.companionThralls() ? CHECKMARK : NO_CHECKMARK;
        String checkboxToolTip = this.config.companionThralls() ? "Disable Companion Thralls" : "Enable Companion Thralls";
        JButton thrallCheckbox = new JButton(new ImageIcon(checkboxIcon));
        thrallCheckbox.setBorder(new EmptyBorder(-2, 0, 0, 0));
        thrallCheckbox.setRolloverIcon(new ImageIcon(ImageUtil.luminanceOffset((Image)checkboxIcon, (int)-80)));
        thrallCheckbox.setSize(dimension);
        thrallCheckbox.setMaximumSize(dimension);
        thrallCheckbox.setToolTipText(checkboxToolTip);
        SwingUtil.removeButtonDecorations((AbstractButton)thrallCheckbox);
        thrallCheckbox.addActionListener(e -> {
            if (this.config.companionThralls()) {
                this.configManager.setConfiguration(CONFIG_GROUP, "companionThralls", (Object)false);
            } else {
                this.configManager.setConfiguration(CONFIG_GROUP, "companionThralls", (Object)true);
            }
            BufferedImage icon = this.config.companionThralls() ? CHECKMARK : NO_CHECKMARK;
            String toolTip = this.config.companionThralls() ? "Disable Companion Thralls" : "Enable Companion Thralls";
            thrallCheckbox.setIcon(new ImageIcon(icon));
            thrallCheckbox.setRolloverIcon(new ImageIcon(ImageUtil.luminanceOffset((Image)icon, (int)-80)));
            thrallCheckbox.setToolTipText(toolTip);
        });
        if (!this.config.showThralls()) {
            this.thrallPanel.setVisible(false);
            this.spacerAndTextForThralls.setVisible(false);
            this.thrallSpacerTop.setVisible(false);
        }
        this.thrallTitlePanel.add(dropDownButton);
        this.thrallTitlePanel.add(Box.createRigidArea(new Dimension(33, 0)));
        this.thrallTitlePanel.add(title);
        this.thrallTitlePanel.add(Box.createRigidArea(new Dimension(36, 0)));
        this.thrallTitlePanel.add(thrallCheckbox);
        return this.thrallTitlePanel;
    }

    private JPanel buildSpacerAndTextForThralls() {
        this.spacerAndTextForThralls.removeAll();
        this.spacerAndTextForThralls.setBorder(new EmptyBorder(0, 5, 0, 2));
        JLabel melee = new JLabel("     Melee ");
        JLabel range = new JLabel("     Range");
        JLabel mage = new JLabel("      Mage");
        mage.setForeground(new Color(46, 169, 255, 89));
        melee.setForeground(new Color(255, 0, 0, 89));
        range.setForeground(new Color(42, 255, 0, 89));
        Font font = FontManager.getRunescapeBoldFont().deriveFont(1, 13.0f);
        melee.setFont(font);
        range.setFont(font);
        mage.setFont(font);
        melee.setBorder(new EmptyBorder(3, 0, 0, 0));
        range.setBorder(new EmptyBorder(3, 0, 0, 0));
        mage.setBorder(new EmptyBorder(3, 0, 0, 0));
        this.spacerAndTextForThralls.add(melee);
        this.spacerAndTextForThralls.add(range);
        this.spacerAndTextForThralls.add(mage);
        this.spacerAndTextForThralls.setLayout(new GridLayout(1, 3, 0, 0));
        return this.spacerAndTextForThralls;
    }

    private JPanel buildThrallSpacerTop() {
        this.thrallSpacerTop.setBorder(new CompoundBorder(new EmptyBorder(-10, 0, 0, 0), new MatteBorder(0, 0, 1, 0, new Color(42, 255, 0, 89))));
        return this.thrallSpacerTop;
    }

    private JPanel buildSpacerPanelTop() {
        this.spacerPanelTop.setBorder(new CompoundBorder(new EmptyBorder(-3, 0, 0, 0), new MatteBorder(0, 0, 1, 0, new Color(42, 255, 0, 89))));
        return this.spacerPanelTop;
    }

    private JPanel buildSpacerPanelBottom() {
        this.spacerPanelBottom.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 0), new MatteBorder(0, 0, 1, 0, new Color(42, 255, 0, 89))));
        return this.spacerPanelBottom;
    }

    private JPanel buildFavPetButtonsPanel() {
        this.favPetButtonsPanel.removeAll();
        this.favPetButtonsPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        List favorites = Arrays.stream(this.config.favorites().split(",")).map(PetData::valueOf).collect(Collectors.toList());
        for (PetData petData : favorites) {
            ImageIcon icon = new ImageIcon((Image)this.itemManager.getImage(petData.getIconID()));
            JButton button = new JButton(icon);
            button.setToolTipText(petData.getName());
            button.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorScheme.DARK_GRAY_COLOR), new EmptyBorder(0, 5, 0, 0)));
            JPopupMenu menu = new JPopupMenu();
            JMenuItem setCurrentPetAsFav = new JMenuItem("Swap With Current Pet");
            setCurrentPetAsFav.addActionListener(e -> this.updateFavPet(petData));
            menu.add(setCurrentPetAsFav);
            this.buildThrallPopUpMenu(petData, menu);
            button.setComponentPopupMenu(menu);
            button.addActionListener(e -> this.clientThread.invokeLater(() -> this.plugin.updatePet(petData)));
            this.favPetButtonsPanel.add(button);
        }
        this.favPetButtonsPanel.setLayout(new GridLayout(1, 4, 2, 2));
        return this.favPetButtonsPanel;
    }

    private JPanel buildThrallPanel() {
        this.thrallPanel.removeAll();
        ArrayList<PetData> thralls = new ArrayList<PetData>();
        thralls.add(this.config.meleeThrall());
        thralls.add(this.config.rangeThrall());
        thralls.add(this.config.mageThrall());
        for (PetData petData : thralls) {
            ImageIcon icon = new ImageIcon((Image)this.itemManager.getImage(petData.getIconID()));
            JLabel label = new JLabel(icon);
            label.setToolTipText(petData.getName());
            label.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorScheme.DARK_GRAY_COLOR), new EmptyBorder(0, 5, 0, 0)));
            JPopupMenu menu = new JPopupMenu();
            JMenuItem setCurrentPetAsThrall = new JMenuItem("Set Current Pet As Thrall");
            setCurrentPetAsThrall.addActionListener(e -> {
                switch (thralls.indexOf((Object)petData)) {
                    case 0: {
                        this.configManager.setConfiguration(CONFIG_GROUP, "meleeThrall", (Object)this.plugin.petData);
                        this.updateThrallPanel();
                        break;
                    }
                    case 1: {
                        this.configManager.setConfiguration(CONFIG_GROUP, "rangeThrall", (Object)this.plugin.petData);
                        this.updateThrallPanel();
                        break;
                    }
                    case 2: {
                        this.configManager.setConfiguration(CONFIG_GROUP, "mageThrall", (Object)this.plugin.petData);
                        this.updateThrallPanel();
                    }
                }
            });
            menu.add(setCurrentPetAsThrall);
            label.setComponentPopupMenu(menu);
            this.thrallPanel.add(label);
        }
        this.thrallPanel.setBorder(new EmptyBorder(0, 0, -5, 2));
        this.thrallPanel.setLayout(new GridLayout(1, 3, 0, 0));
        return this.thrallPanel;
    }

    private void buildThrallPopUpMenu(PetData petData, JPopupMenu menu) {
        JMenuItem meleeThrall = new JMenuItem("Set Melee Thrall");
        JMenuItem rangeThrall = new JMenuItem("Set Range Thrall");
        JMenuItem mageThrall = new JMenuItem("Set Mage Thrall");
        meleeThrall.addActionListener(e -> {
            this.configManager.setConfiguration(CONFIG_GROUP, "meleeThrall", (Object)petData);
            this.updateThrallPanel();
        });
        rangeThrall.addActionListener(e -> {
            this.configManager.setConfiguration(CONFIG_GROUP, "rangeThrall", (Object)petData);
            this.updateThrallPanel();
        });
        mageThrall.addActionListener(e -> {
            this.configManager.setConfiguration(CONFIG_GROUP, "mageThrall", (Object)petData);
            this.updateThrallPanel();
        });
        menu.add(meleeThrall);
        menu.add(rangeThrall);
        menu.add(mageThrall);
    }

    private void updateThrallPanel() {
        this.buildThrallPanel();
        this.clientThread.invokeAtTickEnd(() -> {
            this.thrallPanel.revalidate();
            this.thrallPanel.repaint();
        });
    }

    private void updateFavPet(PetData petData) {
        if (this.plugin.petData.equals((Object)petData) || this.config.favorites().contains(this.plugin.petData.toString())) {
            return;
        }
        String s = this.config.favorites();
        s = s.replaceFirst(petData.toString(), this.plugin.petData.toString());
        this.configManager.setConfiguration(CONFIG_GROUP, "favorites", s);
        this.buildFavPetButtonsPanel();
        this.clientThread.invokeAtTickEnd(() -> {
            this.favPetButtonsPanel.revalidate();
            this.favPetButtonsPanel.repaint();
        });
    }

    private JPanel buildSpacerPanelFavPets() {
        this.spacerPanelFavPets.setBorder(new CompoundBorder(new EmptyBorder(-5, 0, 0, 0), new MatteBorder(0, 0, 1, 0, new Color(42, 255, 0, 89))));
        return this.spacerPanelFavPets;
    }

    private JPanel buildPetButtonsPanel() {
        PetData[] petList;
        this.petButtonsPanel.removeAll();
        this.petButtonsPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        for (PetData petData : petList = this.config.filter() ? PetData.values() : PetData.petsToShow.toArray(new PetData[0])) {
            if (!petData.isWorking() && !this.config.allowBrokenPets()) continue;
            ImageIcon icon = new ImageIcon((Image)this.itemManager.getImage(petData.getIconID()));
            JButton button = new JButton(icon);
            button.setToolTipText(petData.getName());
            button.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorScheme.DARK_GRAY_COLOR), new EmptyBorder(0, 5, 0, 0)));
            JPopupMenu menu = new JPopupMenu();
            this.buildThrallPopUpMenu(petData, menu);
            button.setComponentPopupMenu(menu);
            button.addActionListener(e -> this.clientThread.invokeLater(() -> this.plugin.updatePet(petData)));
            this.petButtonsPanel.add(button);
        }
        int rowSize = (this.petButtonsPanel.getComponents().length % 4 == 0 ? 0 : 1) + this.petButtonsPanel.getComponents().length / 4;
        this.petButtonsPanel.setLayout(new GridLayout(rowSize, 4, 2, 2));
        return this.petButtonsPanel;
    }
}

