/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.CompanionPetConfig;
import com.example.CompanionPetPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class CompanionPetOverlay
extends Overlay {
    private CompanionPetPlugin plugin;
    private Client client;
    private CompanionPetConfig config;

    @Inject
    public CompanionPetOverlay(CompanionPetPlugin plugin, Client client, CompanionPetConfig config) {
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.debug() && this.plugin.petPoly != null && this.plugin.pet != null && this.plugin.pet.isActive() && this.plugin.pet.getLocalLocation() != null) {
            if (this.plugin.petPoly.contains((double)this.client.getMouseCanvasPosition().getX(), (double)this.client.getMouseCanvasPosition().getY())) {
                graphics.setColor(Color.GREEN);
            } else {
                graphics.setColor(Color.WHITE);
            }
            graphics.draw((Shape)this.plugin.petPoly);
            graphics.draw(Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)this.plugin.pet.getLocalLocation(), (int)this.plugin.petData.getSize()));
            for (WorldPoint worldPoint : this.plugin.pet.getWorldArea().toWorldPointList()) {
                graphics.draw(Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint)));
            }
            graphics.setFont(FontManager.getRunescapeBoldFont());
        }
        return null;
    }
}

