/*
 * Decompiled with CFR 0.152.
 */
package sh.bitwise.runelite;

import com.google.inject.Provides;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sh.bitwise.runelite.Snow;
import sh.bitwise.runelite.SnowOverlay;
import sh.bitwise.runelite.SnowTrackerConfig;

@PluginDescriptor(name="Snow Tracker", description="Tracks snow on the ground", tags={"snow", "track", "tracker", "time", "timer"})
public class SnowTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SnowTrackerPlugin.class);
    private static final String SNOW_MESSAGE = "You made some snow fall!";
    private final List<Snow> snowList = new LinkedList<Snow>();
    @Inject
    private Client client;
    @Inject
    private SnowOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    private WorldPoint playerLocation;

    @Provides
    SnowTrackerConfig provideConfig(ConfigManager configManager) {
        return (SnowTrackerConfig)configManager.getConfig(SnowTrackerConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.snowList.clear();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (Objects.equals(event.getMessage(), SNOW_MESSAGE)) {
            log.debug("Snow created by current player at {}", (Object)this.playerLocation);
            this.snowList.add(new Snow(this.playerLocation));
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.snowList.forEach(Snow::decrement);
        this.snowList.removeIf(snow -> snow.getTicksLeft() < 0);
        Player player = this.client.getLocalPlayer();
        if (null != player) {
            player.getLocalLocation();
            this.playerLocation = player.getWorldLocation();
        }
    }

    public List<Snow> getSnowList() {
        return this.snowList;
    }
}

