/*
 * Decompiled with CFR 0.152.
 */
package sh.bitwise.runelite;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import sh.bitwise.runelite.Constants;

@ConfigGroup(value="snowtracker")
public interface SnowTrackerConfig
extends Config {
    @ConfigSection(name="Background Settings", description="All settings relating to the timer background", position=100)
    public static final String backgroundSettings = "backgroundSettings";

    @Alpha
    @ConfigItem(keyName="textColor", name="Text Color", description="Color of normal timer text", position=0)
    default public Color getTextColor() {
        return Constants.COLOR_TEXT;
    }

    @Alpha
    @ConfigItem(keyName="warningColor", name="Warning Color", description="Color of warning timer text", position=1)
    default public Color getWarningColor() {
        return Constants.COLOR_WARNING;
    }

    @Range(max=24)
    @ConfigItem(keyName="warningThreshold", name="Warning Threshold", description="When the ticks drop BELOW this number, the warning color is applied.\nNOTE: 0 effectively disables the warning color.", position=2)
    default public int getWarningThreshold() {
        return 7;
    }

    @Alpha
    @ConfigItem(keyName="errorColor", name="Error Color", description="Color of error timer text", position=3)
    default public Color getErrorColor() {
        return Constants.COLOR_ERROR;
    }

    @Range(max=24)
    @ConfigItem(keyName="errorThreshold", name="Error Threshold", description="When the ticks drop BELOW this number, the error color is applied.\nNOTE: 0 effectively disables the error color.", position=4)
    default public int getErrorThreshold() {
        return 1;
    }

    @ConfigItem(keyName="enableTextOutline", name="Outline Text", description="If the timer text should have an outline", position=5)
    default public boolean getEnableTextOutline() {
        return false;
    }

    @ConfigItem(keyName="enableBackground", name="Enable Background", description="If the timer background should be enabled", position=0, section="backgroundSettings")
    default public boolean getEnableBackground() {
        return true;
    }

    @Range(min=16, max=30)
    @ConfigItem(keyName="backgroundSize", name="Background Size", description="How large the timer background should be", position=1, section="backgroundSettings")
    default public int getBackgroundSize() {
        return 18;
    }

    @Alpha
    @ConfigItem(keyName="backgroundColor", name="Background Color", description="Color of background box surrounding the timer", position=2, section="backgroundSettings")
    default public Color getBackgroundColor() {
        return Constants.COLOR_BACKGROUND;
    }
}

