/*
 * Decompiled with CFR 0.152.
 */
package sh.bitwise.runelite;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import sh.bitwise.runelite.SnowTrackerConfig;
import sh.bitwise.runelite.SnowTrackerPlugin;

public class SnowOverlay
extends Overlay {
    private final SnowTrackerPlugin plugin;
    private final SnowTrackerConfig config;
    private final Client client;

    @Inject
    SnowOverlay(SnowTrackerPlugin plugin, SnowTrackerConfig config, Client client) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        Color colorText = this.config.getTextColor();
        boolean shouldOutline = this.config.getEnableTextOutline();
        Color colorWarning = this.config.getWarningColor();
        int thresholdWarning = this.config.getWarningThreshold();
        Color colorError = this.config.getErrorColor();
        int thresholdError = this.config.getErrorThreshold();
        Color colorBackground = this.config.getBackgroundColor();
        int backgroundSize = this.config.getBackgroundSize();
        boolean backgroundEnabled = this.config.getEnableBackground();
        this.plugin.getSnowList().forEach(snow -> {
            String text = snow.getTicksLeftDisplay();
            LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)snow.getLocation());
            if (localPoint != null) {
                int counter = snow.getTicksLeft();
                Color color = counter < thresholdError ? colorError : (counter < thresholdWarning ? colorWarning : colorText);
                Point point = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)localPoint, (String)text, (int)0);
                Rectangle2D textBounds = graphics.getFontMetrics().getStringBounds(text, graphics);
                if (backgroundEnabled) {
                    this.drawTextBackground(graphics, point, colorBackground, textBounds, backgroundSize);
                }
                this.drawText(graphics, point, color, shouldOutline, text);
            }
        });
        return null;
    }

    private void drawTextBackground(Graphics2D graphics, Point point, Color color, Rectangle2D textBounds, int size) {
        graphics.setColor(color);
        int x = (int)((double)(point.getX() - size / 2) + textBounds.getWidth() / 2.0);
        int y = (int)((double)(point.getY() - size / 2) - textBounds.getHeight() / 2.0);
        graphics.fillRect(x, y, size, size);
    }

    private void drawText(Graphics2D graphics, Point point, Color color, boolean shouldOutline, String text) {
        int x = point.getX();
        int y = point.getY();
        if (shouldOutline) {
            graphics.setColor(Color.BLACK);
            graphics.drawString(text, x + 1, y + 1);
        }
        graphics.setColor(color);
        graphics.drawString(text, x, y);
    }
}

