/*
 * Decompiled with CFR 0.152.
 */
package de0.coxvanguards;

import com.google.inject.Provides;
import de0.coxvanguards.CoxVanguardsConfig;
import de0.coxvanguards.CoxVanguardsDatabox;
import de0.coxvanguards.CoxVanguardsHighlight;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="CoX Vanguards", description="Adds a highlight and indicates HPs for Vanguards")
public class CoxVanguardsPlugin
extends Plugin {
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private CoxVanguardsHighlight highlight;
    @Inject
    private CoxVanguardsDatabox databox;
    private boolean in_raid;
    int solo_base_hp;
    NPC melee;
    NPC range;
    NPC mage;
    int melhp;
    int rnghp;
    int maghp;
    int melhp_fine;
    int rnghp_fine;
    int maghp_fine;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.highlight);
        this.overlayManager.add((Overlay)this.databox);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.highlight);
        this.overlayManager.remove((Overlay)this.databox);
    }

    @Provides
    CoxVanguardsConfig provideConfig(ConfigManager configManager) {
        return (CoxVanguardsConfig)configManager.getConfig(CoxVanguardsConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        boolean in_raid;
        boolean bl = in_raid = this.client.getVarbitValue(5432) != 0;
        if (this.in_raid != in_raid) {
            if (in_raid) {
                this.maghp_fine = this.solo_base_hp = this.getSoloBaseHp();
                this.rnghp_fine = this.solo_base_hp;
                this.melhp_fine = this.solo_base_hp;
            } else {
                this.mage = null;
                this.range = null;
                this.melee = null;
                this.overlayManager.remove((Overlay)this.databox);
            }
            this.in_raid = in_raid;
        }
    }

    @Subscribe
    public void onClientTick(ClientTick e) {
        if (this.melee != null && this.melee.getHealthRatio() > 0) {
            this.melhp = this.melee.getHealthRatio();
        }
        if (this.range != null && this.range.getHealthRatio() > 0) {
            this.rnghp = this.range.getHealthRatio();
        }
        if (this.mage != null && this.mage.getHealthRatio() > 0) {
            this.maghp = this.mage.getHealthRatio();
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned e) {
        NPC npc = e.getNpc();
        if (this.melee == null && npc.getId() == 7527) {
            this.melee = npc;
        } else if (this.range == null && npc.getId() == 7528) {
            this.range = npc;
        } else if (this.mage == null && npc.getId() == 7529) {
            this.mage = npc;
        }
    }

    @Subscribe
    public void onNpcChanged(NpcChanged e) {
        NPC npc = e.getNpc();
        if (npc.getId() == 7527 && this.melee == null) {
            this.melee = npc;
        } else if (npc.getId() == 7528 && this.range == null) {
            this.range = npc;
        } else if (npc.getId() == 7529 && this.mage == null) {
            this.mage = npc;
        } else if (npc.getId() == 7526) {
            if (npc == this.melee) {
                this.melhp_fine = Math.min(this.solo_base_hp, this.melhp_fine + 1);
            } else if (npc == this.range) {
                this.rnghp_fine = Math.min(this.solo_base_hp, this.rnghp_fine + 1);
            } else if (npc == this.mage) {
                this.maghp_fine = Math.min(this.solo_base_hp, this.maghp_fine + 1);
            }
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned e) {
        NPC npc = e.getNpc();
        if (npc == this.melee) {
            this.melee = null;
        } else if (npc == this.range) {
            this.range = null;
        } else if (npc == this.mage) {
            this.mage = null;
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied e) {
        if (!this.isSolo()) {
            return;
        }
        if (!(e.getActor() instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)e.getActor();
        if (npc == null || npc.getId() < 7526 || npc.getId() > 7529) {
            return;
        }
        int hs = e.getHitsplat().getHitsplatType();
        if (hs == 6) {
            this.melhp_fine = this.solo_base_hp;
            this.rnghp_fine = this.solo_base_hp;
            this.maghp_fine = this.solo_base_hp;
        } else if (hs == 16 || hs == 17 || hs == 43) {
            int amt = e.getHitsplat().getAmount();
            if (npc == this.melee) {
                this.melhp_fine -= amt;
            } else if (npc == this.range) {
                this.rnghp_fine -= amt;
            } else if (npc == this.mage) {
                this.maghp_fine -= amt;
            }
        }
    }

    boolean isSolo() {
        return this.client.getVarbitValue(5424) == 1;
    }

    int getSoloBaseHp() {
        boolean cm;
        int base_hp = 180;
        base_hp = base_hp * this.client.getLocalPlayer().getCombatLevel() / 126;
        boolean bl = cm = this.client.getVarbitValue(6385) != 0;
        if (cm) {
            base_hp = base_hp * 3 / 2;
        }
        return base_hp;
    }
}

