/*
 * Decompiled with CFR 0.152.
 */
package de0.coxvanguards;

import de0.coxvanguards.CoxVanguardsConfig;
import de0.coxvanguards.CoxVanguardsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class CoxVanguardsHighlight
extends Overlay {
    private CoxVanguardsPlugin plugin;
    private CoxVanguardsConfig config;

    @Inject
    public CoxVanguardsHighlight(CoxVanguardsPlugin plugin, CoxVanguardsConfig config) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D g) {
        if (this.plugin.melee != null) {
            this.renderVanguard(this.plugin.melee, this.plugin.melhp, this.plugin.melhp_fine, g, this.config.getMeleeColor());
        }
        if (this.plugin.range != null) {
            this.renderVanguard(this.plugin.range, this.plugin.rnghp, this.plugin.rnghp_fine, g, this.config.getRangeColor());
        }
        if (this.plugin.mage != null) {
            this.renderVanguard(this.plugin.mage, this.plugin.maghp, this.plugin.maghp_fine, g, this.config.getMageColor());
        }
        return null;
    }

    private void renderVanguard(NPC van, int last_hp, int hp_fine, Graphics2D g, Color c) {
        Shape s;
        if (van.getId() < 7525 || van.getId() > 7529) {
            return;
        }
        if (this.config.highlight() && (s = van.getConvexHull()) != null) {
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 50));
            g.fill(s);
        }
        if (this.config.showDmgToReset() && this.plugin.isSolo()) {
            boolean goodToClear;
            int rt = this.plugin.solo_base_hp * 4 / 10 - 1;
            int mel = this.plugin.melhp_fine;
            int rng = this.plugin.rnghp_fine;
            int mag = this.plugin.maghp_fine;
            int hi = Math.max(Math.max(mel, rng), mag);
            int lo = Math.min(Math.min(mel, rng), mag);
            int mid = mel ^ rng ^ mag ^ hi ^ lo;
            int thres = Math.max(0, (hp_fine == hi ? mid : hi) - rt);
            int dist = hp_fine - thres;
            boolean goodToKill = hp_fine < rt;
            boolean bl = goodToClear = mel < rt && rng < rt && mag < rt;
            if (!goodToClear) {
                Object str = goodToKill ? "*" + dist : Integer.toString(dist);
                this.npctext(g, van, (String)str, c);
            }
        } else if (this.config.showHps()) {
            int hp = van.getHealthRatio();
            if (hp < 0) {
                hp = last_hp;
            }
            int hpPercent = hp * 100 / 30;
            String str = Integer.toString(hpPercent);
            this.npctext(g, van, str, c);
        }
    }

    private void npctext(Graphics2D g, NPC npc, String str, Color c) {
        Point point = npc.getCanvasTextLocation(g, str, npc.getLogicalHeight());
        if (point == null) {
            return;
        }
        point = new Point(point.getX(), point.getY() + 20);
        g.setFont(FontManager.getRunescapeBoldFont());
        OverlayUtil.renderTextLocation((Graphics2D)g, (Point)point, (String)str, (Color)c);
    }
}

