/*
 * Decompiled with CFR 0.152.
 */
package de0.coxvanguards;

import de0.coxvanguards.CoxVanguardsConfig;
import de0.coxvanguards.CoxVanguardsPlugin;
import de0.util.CoxUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class CoxVanguardsDatabox
extends Overlay {
    private CoxVanguardsPlugin plugin;
    private CoxVanguardsConfig config;
    private Client client;
    private PanelComponent panelComponent;

    @Inject
    public CoxVanguardsDatabox(CoxVanguardsPlugin plugin, CoxVanguardsConfig config, Client client) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.panelComponent = new PanelComponent();
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Vanguards").build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Melee").leftColor(Color.RED).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Range").leftColor(Color.GREEN).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Mage").leftColor(Color.CYAN).build());
    }

    public Dimension render(Graphics2D g) {
        if (!this.config.showDatabox()) {
            return null;
        }
        WorldPoint wp = this.client.getLocalPlayer().getWorldLocation();
        int plane = this.client.getPlane();
        int x = wp.getX() - this.client.getBaseX();
        int y = wp.getY() - this.client.getBaseY();
        int type = CoxUtil.getroom_type(this.client.getInstanceTemplateChunks()[plane][x / 8][y / 8]);
        if (type == 6) {
            List elems = this.panelComponent.getChildren();
            ((LineComponent)elems.get(1)).setRight(Integer.toString(this.plugin.melhp * 100 / 30));
            ((LineComponent)elems.get(2)).setRight(Integer.toString(this.plugin.rnghp * 100 / 30));
            ((LineComponent)elems.get(3)).setRight(Integer.toString(this.plugin.maghp * 100 / 30));
            return this.panelComponent.render(g);
        }
        return null;
    }
}

