/*
 * Decompiled with CFR 0.152.
 */
package de0.coxtimers;

import com.google.inject.Provides;
import de0.coxtimers.CoxTimersConfig;
import de0.coxtimers.PreciseTimersSetting;
import de0.util.CoxUtil;
import de0.util.MiscUtil;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="CoX Timers", description="Time tracking for CoX rooms")
public class CoxTimersPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private CoxTimersConfig config;
    private boolean in_raid;
    private int split;
    private int split_fl;
    private int split_sub;
    private int[] cryp = new int[16];
    private int[] cryx = new int[16];
    private int[] cryy = new int[16];
    private int olm_phase;
    private boolean iceout;
    private boolean treecut;
    private static final String FL_COMPLETE_MES = "level complete! Duration: </col><col=ff0000>";
    private static final int SMOKE_PUFF = 188;

    @Provides
    CoxTimersConfig provideConfig(ConfigManager configManager) {
        return (CoxTimersConfig)configManager.getConfig(CoxTimersConfig.class);
    }

    @Subscribe
    public void onClientTick(ClientTick e) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.clock() == 0 || !this.client.isInInstancedRegion()) {
            this.in_raid = false;
            return;
        }
        if (!this.in_raid) {
            this.in_raid = true;
            this.split = 0;
            this.split_fl = 0;
            this.split_sub = 0;
            this.olm_phase = -1;
            this.iceout = false;
            this.treecut = false;
        }
        for (int i = 0; i < 16; ++i) {
            if (this.cryp[i] == -1) continue;
            int p = this.cryp[i];
            int x = this.cryx[i] - this.client.getBaseX();
            int y = this.cryy[i] - this.client.getBaseY();
            if (p != this.client.getPlane() || x < 0 || x >= 104 || y < 0 || y >= 104) {
                this.cryp[i] = -1;
                continue;
            }
            int flags = this.client.getCollisionMaps()[p].getFlags()[x][y];
            if ((flags & 0x100) != 0) continue;
            StringBuilder mes = new StringBuilder();
            mes.append(CoxUtil.getroom_sort(i) == 'C' ? "Combat room `" : "Puzzle `");
            mes.append(CoxUtil.getroom_name(i));
            mes.append("` complete! Duration: <col=ff0000>");
            mes.append(this.to_mmss(this.clock() - this.split));
            mes.append("</col> Total: <col=ff0000>");
            mes.append(this.to_mmss(this.clock()));
            mes.append("</col>");
            this.fc_mes(mes.toString());
            this.split = this.split_sub = this.clock();
            this.cryp[i] = -1;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        String mes = e.getMessage();
        if (e.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION && mes.startsWith("<col=ef20ff>")) {
            int duration = mes.indexOf(FL_COMPLETE_MES);
            boolean is_fl_time = duration != -1;
            boolean is_olm_time = mes.contains("<br>");
            boolean is_top_floor = mes.contains("Upper");
            if (!is_fl_time && !is_olm_time) {
                return;
            }
            if (is_olm_time) {
                e.getMessageNode().setValue(mes + " Olm duration: <col=ff0000>" + this.to_mmss(this.clock() - this.split_fl) + "</col>");
            } else if (!is_top_floor) {
                String before = mes.substring(0, duration + FL_COMPLETE_MES.length());
                String after = mes.substring(duration + FL_COMPLETE_MES.length());
                e.getMessageNode().setValue(before + this.to_mmss(this.clock() - this.split_fl) + "</col> Total: <col=ff0000>" + after);
            }
            this.split_sub = this.split_fl = this.clock();
            this.split = this.split_fl;
        } else if (this.config.showOlmPhaseTimers() && e.getType() == ChatMessageType.GAMEMESSAGE && mes.equals("The Great Olm is giving its all. This is its final stand.")) {
            this.splitphase();
            this.olm_phase = 99;
        }
    }

    private void splitphase() {
        StringBuilder mes = new StringBuilder();
        if (this.olm_phase == 99) {
            mes.append("Olm head");
        } else {
            mes.append("Olm phase ");
            mes.append(++this.olm_phase);
        }
        mes.append(" duration: <col=ff0000>");
        mes.append(this.to_mmss(this.clock() - this.split));
        mes.append("</col>");
        if (this.olm_phase != 99) {
            mes.append(" Total: <col=ff0000>");
            mes.append(this.to_mmss(this.clock()));
            mes.append("</col>");
        }
        this.fc_mes(mes.toString());
        this.split = this.clock();
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        GameObject go = e.getGameObject();
        switch (go.getId()) {
            case 29881: {
                if (this.olm_phase >= 0) break;
                this.split = this.clock();
                this.olm_phase ^= 0xFFFFFFFF;
                break;
            }
            case 29767: {
                if (this.client.getVarbitValue(6385) != 0) break;
                this.split_sub = this.clock();
                break;
            }
            case 30013: {
                if (!this.config.showMuttadileTreeCutTime() || this.treecut) break;
                StringBuilder mes = new StringBuilder("Muttadile tree cut duration: <col=ff0000>");
                mes.append(this.to_mmss(this.clock() - this.split_sub));
                mes.append("</col>");
                mes.append(" Total: <col=ff0000>");
                mes.append(this.to_mmss(this.clock()));
                mes.append("</col>");
                this.fc_mes(mes.toString());
                this.treecut = true;
                break;
            }
            case 26209: 
            case 29741: 
            case 29749: 
            case 29753: 
            case 29754: 
            case 29755: 
            case 29756: 
            case 29757: 
            case 29876: 
            case 30016: 
            case 30017: 
            case 30018: 
            case 30070: {
                Point pt = go.getSceneMinLocation();
                int p = go.getPlane();
                int x = pt.getX();
                int y = pt.getY();
                int template = this.client.getInstanceTemplateChunks()[p][x / 8][y / 8];
                int roomtype = CoxUtil.getroom_type(template);
                if (roomtype >= 16) break;
                this.cryp[roomtype] = p;
                this.cryx[roomtype] = x + this.client.getBaseX();
                this.cryy[roomtype] = y + this.client.getBaseY();
            }
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned e) {
        if (this.config.showOlmPhaseTimers() && e.getGameObject().getId() == 29881) {
            this.splitphase();
            this.olm_phase ^= 0xFFFFFFFF;
        }
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated e) {
        if (this.config.showIcePopTime() && e.getGraphicsObject().getId() == 188 && !this.iceout) {
            WorldPoint wp = WorldPoint.fromLocal((Client)this.client, (LocalPoint)e.getGraphicsObject().getLocation());
            int p = this.client.getPlane();
            int x = wp.getX() - this.client.getBaseX();
            int y = wp.getY() - this.client.getBaseY();
            int template = this.client.getInstanceTemplateChunks()[p][x / 8][y / 8];
            if (CoxUtil.getroom_type(template) == 12) {
                StringBuilder mes = new StringBuilder("Ice Demon pop duration: <col=ff0000>");
                mes.append(this.to_mmss(this.clock() - this.split));
                mes.append("</col>");
                mes.append(" Total: <col=ff0000>");
                mes.append(this.to_mmss(this.clock()));
                mes.append("</col>");
                this.fc_mes(mes.toString());
                this.iceout = true;
            }
        }
    }

    private void fc_mes(String mes) {
        this.client.addChatMessage(ChatMessageType.FRIENDSCHATNOTIFICATION, "", mes, null);
    }

    private int clock() {
        return this.client.getVarbitValue(6386);
    }

    private String to_mmss(int ticks) {
        boolean ingame_setting;
        PreciseTimersSetting setting = this.config.preciseTimers();
        boolean bl = ingame_setting = this.client.getVarbitValue(11866) == 1;
        if (setting == PreciseTimersSetting.TICK_PRECISION || setting == PreciseTimersSetting.RESPECT_INGAME_SETTING && ingame_setting) {
            return MiscUtil.to_mmss_precise(ticks);
        }
        return MiscUtil.to_mmss(ticks);
    }
}

