/*
 * Decompiled with CFR 0.152.
 */
package de0.coxthieving;

import com.google.inject.Provides;
import de0.coxthieving.ChestData;
import de0.coxthieving.ChestHighlight;
import de0.coxthieving.CoxThievingConfig;
import de0.coxthieving.CoxThievingDatabox;
import de0.coxthieving.ScavHighlight;
import de0.util.CoxUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.ToIntFunction;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.InventoryID;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="CoX Thieving", description="Finds bat chests and counts grubs at thieving room in CoX")
public class CoxThievingPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ChestHighlight overlay;
    @Inject
    private CoxThievingDatabox grubOverlay;
    @Inject
    private ScavHighlight scavOverlay;
    @Inject
    private CoxThievingConfig config;
    static final int CCHEST = 29742;
    static final int PCHEST = 29743;
    static final int ECHEST = 29744;
    static final int GCHEST = 29745;
    private int roomtype = -1;
    private int plane;
    private int base_x;
    private int base_y;
    int room_base_x;
    int room_base_y;
    int rot;
    int wind;
    byte soln = (byte)-1;
    Set<Byte> not_solns = new HashSet<Byte>();
    private int last_grubs;
    int num_grubs;
    GrubCollection gc_local;
    GrubCollection[] gc_others = new GrubCollection[99];
    int gc_others_count = 0;
    Comparator<GrubCollection> comparator = Comparator.comparingInt(new ToIntFunction<GrubCollection>(){

        @Override
        public int applyAsInt(GrubCollection v) {
            if (v == CoxThievingPlugin.this.gc_local) {
                return -CoxThievingPlugin.this.num_grubs;
            }
            return -v.num_with_grubs * CoxThievingPlugin.this.config.grubRate() / 100;
        }
    });

    @Provides
    CoxThievingConfig getConfig(ConfigManager configManager) {
        return (CoxThievingConfig)configManager.getConfig(CoxThievingConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        if (this.client.getVarbitValue(5432) == 0) {
            if (this.roomtype != -1) {
                try {
                    this.shutDown();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return;
        }
        int plane = this.client.getPlane();
        int base_x = this.client.getBaseX();
        int base_y = this.client.getBaseY();
        if (this.base_x != base_x || this.base_y != base_y || this.plane != plane) {
            this.base_x = base_x;
            this.base_y = base_y;
            this.plane = plane;
            this.searchForThieving();
        }
        WorldPoint wp = this.client.getLocalPlayer().getWorldLocation();
        int x = wp.getX() - this.client.getBaseX();
        int y = wp.getY() - this.client.getBaseY();
        int type = CoxUtil.getroom_type(this.client.getInstanceTemplateChunks()[plane][x / 8][y / 8]);
        if (type != this.roomtype) {
            if (type == 13) {
                this.overlayManager.add((Overlay)this.overlay);
                this.overlayManager.add((Overlay)this.grubOverlay);
                this.overlayManager.add((Overlay)this.scavOverlay);
            } else if (this.roomtype == 13) {
                this.overlayManager.remove((Overlay)this.overlay);
                this.overlayManager.remove((Overlay)this.grubOverlay);
                this.overlayManager.remove((Overlay)this.scavOverlay);
            }
            this.roomtype = type;
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        int chestY;
        int chestX;
        GameObject obj = e.getGameObject();
        if (obj.getId() != 29743 && obj.getId() != 29744 && obj.getId() != 29745) {
            return;
        }
        Point p = e.getTile().getSceneLocation();
        int x = p.getX();
        int y = p.getY();
        if (this.rot == 0) {
            chestX = x - this.room_base_x;
            chestY = y - this.room_base_y;
        } else if (this.rot == 1) {
            chestX = this.room_base_y - y;
            chestY = x - this.room_base_x;
        } else if (this.rot == 2) {
            chestX = this.room_base_x - x;
            chestY = this.room_base_y - y;
        } else {
            chestX = y - this.room_base_y;
            chestY = this.room_base_x - x;
        }
        byte chestno = this.coordToChestNo(chestX, chestY);
        boolean opened = false;
        boolean grub = false;
        if (obj.getId() == 29744 || obj.getId() == 29745) {
            byte notsoln = this.solve(chestno);
            if (notsoln != -1) {
                this.not_solns.add(notsoln);
            }
            opened = true;
        }
        if (obj.getId() == 29745) {
            grub = true;
        } else if (obj.getId() == 29743 && this.soln == -1) {
            this.soln = this.solve(chestno);
        }
        if (opened) {
            int angle = obj.getOrientation() >> 9;
            int px = x + (angle == 1 ? -1 : (angle == 3 ? 1 : 0));
            int py = y + (angle == 0 ? -1 : (angle == 2 ? 1 : 0));
            for (Player pl : this.client.getPlayers()) {
                WorldPoint wp = pl.getWorldLocation();
                int plx = wp.getX() - this.client.getBaseX();
                int ply = wp.getY() - this.client.getBaseY();
                if (plx != px || ply != py) continue;
                if (grub && pl == this.client.getLocalPlayer()) {
                    this.add_grubs_local();
                    break;
                }
                if (grub) {
                    this.add_grubs_other(pl);
                    break;
                }
                this.add_empty(pl);
                break;
            }
        }
    }

    private void add_grubs_local() {
        GrubCollection gc = this.gc_local;
        if (gc == null) {
            gc = this.gc_local = new GrubCollection();
            gc.displayname = this.client.getLocalPlayer().getName();
        }
        int grubs = this.client.getItemContainer(InventoryID.INVENTORY).count(20885);
        this.num_grubs += grubs - this.last_grubs;
        this.last_grubs = grubs;
        ++gc.num_opened;
        ++gc.num_with_grubs;
    }

    private void add_grubs_other(Player pl) {
        GrubCollection gc = null;
        int hash = pl.getName().hashCode();
        for (int i = 0; i < this.gc_others_count; ++i) {
            if (hash != this.gc_others[i].displayname.hashCode()) continue;
            gc = this.gc_others[i];
            break;
        }
        if (gc == null) {
            GrubCollection grubCollection = new GrubCollection();
            this.gc_others[this.gc_others_count++] = grubCollection;
            gc = grubCollection;
            gc.displayname = pl.getName();
        }
        ++gc.num_opened;
        ++gc.num_with_grubs;
        Arrays.sort(this.gc_others, 0, this.gc_others_count, this.comparator);
    }

    private void add_empty(Player pl) {
        int hash;
        GrubCollection gc = this.gc_local;
        if (gc == null) {
            gc = this.gc_local = new GrubCollection();
            gc.displayname = this.client.getLocalPlayer().getName();
        }
        if ((hash = pl.getName().hashCode()) != gc.displayname.hashCode()) {
            gc = null;
            for (int i = 0; i < this.gc_others_count; ++i) {
                if (hash != this.gc_others[i].displayname.hashCode()) continue;
                gc = this.gc_others[i];
                break;
            }
            if (gc == null) {
                GrubCollection grubCollection = new GrubCollection();
                this.gc_others[this.gc_others_count++] = grubCollection;
                gc = grubCollection;
                gc.displayname = pl.getName();
            }
        }
        ++gc.num_opened;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged e) {
        if (e.getContainerId() == 93) {
            this.last_grubs = e.getItemContainer().count(20885);
        }
    }

    private void searchForThieving() {
        int[][] templates = this.client.getInstanceTemplateChunks()[this.plane];
        for (int cx = 0; cx < 13; cx += 4) {
            for (int cy = 0; cy < 13; cy += 4) {
                int template = templates[cx][cy];
                int tx = template >> 14 & 0x3FF;
                int ty = template >> 3 & 0x7FF;
                if (CoxUtil.getroom_type(template) != 13) continue;
                this.rot = CoxUtil.room_rot(template);
                if (this.rot == 0) {
                    this.room_base_x = cx - (tx & 3) << 3;
                    this.room_base_y = cy - (ty & 3) << 3;
                } else if (this.rot == 1) {
                    this.room_base_x = cx - (ty & 3) << 3;
                    this.room_base_y = cy + (tx & 3) << 3 | 7;
                } else if (this.rot == 2) {
                    this.room_base_x = cx + (tx & 3) << 3 | 7;
                    this.room_base_y = cy + (ty & 3) << 3 | 7;
                } else if (this.rot == 3) {
                    this.room_base_x = cx + (ty & 3) << 3 | 7;
                    this.room_base_y = cy - (tx & 3) << 3;
                }
                this.wind = CoxUtil.room_winding(template);
            }
        }
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.grubOverlay);
        this.overlayManager.remove((Overlay)this.scavOverlay);
        this.not_solns.clear();
        this.gc_local = null;
        for (int i = 0; i < this.gc_others_count; ++i) {
            this.gc_others[i] = null;
        }
        this.gc_others_count = 0;
        this.num_grubs = 0;
        this.last_grubs = 0;
        this.soln = (byte)-1;
        this.roomtype = -1;
    }

    private byte solve(byte poisonchestno) {
        byte[][] solns = ChestData.CHEST_SOLNS[this.wind][this.rot];
        for (byte i = 0; i < solns.length; i = (byte)((byte)(i + 1))) {
            for (int j = 0; j < solns[i].length; j = (int)((byte)(j + 1))) {
                if (solns[i][j] != poisonchestno) continue;
                return i;
            }
        }
        return -1;
    }

    private byte coordToChestNo(int x, int y) {
        byte[][] locs = ChestData.CHEST_LOCS[this.wind];
        for (int i = 0; i < locs.length; i = (int)((byte)(i + 1))) {
            if (locs[i][0] != x || locs[i][1] != y) continue;
            return (byte)(i + 1);
        }
        return -1;
    }

    class GrubCollection {
        String displayname;
        int num_opened;
        int num_with_grubs;

        GrubCollection() {
        }
    }
}

