/*
 * Decompiled with CFR 0.152.
 */
package de0.coxthieving;

import de0.coxthieving.CoxThievingConfig;
import de0.coxthieving.CoxThievingPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class CoxThievingDatabox
extends OverlayPanel {
    private CoxThievingPlugin plugin;
    private CoxThievingConfig config;

    @Inject
    public CoxThievingDatabox(CoxThievingPlugin plugin, CoxThievingConfig config) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        int myindex;
        if (this.plugin.gc_local == null || this.plugin.gc_local.num_opened == 0) {
            myindex = -1;
        } else {
            myindex = Arrays.binarySearch(this.plugin.gc_others, 0, this.plugin.gc_others_count, this.plugin.gc_local, this.plugin.comparator);
            if (myindex < 0) {
                myindex = -myindex - 1;
            }
        }
        int sum_grubs = this.plugin.num_grubs;
        for (int i = 0; i < this.plugin.gc_others_count; ++i) {
            sum_grubs += this.plugin.gc_others[i].num_with_grubs * this.config.grubRate() / 100;
        }
        List elems = this.panelComponent.getChildren();
        elems.add(TitleComponent.builder().color(Color.WHITE).text((sum_grubs == this.plugin.num_grubs ? "Grub count: " : "Est. grub count: ") + sum_grubs).build());
        for (int i = 0; i < this.plugin.gc_others_count; ++i) {
            if (i == myindex) {
                this.add_gc_line(elems, this.plugin.gc_local);
            }
            this.add_gc_line(elems, this.plugin.gc_others[i]);
        }
        if (myindex == this.plugin.gc_others_count) {
            this.add_gc_line(elems, this.plugin.gc_local);
        }
        return super.render(graphics);
    }

    private void add_gc_line(List<LayoutableRenderableEntity> elems, CoxThievingPlugin.GrubCollection gc) {
        elems.add((LayoutableRenderableEntity)LineComponent.builder().left(gc.displayname).right(gc.num_with_grubs + "/" + gc.num_opened).build());
    }
}

