/*
 * Decompiled with CFR 0.152.
 */
package de0.coxthieving;

import de0.coxthieving.ChestData;
import de0.coxthieving.CoxThievingConfig;
import de0.coxthieving.CoxThievingPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Tile;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class ChestHighlight
extends Overlay {
    private Client client;
    private CoxThievingPlugin plugin;
    private CoxThievingConfig config;
    private final int A = 80;
    private final Color[] palette = new Color[10];
    private final Color pcolor = new Color(0, 255, 0, 80);
    private int last_gdfactor = -1;

    @Inject
    public ChestHighlight(Client client, CoxThievingPlugin plugin, CoxThievingConfig config) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D g) {
        if (!this.config.highlightBatChests()) {
            return null;
        }
        byte[][] solns = ChestData.CHEST_SOLNS[this.plugin.wind][this.plugin.rot];
        byte[][] locs = ChestData.CHEST_LOCS[this.plugin.wind];
        int gdfactor = this.config.gumdropFactor();
        if (gdfactor != this.last_gdfactor) {
            float h0 = 0.16666667f;
            float hf = (float)gdfactor / 20.0f;
            float s = 0.95f;
            float b = 0.8f;
            int[] rgb = new int[]{Color.HSBtoRGB(0.16666667f + hf * -1.0f, 0.95f, 0.8f), Color.HSBtoRGB(0.16666667f + hf * -0.8f, 0.95f, 0.8f), Color.HSBtoRGB(0.16666667f + hf * -0.6f, 0.95f, 0.8f), Color.HSBtoRGB(0.16666667f + hf * -0.4f, 0.95f, 0.8f), Color.HSBtoRGB(0.16666667f + hf * -0.2f, 0.95f, 0.8f), Color.HSBtoRGB(0.16666667f, 0.95f, 0.8f), Color.HSBtoRGB(0.16666667f + hf * 0.2f, 0.95f, 0.8f), Color.HSBtoRGB(0.16666667f + hf * 0.4f, 0.95f, 0.8f), Color.HSBtoRGB(0.16666667f + hf * 0.6f, 0.95f, 0.8f), Color.HSBtoRGB(0.16666667f + hf * 0.8f, 0.95f, 0.8f)};
            for (int i = 0; i < 10; ++i) {
                this.palette[i] = new Color(0x50000000 | rgb[i] & 0xFFFFFF, true);
            }
            this.last_gdfactor = gdfactor;
        }
        if (this.plugin.soln == -1) {
            for (byte n = 0; n < solns.length; n = (byte)(n + 1)) {
                if (this.plugin.not_solns.contains(n)) continue;
                for (int i = 0; i < 4; ++i) {
                    Tile t = this.findChest(locs[solns[n][i] - 1], this.plugin.rot);
                    if (t == null) continue;
                    this.highlightChest(t, this.palette[n], g);
                }
            }
        } else {
            byte[] b = solns[this.plugin.soln];
            for (int i = 0; i < b.length; ++i) {
                Tile t = this.findChest(locs[b[i] - 1], this.plugin.rot);
                if (t == null) continue;
                this.highlightChest(t, this.pcolor, g);
            }
        }
        return null;
    }

    private void highlightChest(Tile t, Color c, Graphics2D g) {
        GameObject chest = t.getGameObjects()[0];
        if (chest == null) {
            return;
        }
        if (chest.getId() == 29742 || chest.getId() == 29743) {
            g.setColor(c);
            if (chest.getCanvasLocation() != null) {
                g.fill(chest.getConvexHull());
            }
        }
    }

    private Tile findChest(byte[] coords, int rot) {
        byte rx = coords[0];
        byte ry = coords[1];
        int chestX = this.plugin.room_base_x;
        int chestY = this.plugin.room_base_y;
        if (rot == 0) {
            chestX += rx;
            chestY += ry;
        } else if (rot == 1) {
            chestX += ry;
            chestY -= rx;
        } else if (rot == 2) {
            chestX -= rx;
            chestY -= ry;
        } else {
            chestX -= ry;
            chestY += rx;
        }
        if (chestX < 0 || chestY < 0 || chestX >= 104 || chestY >= 104) {
            return null;
        }
        return this.client.getScene().getTiles()[this.client.getPlane()][chestX][chestY];
    }
}

