/*
 * Decompiled with CFR 0.152.
 */
package com.radiusmarkers;

import com.google.inject.Inject;
import com.radiusmarkers.AttackType;
import com.radiusmarkers.ColourRadiusMarker;
import com.radiusmarkers.RadiusMarkerConfig;
import com.radiusmarkers.RadiusMarkerPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

class RadiusMarkerMinimapOverlay
extends Overlay {
    private static final int TILE_SIZE = 4;
    private final Client client;
    private final RadiusMarkerConfig config;
    private final RadiusMarkerPlugin plugin;

    @Inject
    RadiusMarkerMinimapOverlay(Client client, RadiusMarkerConfig config, RadiusMarkerPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.showMinimap()) {
            this.drawMinimap(graphics);
        }
        return null;
    }

    private void drawMinimap(Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setClip(this.plugin.getMinimapClipArea());
        List<ColourRadiusMarker> markers = this.plugin.getMarkers();
        List npcs = this.client.getNpcs();
        for (ColourRadiusMarker marker : markers) {
            if (!marker.isVisible()) continue;
            boolean excludeCorner = AttackType.MELEE.equals((Object)marker.getAttackType());
            Collection<WorldPoint> worldPoints = this.plugin.getInstanceWorldPoints(marker.getWorldPoint());
            for (WorldPoint worldPoint : worldPoints) {
                if (this.config.includeRetreatInteractionRange() && marker.isRetreatInteractionVisible()) {
                    this.drawSquare(graphics, worldPoint, marker.getRetreatInteractionColour(), marker.getRetreatInteractionRadius(), 1, false);
                }
                if (this.config.includeAggressionRange() && marker.isAggressionVisible()) {
                    this.drawSquare(graphics, worldPoint, marker.getAggressionColour(), marker.getAggressionRadius(), this.client.getNpcDefinition(marker.getNpcId()).getSize(), excludeCorner);
                }
                if (this.config.includeMaxRange() && marker.isMaxVisible()) {
                    this.drawSquare(graphics, worldPoint, marker.getMaxColour(), marker.getMaxRadius(), 1, false);
                }
                if (this.config.includeWanderRange() && marker.isWanderVisible()) {
                    this.drawSquare(graphics, worldPoint, marker.getWanderColour(), marker.getWanderRadius(), 1, false);
                }
                if (!marker.isSpawnVisible()) continue;
                this.drawSquare(graphics, worldPoint, marker.getSpawnColour(), 0, 1, false);
            }
            for (NPC npc : npcs) {
                if (npc.getId() != marker.getNpcId() || this.plugin.exclude(npc)) continue;
                WorldPoint npcLocation = npc.getWorldLocation();
                int size = npc.getComposition().getSize();
                if (this.config.includeInteractionRange() && marker.isInteractionVisible()) {
                    this.drawSquare(graphics, npcLocation, marker.getInteractionColour(), marker.getInteractionRadius(), size, false);
                }
                if (this.config.includeHuntRange() && marker.isHuntVisible()) {
                    this.drawSquare(graphics, npcLocation, marker.getHuntColour(), marker.getHuntRadius(), 1, false);
                }
                if (!this.config.includeAttackRange() || !marker.isAttackVisible()) continue;
                this.drawSquare(graphics, npcLocation, marker.getAttackColour(), marker.getAttackRadius(), size, excludeCorner);
            }
        }
    }

    private void drawSquare(Graphics2D graphics, WorldPoint center, Color color, int radius, int size, boolean excludeCorner) {
        WorldPoint southWest = center.dx(-radius).dy(-radius);
        int diameter = 2 * radius + size;
        graphics.setColor(color);
        GeneralPath path = new GeneralPath();
        if (radius > 0 && excludeCorner) {
            this.updateLine(path, new WorldPoint[]{southWest.dx(1).dy(1), southWest.dx(1), southWest.dx(diameter - 1), southWest.dx(diameter - 1).dy(1)});
            this.updateLine(path, new WorldPoint[]{southWest.dx(diameter - 1).dy(1), southWest.dx(diameter).dy(1), southWest.dx(diameter).dy(diameter - 1), southWest.dx(diameter - 1).dy(diameter - 1)});
            this.updateLine(path, new WorldPoint[]{southWest.dx(1).dy(1), southWest.dy(1), southWest.dy(diameter - 1), southWest.dx(1).dy(diameter - 1)});
            this.updateLine(path, new WorldPoint[]{southWest.dx(1).dy(diameter - 1), southWest.dx(1).dy(diameter), southWest.dx(diameter - 1).dy(diameter), southWest.dx(diameter - 1).dy(diameter - 1)});
        } else {
            this.updateLine(path, new WorldPoint[]{southWest, southWest.dx(diameter)});
            this.updateLine(path, new WorldPoint[]{southWest.dx(diameter), southWest.dx(diameter).dy(diameter)});
            this.updateLine(path, new WorldPoint[]{southWest, southWest.dy(diameter)});
            this.updateLine(path, new WorldPoint[]{southWest.dy(diameter), southWest.dx(diameter).dy(diameter)});
        }
        graphics.draw(path);
    }

    private void updateLine(GeneralPath path, WorldPoint[] worldPoints) {
        for (int i = 1; i < worldPoints.length; ++i) {
            Point previous = this.worldToMinimap(worldPoints[i - 1]);
            boolean hasFirst = false;
            if (previous != null) {
                path.moveTo(previous.getX(), previous.getY());
                hasFirst = true;
            }
            Point current = this.worldToMinimap(worldPoints[i]);
            if (!hasFirst || current == null) continue;
            path.lineTo(current.getX(), current.getY());
        }
    }

    private Point worldToMinimap(WorldPoint worldPoint) {
        if (this.client.getLocalPlayer() == null) {
            return null;
        }
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
        LocalPoint playerLocalPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)playerLocation);
        if (playerLocalPoint == null) {
            return null;
        }
        int offsetX = playerLocalPoint.getX() - localLocation.getX();
        int offsetY = playerLocalPoint.getY() - localLocation.getY();
        int x = (worldPoint.getX() - playerLocation.getX()) * 4 + offsetX / 32 - 2;
        int y = (worldPoint.getY() - playerLocation.getY()) * 4 + offsetY / 32 - 2 + 1;
        int angle = this.client.getMapAngle() & 0x7FF;
        int sin = (int)(65536.0 * Math.sin((double)angle * 0.0030679615757712823));
        int cos = (int)(65536.0 * Math.cos((double)angle * 0.0030679615757712823));
        Widget minimapDrawWidget = this.plugin.getMinimapDrawWidget();
        if (minimapDrawWidget == null || minimapDrawWidget.isHidden()) {
            return null;
        }
        int xx = y * sin + cos * x >> 16;
        int yy = sin * x - y * cos >> 16;
        Point loc = minimapDrawWidget.getCanvasLocation();
        int minimapX = loc.getX() + xx + minimapDrawWidget.getWidth() / 2;
        int minimapY = loc.getY() + yy + minimapDrawWidget.getHeight() / 2;
        return new Point(minimapX, minimapY);
    }
}

