/*
 * Decompiled with CFR 0.152.
 */
package com.radiusmarkers;

import com.google.inject.Inject;
import com.radiusmarkers.AttackType;
import com.radiusmarkers.ColourRadiusMarker;
import com.radiusmarkers.RadiusMarkerConfig;
import com.radiusmarkers.RadiusMarkerPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.api.RenderOverview;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlay;

class RadiusMarkerMapOverlay
extends Overlay {
    private final Client client;
    private final RadiusMarkerConfig config;
    private final RadiusMarkerPlugin plugin;
    @Inject
    private WorldMapOverlay worldMapOverlay;

    @Inject
    RadiusMarkerMapOverlay(Client client, RadiusMarkerConfig config, RadiusMarkerPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.MANUAL);
        this.drawAfterLayer(WidgetInfo.WORLD_MAP_VIEW);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.showWorldMap() && this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW) != null) {
            this.drawWorldMap(graphics);
        }
        return null;
    }

    private void drawWorldMap(Graphics2D graphics) {
        Widget worldMapView = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (worldMapView == null) {
            return;
        }
        Rectangle bounds = worldMapView.getBounds();
        if (bounds == null) {
            return;
        }
        Area mapClipArea = this.getWorldMapClipArea(bounds);
        List<ColourRadiusMarker> markers = this.plugin.getMarkers();
        List npcs = this.client.getNpcs();
        for (ColourRadiusMarker marker : markers) {
            if (!marker.isVisible()) continue;
            boolean excludeCorner = AttackType.MELEE.equals((Object)marker.getAttackType());
            WorldPoint worldPoint = marker.getWorldPoint();
            if (this.config.includeRetreatInteractionRange() && marker.isRetreatInteractionVisible()) {
                this.drawSquare(graphics, worldPoint, marker.getRetreatInteractionColour(), mapClipArea, marker.getRetreatInteractionRadius(), 1, false);
            }
            if (this.config.includeAggressionRange() && marker.isAggressionVisible()) {
                this.drawSquare(graphics, worldPoint, marker.getAggressionColour(), mapClipArea, marker.getAggressionRadius(), this.client.getNpcDefinition(marker.getNpcId()).getSize(), excludeCorner);
            }
            if (this.config.includeMaxRange() && marker.isMaxVisible()) {
                this.drawSquare(graphics, worldPoint, marker.getMaxColour(), mapClipArea, marker.getMaxRadius(), 1, false);
            }
            if (this.config.includeWanderRange() && marker.isWanderVisible()) {
                this.drawSquare(graphics, worldPoint, marker.getWanderColour(), mapClipArea, marker.getWanderRadius(), 1, false);
            }
            if (marker.isSpawnVisible()) {
                this.drawSquare(graphics, worldPoint, marker.getSpawnColour(), mapClipArea, 0, 1, false);
            }
            for (NPC npc : npcs) {
                if (npc.getId() != marker.getNpcId() || this.plugin.exclude(npc)) continue;
                WorldPoint npcLocation = npc.getWorldLocation();
                int size = npc.getComposition().getSize();
                if (this.config.includeInteractionRange() && marker.isInteractionVisible()) {
                    this.drawSquare(graphics, npcLocation, marker.getInteractionColour(), mapClipArea, marker.getInteractionRadius(), size, false);
                }
                if (this.config.includeHuntRange() && marker.isHuntVisible()) {
                    this.drawSquare(graphics, npcLocation, marker.getHuntColour(), mapClipArea, marker.getHuntRadius(), 1, false);
                }
                if (!this.config.includeAttackRange() || !marker.isAttackVisible()) continue;
                this.drawSquare(graphics, npcLocation, marker.getAttackColour(), mapClipArea, marker.getAttackRadius(), size, excludeCorner);
            }
        }
    }

    private void drawSquare(Graphics2D graphics, WorldPoint worldPoint, Color color, Area mapClipArea, int radius, int size, boolean excludeCorner) {
        Point start = this.worldMapOverlay.mapWorldPointToGraphicsPoint(worldPoint.dx(-radius).dy(radius + size - 1));
        Point end = this.worldMapOverlay.mapWorldPointToGraphicsPoint(worldPoint.dx(radius + size).dy(-(radius + 1)));
        if (start == null || end == null) {
            return;
        }
        RenderOverview renderOverview = this.client.getRenderOverview();
        float pixelsPerTile = renderOverview.getWorldMapZoom();
        int tileSize = (int)pixelsPerTile;
        int x = start.getX();
        int y = start.getY();
        int width = end.getX() - x - 1;
        int height = end.getY() - y - 1;
        y = y - tileSize / 2 + 1;
        graphics.setColor(color);
        graphics.setClip(mapClipArea);
        Area square = new Area(new Rectangle(x -= tileSize / 2, y, width, height));
        if (radius > 0 && excludeCorner) {
            Area corners = new Area(new Rectangle(x, y, tileSize, tileSize));
            corners.add(new Area(new Rectangle(x, y + height - tileSize, tileSize, tileSize)));
            corners.add(new Area(new Rectangle(x + width - tileSize, y, tileSize, tileSize)));
            corners.add(new Area(new Rectangle(x + width - tileSize, y + height - tileSize, tileSize, tileSize)));
            Rectangle r = new Rectangle();
            square.subtract(corners);
        }
        graphics.draw(square);
    }

    private Area getWorldMapClipArea(Rectangle baseRectangle) {
        Widget overview = this.client.getWidget(WidgetInfo.WORLD_MAP_OVERVIEW_MAP);
        Widget surfaceSelector = this.client.getWidget(WidgetInfo.WORLD_MAP_SURFACE_SELECTOR);
        Area clipArea = new Area(baseRectangle);
        if (overview != null && !overview.isHidden()) {
            clipArea.subtract(new Area(overview.getBounds()));
        }
        if (surfaceSelector != null && !surfaceSelector.isHidden()) {
            clipArea.subtract(new Area(surfaceSelector.getBounds()));
        }
        return clipArea;
    }
}

