/*
 * Decompiled with CFR 0.152.
 */
package com.clanmate_export;

import com.clanmate_export.ClanMateExportChatMenuManager;
import com.clanmate_export.ClanMateExportConfig;
import com.clanmate_export.ClanMateExportWebRequestModel;
import com.clanmate_export.ClanMemberMap;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clanmate Export")
public class ClanMateExportPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClanMateExportPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClanMateExportConfig config;
    @Inject
    private ClanMateExportChatMenuManager clanMateExportChatMenuManager;
    @Inject
    private OkHttpClient webClient;
    private static final Gson GSON = RuneLiteAPI.GSON;
    private static final int CLAN_SETTINGS_INFO_PAGE_WIDGET = 690;
    private static final int CLAN_SETTINGS_MEMBERS_PAGE_WIDGET_ID = 693;
    private static final int CLAN_SETTINGS_MEMBERS_LIST_RSN_COLUMN = WidgetInfo.PACK((int)693, (int)10);
    private static final int CLAN_SETTINGS_MEMBERS_LIST_FIRST_COLUMN = WidgetInfo.PACK((int)693, (int)11);
    private static final int CLAN_SETTINGS_MEMBERS_LIST_SECOND_COLUMN = WidgetInfo.PACK((int)693, (int)13);
    private static final int CLAN_SETTINGS_MEMBERS_LIST_FIRST_DROP_DOWN = WidgetInfo.PACK((int)693, (int)7);
    private static final int CLAN_SETTINGS_MEMBERS_LIST_SECOND_DROP_DOWN = WidgetInfo.PACK((int)693, (int)8);
    private List<ClanMemberMap> clanMembers = null;

    @Provides
    ClanMateExportConfig provideConfig(ConfigManager configManager) {
        return (ClanMateExportConfig)configManager.getConfig(ClanMateExportConfig.class);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widget) {
        if (widget.getGroupId() == 690 && this.config.getShowHelperText()) {
            this.clanMateExportChatMenuManager.update(ClanMateExportChatMenuManager.WhatToShow.OPEN_MEMBERS_SCREEN);
        }
        if (widget.getGroupId() == 693) {
            if (this.client.getWidget(693, 9) == null) {
                this.clanMembers = null;
            } else {
                this.clanMateExportChatMenuManager.update(ClanMateExportChatMenuManager.WhatToShow.SHOW_EXPORT_OPTIONS);
            }
        }
    }

    public void scrapeMembers() {
        if (this.clanMembers == null) {
            this.clanMembers = new ArrayList<ClanMemberMap>();
        }
        this.clanMembers.clear();
        Widget clanMemberNamesWidget = this.client.getWidget(CLAN_SETTINGS_MEMBERS_LIST_RSN_COLUMN);
        Widget rankWidget = this.client.getWidget(CLAN_SETTINGS_MEMBERS_LIST_FIRST_COLUMN);
        Widget joinedWidget = this.client.getWidget(CLAN_SETTINGS_MEMBERS_LIST_SECOND_COLUMN);
        Widget[] leftColumnName = Objects.requireNonNull(this.client.getWidget(CLAN_SETTINGS_MEMBERS_LIST_FIRST_DROP_DOWN)).getChildren();
        if (leftColumnName != null && !leftColumnName[4].getText().equals("Rank")) {
            this.clanMateExportChatMenuManager.update(ClanMateExportChatMenuManager.WhatToShow.CHECK_COLUMNS_RANKED);
            return;
        }
        Widget[] rightColumnName = Objects.requireNonNull(this.client.getWidget(CLAN_SETTINGS_MEMBERS_LIST_SECOND_DROP_DOWN)).getChildren();
        if (rightColumnName != null && !rightColumnName[4].getText().equals("Joined")) {
            this.clanMateExportChatMenuManager.update(ClanMateExportChatMenuManager.WhatToShow.CHECK_COLUMNS_JOINED);
            return;
        }
        if (clanMemberNamesWidget == null || rankWidget == null || joinedWidget == null) {
            return;
        }
        Widget[] clanMemberNamesWidgetValues = clanMemberNamesWidget.getChildren();
        Widget[] rankWidgetValues = rankWidget.getChildren();
        Widget[] joinedWidgetValues = joinedWidget.getChildren();
        if (clanMemberNamesWidgetValues == null || rankWidgetValues == null || joinedWidgetValues == null) {
            return;
        }
        int lastSuccessfulRsnIndex = 0;
        int otherColumnsPositions = 0;
        for (int i = 0; i < clanMemberNamesWidgetValues.length; ++i) {
            boolean inBounds;
            int valueOfRsnToGet = i == 0 ? 1 : lastSuccessfulRsnIndex + 3;
            boolean bl = inBounds = valueOfRsnToGet >= 0 && valueOfRsnToGet < clanMemberNamesWidgetValues.length;
            if (!inBounds) continue;
            int clanMemberCount = Objects.requireNonNull(this.client.getClanSettings()).getMembers().size();
            int otherColumnsIndex = otherColumnsPositions + clanMemberCount;
            String rsn = Text.removeTags((String)clanMemberNamesWidgetValues[valueOfRsnToGet].getText());
            String rank = Text.removeTags((String)rankWidgetValues[otherColumnsIndex].getText());
            String joinedDate = Text.removeTags((String)joinedWidgetValues[otherColumnsIndex].getText());
            ClanMemberMap clanMember = new ClanMemberMap(rsn, rank, joinedDate);
            this.clanMembers.add(clanMember);
            lastSuccessfulRsnIndex = valueOfRsnToGet;
            ++otherColumnsPositions;
        }
    }

    public void ClanToClipBoard() {
        this.scrapeMembers();
        if (this.config.exportToClipBoard()) {
            String clipBoardString = "";
            switch (this.config.getDataExportFormat()) {
                case JSON: {
                    clipBoardString = this.toJson(this.clanMembers);
                    break;
                }
                case CSV: {
                    clipBoardString = this.toCSV(this.clanMembers);
                }
            }
            this.clanMembersToClipBoard(clipBoardString);
            this.clanMateExportChatMenuManager.update(ClanMateExportChatMenuManager.WhatToShow.SUCCESS);
        }
    }

    private String toCSV(List<ClanMemberMap> clanMemberMaps) {
        String result = "";
        StringBuilder sb = new StringBuilder();
        for (ClanMemberMap clanMember : clanMemberMaps) {
            sb.append(clanMember.getRSN()).append(",");
            if (!this.config.getExportUserNamesOnly()) {
                sb.append(clanMember.getRank()).append(",");
                sb.append(clanMember.getJoinedDate());
            }
            sb.append("\n");
        }
        result = sb.deleteCharAt(sb.length() - 1).toString();
        return result;
    }

    private String toJson(List<ClanMemberMap> clanMemberMaps) {
        return GSON.toJson(clanMemberMaps);
    }

    private void clanMembersToClipBoard(String clipboardString) {
        if (this.clanMembers.size() != 0) {
            StringSelection stringSelection = new StringSelection(clipboardString);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    public void SendClanMembersToUrl() {
        this.scrapeMembers();
        if (this.clanMembers.size() != 0) {
            try {
                String clanName = Objects.requireNonNull(this.client.getClanSettings()).getName();
                ClanMateExportWebRequestModel webRequestModel = new ClanMateExportWebRequestModel(clanName, this.clanMembers);
                Request request = new Request.Builder().post(RequestBody.create((MediaType)RuneLiteAPI.JSON, (String)GSON.toJson((Object)webRequestModel))).url(this.config.getDataUrl()).build();
                this.webClient.newCall(request).enqueue(new Callback(){

                    public void onFailure(Call call, IOException e) {
                        ClanMateExportPlugin.this.clanMateExportChatMenuManager.update(ClanMateExportChatMenuManager.WhatToShow.WEB_REQUEST_FAILED);
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        if (response.isSuccessful()) {
                            ClanMateExportPlugin.this.clanMateExportChatMenuManager.update(ClanMateExportChatMenuManager.WhatToShow.SUCCESS);
                        } else {
                            ClanMateExportPlugin.this.clanMateExportChatMenuManager.update(ClanMateExportChatMenuManager.WhatToShow.WEB_REQUEST_FAILED);
                        }
                    }
                });
            }
            catch (Exception e) {
                this.clanMateExportChatMenuManager.update(ClanMateExportChatMenuManager.WhatToShow.WEB_REQUEST_FAILED);
            }
        }
    }
}

