/*
 * Decompiled with CFR 0.152.
 */
package com.clanmate_export;

import com.clanmate_export.ClanMateExportConfig;
import com.clanmate_export.ClanMateExportPlugin;
import com.google.common.util.concurrent.Runnables;
import javax.inject.Inject;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.game.chatbox.ChatboxTextMenuInput;

public class ClanMateExportChatMenuManager {
    private final ClanMateExportPlugin plugin;
    private final ChatboxPanelManager chatboxPanelManager;
    @Inject
    private ClanMateExportConfig config;

    @Inject
    public ClanMateExportChatMenuManager(ClanMateExportPlugin plugin, ChatboxPanelManager chatboxPanelManager, ClanMateExportConfig config) {
        this.chatboxPanelManager = chatboxPanelManager;
        this.plugin = plugin;
        this.config = config;
    }

    public void update(WhatToShow whatToShow) {
        switch (whatToShow) {
            case OPEN_MEMBERS_SCREEN: {
                this.chatboxPanelManager.openTextMenuInput("To export Clanmembers click 'Members' on left side. <br> (This can be disabled in the plugin settings).").option("Okay", Runnables.doNothing()).build();
                return;
            }
            case CHECK_COLUMNS_JOINED: {
                ChatboxTextMenuInput checkColumnsJoined = this.chatboxPanelManager.openTextMenuInput("Make Sure 'Joined' is selected as the last column.");
                this.addChoices(checkColumnsJoined);
                checkColumnsJoined.build();
                return;
            }
            case CHECK_COLUMNS_RANKED: {
                ChatboxTextMenuInput checkColumnsRanked = this.chatboxPanelManager.openTextMenuInput("Make Sure 'Ranked' is selected as the <br> middle column.");
                this.addChoices(checkColumnsRanked);
                checkColumnsRanked.build();
                return;
            }
            case SUCCESS: {
                this.chatboxPanelManager.openTextMenuInput("Clanmates have been exported. Can close the screen").option("Okay", Runnables.doNothing()).build();
                return;
            }
            case WEB_REQUEST_FAILED: {
                this.chatboxPanelManager.openTextMenuInput("Web request failed.").option("Okay", Runnables.doNothing()).build();
                return;
            }
            case SHOW_EXPORT_OPTIONS: {
                ChatboxTextMenuInput exportOptions = this.chatboxPanelManager.openTextMenuInput("Select an export option.");
                this.addChoices(exportOptions);
                exportOptions.build();
            }
        }
    }

    private void addChoices(ChatboxTextMenuInput chatboxTextMenuInput) {
        chatboxTextMenuInput.option("1. Export to your clipboard.", this.plugin::ClanToClipBoard);
        if (this.config.getSendWebRequest()) {
            chatboxTextMenuInput.option("2. Export to the recorded URL.", this.plugin::SendClanMembersToUrl);
            chatboxTextMenuInput.option("3. Cancel.", Runnables.doNothing());
        } else {
            chatboxTextMenuInput.option("2. Cancel.", Runnables.doNothing());
        }
    }

    public static enum WhatToShow {
        OPEN_MEMBERS_SCREEN,
        CHECK_COLUMNS_JOINED,
        CHECK_COLUMNS_RANKED,
        SUCCESS,
        SHOW_EXPORT_OPTIONS,
        WEB_REQUEST_FAILED;

    }
}

