/*
 * Decompiled with CFR 0.152.
 */
package com.specimencleaningextended;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.inject.Provides;
import com.specimencleaningextended.SpecimenCleaningExtendedConfig;
import com.specimencleaningextended.SpecimenCleaningExtendedOverlay;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Specimen Cleaning Extended")
public class SpecimenCleaningExtendedPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SpecimenCleaningExtendedPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private SpecimenCleaningExtendedOverlay overlay;
    private float totalTicks = 0.0f;
    private float totalArtefacts = 0.0f;
    private float totalSpecimens = 0.0f;
    private float artefactsPerHour = 0.0f;
    private float specimensPerHour = 0.0f;
    private float predictedXpPerHour = 0.0f;
    private String artefactsPerHourFormatted;
    private String predictedXpPerHourFormatted;
    private String specimensPerHourFormatted;
    DecimalFormat formatter = new DecimalFormat("#,###");
    private static final Set<Integer> ITEMS = ImmutableSet.of((Object)11176, (Object)11177, (Object)11178, (Object)11183, (Object)11175);
    private Multiset<Integer> lastInventory;
    @Inject
    private SpecimenCleaningExtendedConfig config;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.configureSkillsInLampMenu();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.displayAllSkills();
        this.resetPredictedRateVariables();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (this.config.hideLampSkills()) {
            this.configureSkillsInLampMenu();
        } else {
            this.displayAllSkills();
        }
        if (this.config.reset()) {
            this.resetPredictedRateVariables();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (this.config.hideLampSkills()) {
            this.configureSkillsInLampMenu();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.config.reset() && !this.config.pause()) {
            this.totalTicks += 1.0f;
            this.artefactsPerHour = this.totalArtefacts / this.totalTicks * 6000.0f;
            this.artefactsPerHourFormatted = this.formatter.format(this.artefactsPerHour);
            this.predictedXpPerHour = (float)((double)this.artefactsPerHour / 97.5 * 500.0);
            this.predictedXpPerHourFormatted = this.formatter.format(this.predictedXpPerHour);
            this.specimensPerHour = this.totalSpecimens / this.totalTicks * 6000.0f;
            this.specimensPerHourFormatted = this.formatter.format(this.specimensPerHour);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (!this.config.reset() && !this.config.pause()) {
            ItemContainer container = event.getItemContainer();
            if (container != this.client.getItemContainer(InventoryID.INVENTORY)) {
                return;
            }
            HashMultiset currentInventory = HashMultiset.create();
            Arrays.stream(container.getItems()).filter(item -> ITEMS.contains(item.getId())).forEach(arg_0 -> SpecimenCleaningExtendedPlugin.lambda$onItemContainerChanged$1((Multiset)currentInventory, arg_0));
            if (this.lastInventory != null) {
                Multiset delta = Multisets.difference((Multiset)currentInventory, this.lastInventory);
                delta.forEach(itemId -> this.addItemCounts((int)itemId));
            }
            this.lastInventory = currentInventory;
        }
    }

    private void addItemCounts(int itemId) {
        switch (itemId) {
            case 11176: 
            case 11177: 
            case 11178: 
            case 11183: {
                this.totalArtefacts += 1.0f;
                break;
            }
            case 11175: {
                this.totalSpecimens += 1.0f;
            }
        }
    }

    private void resetPredictedRateVariables() {
        this.totalTicks = 0.0f;
        this.totalArtefacts = 0.0f;
        this.artefactsPerHour = 0.0f;
        this.predictedXpPerHour = 0.0f;
        this.specimensPerHour = 0.0f;
        this.totalSpecimens = 0.0f;
        this.lastInventory = null;
    }

    private void configureSkillsInLampMenu() {
        if (this.config.hideLampSkills()) {
            if (this.config.attack()) {
                this.hideWidget(this.client.getWidget(0xF00002), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF00002), false);
            }
            if (this.config.strength()) {
                this.hideWidget(this.client.getWidget(0xF00003), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF00003), false);
            }
            if (this.config.ranged()) {
                this.hideWidget(this.client.getWidget(0xF00004), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF00004), false);
            }
            if (this.config.magic()) {
                this.hideWidget(this.client.getWidget(0xF00005), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF00005), false);
            }
            if (this.config.defence()) {
                this.hideWidget(this.client.getWidget(0xF00006), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF00006), false);
            }
            if (this.config.hitpoints()) {
                this.hideWidget(this.client.getWidget(0xF00007), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF00007), false);
            }
            if (this.config.prayer()) {
                this.hideWidget(this.client.getWidget(0xF00008), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF00008), false);
            }
            if (this.config.agility()) {
                this.hideWidget(this.client.getWidget(0xF00009), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF00009), false);
            }
            if (this.config.herblore()) {
                this.hideWidget(this.client.getWidget(0xF0000A), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF0000A), false);
            }
            if (this.config.thieving()) {
                this.hideWidget(this.client.getWidget(0xF0000B), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF0000B), false);
            }
            if (this.config.crafting()) {
                this.hideWidget(this.client.getWidget(0xF0000C), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF0000C), false);
            }
            if (this.config.runecraft()) {
                this.hideWidget(this.client.getWidget(0xF0000D), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF0000D), false);
            }
            if (this.config.slayer()) {
                this.hideWidget(this.client.getWidget(0xF0000E), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF0000E), false);
            }
            if (this.config.farming()) {
                this.hideWidget(this.client.getWidget(0xF0000F), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF0000F), false);
            }
            if (this.config.mining()) {
                this.hideWidget(this.client.getWidget(0xF00010), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF00010), false);
            }
            if (this.config.smithing()) {
                this.hideWidget(this.client.getWidget(0xF00011), true);
            } else {
                this.hideWidget(this.client.getWidget(0xF00011), false);
            }
            if (this.config.fishing()) {
                this.hideWidget(this.client.getWidget(15728658), true);
            } else {
                this.hideWidget(this.client.getWidget(15728658), false);
            }
            if (this.config.cooking()) {
                this.hideWidget(this.client.getWidget(15728659), true);
            } else {
                this.hideWidget(this.client.getWidget(15728659), false);
            }
            if (this.config.firemaking()) {
                this.hideWidget(this.client.getWidget(15728660), true);
            } else {
                this.hideWidget(this.client.getWidget(15728660), false);
            }
            if (this.config.woodcutting()) {
                this.hideWidget(this.client.getWidget(15728661), true);
            } else {
                this.hideWidget(this.client.getWidget(15728661), false);
            }
            if (this.config.fletching()) {
                this.hideWidget(this.client.getWidget(15728662), true);
            } else {
                this.hideWidget(this.client.getWidget(15728662), false);
            }
            if (this.config.construction()) {
                this.hideWidget(this.client.getWidget(15728663), true);
            } else {
                this.hideWidget(this.client.getWidget(15728663), false);
            }
            if (this.config.hunter()) {
                this.hideWidget(this.client.getWidget(15728664), true);
            } else {
                this.hideWidget(this.client.getWidget(15728664), false);
            }
        } else {
            this.displayAllSkills();
        }
    }

    private void displayAllSkills() {
        this.hideWidget(this.client.getWidget(0xF00002), false);
        this.hideWidget(this.client.getWidget(0xF00003), false);
        this.hideWidget(this.client.getWidget(0xF00004), false);
        this.hideWidget(this.client.getWidget(0xF00005), false);
        this.hideWidget(this.client.getWidget(0xF00006), false);
        this.hideWidget(this.client.getWidget(0xF00007), false);
        this.hideWidget(this.client.getWidget(0xF00008), false);
        this.hideWidget(this.client.getWidget(0xF00009), false);
        this.hideWidget(this.client.getWidget(0xF0000A), false);
        this.hideWidget(this.client.getWidget(0xF0000B), false);
        this.hideWidget(this.client.getWidget(0xF0000C), false);
        this.hideWidget(this.client.getWidget(0xF0000D), false);
        this.hideWidget(this.client.getWidget(0xF0000E), false);
        this.hideWidget(this.client.getWidget(0xF0000F), false);
        this.hideWidget(this.client.getWidget(0xF00010), false);
        this.hideWidget(this.client.getWidget(0xF00011), false);
        this.hideWidget(this.client.getWidget(15728658), false);
        this.hideWidget(this.client.getWidget(15728659), false);
        this.hideWidget(this.client.getWidget(15728660), false);
        this.hideWidget(this.client.getWidget(15728661), false);
        this.hideWidget(this.client.getWidget(15728662), false);
        this.hideWidget(this.client.getWidget(15728663), false);
        this.hideWidget(this.client.getWidget(15728664), false);
    }

    private void hideWidget(Widget widget, boolean hidden) {
        if (widget != null) {
            widget.setHidden(hidden);
        }
    }

    @Provides
    SpecimenCleaningExtendedConfig provideConfig(ConfigManager configManager) {
        return (SpecimenCleaningExtendedConfig)configManager.getConfig(SpecimenCleaningExtendedConfig.class);
    }

    public String getArtefactsPerHourFormatted() {
        return this.artefactsPerHourFormatted;
    }

    public String getPredictedXpPerHourFormatted() {
        return this.predictedXpPerHourFormatted;
    }

    public String getSpecimensPerHourFormatted() {
        return this.specimensPerHourFormatted;
    }

    private static /* synthetic */ void lambda$onItemContainerChanged$1(Multiset currentInventory, Item item) {
        currentInventory.add((Object)item.getId(), item.getQuantity());
    }
}

