/*
 * Decompiled with CFR 0.152.
 */
package com.specimencleaningextended;

import com.specimencleaningextended.SpecimenCleaningExtendedConfig;
import com.specimencleaningextended.SpecimenCleaningExtendedPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class SpecimenCleaningExtendedOverlay
extends OverlayPanel {
    private final SpecimenCleaningExtendedPlugin plugin;
    @Inject
    private SpecimenCleaningExtendedConfig config;

    @Inject
    SpecimenCleaningExtendedOverlay(SpecimenCleaningExtendedPlugin plugin) {
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.displayInfoPanel()) {
            String predictedXpPerHour = this.plugin.getPredictedXpPerHourFormatted();
            String artefactsPerHour = this.plugin.getArtefactsPerHourFormatted();
            String specimensPerHour = this.plugin.getSpecimensPerHourFormatted();
            this.panelComponent.setOrientation(ComponentOrientation.VERTICAL);
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Cleaning Rates").build());
            if (this.config.findSpecimensPerHour()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Specimens/hr:").right(String.valueOf(specimensPerHour)).build());
            }
            if (this.config.findArtefactsPerHour()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Artefacts/hr:").right(String.valueOf(artefactsPerHour)).build());
            }
            if (this.config.predictXpPerHour()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Experience/hr:").right(String.valueOf(predictedXpPerHour)).build());
            }
        }
        return super.render(graphics);
    }
}

