/*
 * Decompiled with CFR 0.152.
 */
package com.highalchighlight;

import com.highalchighlight.HighAlcHighlightConfig;
import com.highalchighlight.HighAlcHighlightPlugin;
import com.highalchighlight.config.FireRuneSource;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;

public class HighAlcHighlightOverlay
extends WidgetItemOverlay {
    private final Client client;
    private final ItemManager itemManager;
    private final HighAlcHighlightConfig config;

    @Inject
    private HighAlcHighlightOverlay(Client client, ItemManager itemManager, HighAlcHighlightPlugin plugin, HighAlcHighlightConfig config) {
        this.client = client;
        this.itemManager = itemManager;
        this.config = config;
        this.showOnInventory();
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        if (this.checkInterfaceIsHighlightable(itemWidget)) {
            int gePrice = this.itemManager.getItemPrice(itemId);
            if (gePrice >= 100) {
                if (gePrice > 499999999) {
                    gePrice -= 5000000;
                }
                gePrice -= gePrice / 100;
            }
            int profitPerCast = this.getProfit(itemId, gePrice);
            boolean isSellable = this.isSellable(gePrice);
            if (profitPerCast > 0 && (isSellable || this.config.highlightUnsellables())) {
                Color colorToUse = this.getColor(profitPerCast, isSellable);
                Rectangle bounds = itemWidget.getCanvasBounds();
                BufferedImage outline = this.itemManager.getItemOutline(itemId, itemWidget.getQuantity(), colorToUse);
                graphics.drawImage((Image)outline, (int)bounds.getX(), (int)bounds.getY(), null);
            }
        }
    }

    private boolean checkInterfaceIsHighlightable(WidgetItem itemWidget) {
        if (this.config.getHighlightLocation() != HighAlcHighlightConfig.HighlightLocationType.BOTH) {
            Widget bankWidget = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
            if (bankWidget != null && this.config.getHighlightLocation() == HighAlcHighlightConfig.HighlightLocationType.BANK) {
                return bankWidget.getId() == itemWidget.getWidget().getId();
            }
            Widget inventoryWidget = this.client.getWidget(WidgetInfo.INVENTORY);
            Widget bankInventoryWidget = this.client.getWidget(WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER);
            if (inventoryWidget != null && this.config.getHighlightLocation() == HighAlcHighlightConfig.HighlightLocationType.INVENTORY) {
                if (bankInventoryWidget != null) {
                    return bankInventoryWidget.getId() == itemWidget.getWidget().getId();
                }
                return inventoryWidget.getId() == itemWidget.getWidget().getId();
            }
        }
        return true;
    }

    private int getProfit(int itemId, int gePrice) {
        ItemComposition itemDef = this.itemManager.getItemComposition(itemId);
        int haPrice = itemDef.getHaPrice();
        int fireRunePrice = this.itemManager.getItemPrice(554);
        int natureRunePrice = this.config.useGE() ? this.itemManager.getItemPrice(561) : this.config.overridePrice();
        int fireRuneMultiplier = 0;
        if (this.config.fireRuneSource() == FireRuneSource.RUNES) {
            fireRuneMultiplier = 5;
        }
        double natureRuneMultiplier = 1.0;
        if (this.config.useBryoStaff()) {
            natureRuneMultiplier = 0.9375;
        }
        int castCost = fireRunePrice * fireRuneMultiplier + (int)Math.ceil((double)natureRunePrice * natureRuneMultiplier);
        if (this.config.useGEPrices()) {
            return haPrice - gePrice - castCost;
        }
        return haPrice - castCost;
    }

    private boolean isSellable(int gePrice) {
        return gePrice > 0;
    }

    private Color getColor(int profitPerCast, boolean isSellable) {
        if (!isSellable) {
            return this.config.getUnsellableColour();
        }
        if (this.config.useGradientMode()) {
            double percent = Math.min((double)profitPerCast / (double)this.config.highProfitValue(), 1.0);
            return this.getGradientColor(this.config.getColour(), this.config.getHighProfitColour(), percent);
        }
        if (profitPerCast >= this.config.highProfitValue()) {
            return this.config.getHighProfitColour();
        }
        return this.config.getColour();
    }

    private Color getGradientColor(Color lowColor, Color highColor, double percent) {
        int newRed = this.findStep(lowColor.getRed(), highColor.getRed(), percent);
        int newGreen = this.findStep(lowColor.getGreen(), highColor.getGreen(), percent);
        int newBlue = this.findStep(lowColor.getBlue(), highColor.getBlue(), percent);
        return new Color(newRed, newGreen, newBlue);
    }

    private int findStep(int low, int high, double percent) {
        return (int)((double)low + (double)(high - low) * percent);
    }
}

