/*
 * Decompiled with CFR 0.152.
 */
package com.highalchighlight;

import com.highalchighlight.config.FireRuneSource;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;

@ConfigGroup(value="highalchighlight")
public interface HighAlcHighlightConfig
extends Config {
    @ConfigItem(position=1, keyName="usingBryo", name="Using Bryophyta's Staff", description="Configures if you are using Bryophyta's Staff.")
    default public boolean useBryoStaff() {
        return false;
    }

    @ConfigItem(position=2, keyName="fireRuneSource", name="Source of Fire Runes", description="Configures what source of fire runes you are using.")
    default public FireRuneSource fireRuneSource() {
        return FireRuneSource.STAFF;
    }

    @ConfigItem(position=3, keyName="useGE", name="Use GE Price for Nature Runes", description="Fetch the price of Nature Runes from the GE (Ironmen should set this to off)")
    default public boolean useGE() {
        return true;
    }

    @ConfigItem(position=4, keyName="useGEPrices", name="Use GE Price for Item", description="Fetch the price of the item for High Alc calculation, otherwise just uses HA Value - Cast Cost")
    default public boolean useGEPrices() {
        return true;
    }

    @ConfigItem(position=5, keyName="overridePrice", name="Nature rune cost", description="If the Nature Rune GE price is not used this is the price for Nature Runes that will be used.")
    default public int overridePrice() {
        return 203;
    }

    @ConfigItem(position=6, keyName="useGradientMode", name="Gradient Mode", description="Enabling this setting will cause items to be highlighted in a gradient color from your Highlight Colour to your High-Profit Colour based on profitability.")
    default public boolean useGradientMode() {
        return true;
    }

    @ConfigItem(position=7, keyName="HighlightColour", name="Highlight Colour", description="Highlight colour of profitable items")
    default public Color getColour() {
        return Color.WHITE;
    }

    @ConfigItem(position=8, keyName="highProfitValue", name="High-Profit Threshold", description="The price for high-profit highlighting.")
    default public int highProfitValue() {
        return 300;
    }

    @ConfigItem(position=9, keyName="highProfitColour", name="High-Profit Colour", description="Highlight colour of items that are high-profit.")
    default public Color getHighProfitColour() {
        return Color.GREEN;
    }

    @ConfigItem(position=10, keyName="highlightUnsellables", name="Highlight Unsellables", description="If enabled, highlights items that would make a profit but cannot be sold on the GE")
    default public boolean highlightUnsellables() {
        return true;
    }

    @ConfigItem(position=11, keyName="unsellableHighlightColour", name="Unsellables Colour", description="Colour to show if Highlight Unsellables is checked")
    default public Color getUnsellableColour() {
        return Color.YELLOW;
    }

    @ConfigItem(position=3, keyName="highlightLocation", name="Highlight", description="Colour to show if Highlight Unsellables is checked")
    default public HighlightLocationType getHighlightLocation() {
        return HighlightLocationType.BOTH;
    }

    public static enum HighlightLocationType {
        BOTH("Both"),
        BANK("Bank"),
        INVENTORY("Inventory");

        private final String value;

        public String toString() {
            return this.value;
        }

        private HighlightLocationType(String value) {
            this.value = value;
        }
    }
}

