/*
 * Decompiled with CFR 0.152.
 */
package com.guestindicators;

import com.guestindicators.GuestIndicatorsService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class GuestIndicatorsTileOverlay
extends Overlay {
    private final GuestIndicatorsService guestIndicatorsService;
    private final ConfigManager configManager;

    @Inject
    private GuestIndicatorsTileOverlay(GuestIndicatorsService guestIndicatorsService, ConfigManager configManager) {
        this.guestIndicatorsService = guestIndicatorsService;
        this.configManager = configManager;
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
    }

    public Dimension render(Graphics2D graphics) {
        if (!((Boolean)this.configManager.getConfiguration("playerindicators", "drawPlayerTiles", Boolean.class)).booleanValue()) {
            return null;
        }
        this.guestIndicatorsService.forEachPlayer((player, color) -> {
            Polygon poly = player.getCanvasTilePoly();
            if (poly != null) {
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
            }
        });
        return null;
    }
}

