/*
 * Decompiled with CFR 0.152.
 */
package com.guestindicators;

import com.guestindicators.ClanGuestTracker;
import com.guestindicators.GuestIndicatorsConfig;
import java.awt.Color;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.clan.ClanRank;
import net.runelite.api.clan.ClanSettings;
import net.runelite.api.clan.ClanTitle;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.party.PartyService;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsConfig;

@Singleton
public class GuestIndicatorsService {
    private final Client client;
    private final GuestIndicatorsConfig config;
    private final ConfigManager configManager;
    private final ClanGuestTracker clanGuestTracker;
    private final PartyService partyService;

    @Inject
    private GuestIndicatorsService(Client client, GuestIndicatorsConfig config, ConfigManager configManager, ClanGuestTracker clanGuestTracker, PartyService partyService) {
        this.config = config;
        this.client = client;
        this.configManager = configManager;
        this.clanGuestTracker = clanGuestTracker;
        this.partyService = partyService;
    }

    public void forEachPlayer(BiConsumer<Player, Color> consumer) {
        if (!(this.config.highlightClanGuests() || this.config.highlightGuestClanMembers() || this.config.highlightGuestClanGuests())) {
            return;
        }
        Player localPlayer = this.client.getLocalPlayer();
        for (Player player : this.client.getPlayers()) {
            if (player == null || player.getName() == null || player == localPlayer || this.partyService.isInParty() && !this.configManager.getConfiguration("playerindicators", "highlightPartyMembers", PlayerIndicatorsConfig.HighlightSetting.class).equals(PlayerIndicatorsConfig.HighlightSetting.DISABLED) && this.partyService.getMemberByDisplayName(player.getName()) != null || player.isFriend() && !this.configManager.getConfiguration("playerindicators", "highlightFriends", PlayerIndicatorsConfig.HighlightSetting.class).equals(PlayerIndicatorsConfig.HighlightSetting.DISABLED) || player.isFriendsChatMember() && !this.configManager.getConfiguration("playerindicators", "highlightFriendsChat", PlayerIndicatorsConfig.HighlightSetting.class).equals(PlayerIndicatorsConfig.HighlightSetting.DISABLED) || !this.configManager.getConfiguration("playerindicators", "highlightTeamMembers", PlayerIndicatorsConfig.HighlightSetting.class).equals(PlayerIndicatorsConfig.HighlightSetting.DISABLED) && localPlayer.getTeam() > 0 && localPlayer.getTeam() == player.getTeam() || player.isClanMember() && !this.configManager.getConfiguration("playerindicators", "highlightClanMembers", PlayerIndicatorsConfig.HighlightSetting.class).equals(PlayerIndicatorsConfig.HighlightSetting.DISABLED)) continue;
            if (this.config.highlightGuestClanMembers() && this.clanGuestTracker.isGuestClanMember(player)) {
                consumer.accept(player, this.config.getGuestClanMemberColor());
                continue;
            }
            if (this.config.highlightClanGuests() && this.clanGuestTracker.isClanGuest(player)) {
                consumer.accept(player, this.config.getClanGuestColor());
                continue;
            }
            if (!this.config.highlightGuestClanGuests() || !this.clanGuestTracker.isGuestClanGuest(player)) continue;
            consumer.accept(player, this.config.getGuestClanGuestColor());
        }
    }

    ClanTitle getClanTitle(Player player) {
        return this.getChatTitle(player, this.client.getClanChannel(), this.client.getClanSettings());
    }

    ClanTitle getGuestClanTitle(Player player) {
        return this.getChatTitle(player, this.client.getGuestClanChannel(), this.client.getGuestClanSettings());
    }

    private ClanTitle getChatTitle(Player player, ClanChannel clanChannel, ClanSettings clanSettings) {
        if (clanChannel == null || clanSettings == null) {
            return null;
        }
        ClanChannelMember member = clanChannel.findMember(player.getName());
        if (member == null) {
            return null;
        }
        ClanRank rank = member.getRank();
        return clanSettings.titleForRank(rank);
    }
}

