/*
 * Decompiled with CFR 0.152.
 */
package com.guestindicators;

import com.google.inject.Provides;
import com.guestindicators.ClanGuestTracker;
import com.guestindicators.GuestIndicatorsConfig;
import com.guestindicators.GuestIndicatorsMinimapOverlay;
import com.guestindicators.GuestIndicatorsOverlay;
import com.guestindicators.GuestIndicatorsService;
import com.guestindicators.GuestIndicatorsTileOverlay;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.clan.ClanTitle;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ChatIconManager;
import net.runelite.client.party.PartyService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Guest Indicators")
public class GuestIndicatorsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GuestIndicatorsPlugin.class);
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private GuestIndicatorsConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private GuestIndicatorsOverlay guestIndicatorsOverlay;
    @Inject
    private GuestIndicatorsTileOverlay guestIndicatorsTileOverlay;
    @Inject
    private GuestIndicatorsMinimapOverlay guestIndicatorsMinimapOverlay;
    @Inject
    private GuestIndicatorsService guestIndicatorsService;
    @Inject
    private Client client;
    @Inject
    private ChatIconManager chatIconManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClanGuestTracker clanGuestTracker;
    @Inject
    private PartyService partyService;

    @Provides
    GuestIndicatorsConfig provideConfig(ConfigManager configManager) {
        return (GuestIndicatorsConfig)configManager.getConfig(GuestIndicatorsConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.guestIndicatorsOverlay);
        this.overlayManager.add((Overlay)this.guestIndicatorsTileOverlay);
        this.overlayManager.add((Overlay)this.guestIndicatorsMinimapOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.guestIndicatorsOverlay);
        this.overlayManager.remove((Overlay)this.guestIndicatorsTileOverlay);
        this.overlayManager.remove((Overlay)this.guestIndicatorsMinimapOverlay);
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        MenuEntry[] menuEntries;
        if (this.client.isMenuOpen()) {
            return;
        }
        for (MenuEntry entry : menuEntries = this.client.getMenuEntries()) {
            Decorations decorations;
            MenuAction type = entry.getType();
            if (type != MenuAction.WALK && type != MenuAction.WIDGET_TARGET_ON_PLAYER && type != MenuAction.ITEM_USE_ON_PLAYER && type != MenuAction.PLAYER_FIRST_OPTION && type != MenuAction.PLAYER_SECOND_OPTION && type != MenuAction.PLAYER_THIRD_OPTION && type != MenuAction.PLAYER_FOURTH_OPTION && type != MenuAction.PLAYER_FIFTH_OPTION && type != MenuAction.PLAYER_SIXTH_OPTION && type != MenuAction.PLAYER_SEVENTH_OPTION && type != MenuAction.PLAYER_EIGTH_OPTION && type != MenuAction.RUNELITE_PLAYER) continue;
            Player[] players = this.client.getCachedPlayers();
            Player player = null;
            int identifier = entry.getIdentifier();
            if (type == MenuAction.WALK) {
                --identifier;
            }
            if (identifier >= 0 && identifier < players.length) {
                player = players[identifier];
            }
            if (player == null || (decorations = this.getDecorations(player)) == null) continue;
            String oldTarget = entry.getTarget();
            String newTarget = this.decorateTarget(oldTarget, decorations);
            entry.setTarget(newTarget);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.config.highlightClanGuests()) {
            this.clanGuestTracker.updateClan(false);
        }
        if (this.config.highlightGuestClanGuests() || this.config.highlightGuestClanGuests()) {
            this.clanGuestTracker.updateClan(true);
        }
    }

    private Decorations getDecorations(Player player) {
        boolean isPartyMember;
        if (player.isFriend() && !this.configManager.getConfiguration("playerindicators", "highlightFriends", PlayerIndicatorsConfig.HighlightSetting.class).equals(PlayerIndicatorsConfig.HighlightSetting.DISABLED) || player.isFriendsChatMember() && !this.configManager.getConfiguration("playerindicators", "highlightFriendsChat", PlayerIndicatorsConfig.HighlightSetting.class).equals(PlayerIndicatorsConfig.HighlightSetting.DISABLED) || player.getTeam() > 0 && this.client.getLocalPlayer().getTeam() == player.getTeam() && !this.configManager.getConfiguration("playerindicators", "highlightTeamMembers", PlayerIndicatorsConfig.HighlightSetting.class).equals(PlayerIndicatorsConfig.HighlightSetting.DISABLED) || player.isClanMember() && !this.configManager.getConfiguration("playerindicators", "highlightClanMembers", PlayerIndicatorsConfig.HighlightSetting.class).equals(PlayerIndicatorsConfig.HighlightSetting.DISABLED)) {
            return null;
        }
        boolean bl = isPartyMember = this.partyService.isInParty() && player.getName() != null && !this.configManager.getConfiguration("playerindicators", "highlightPartyMembers", PlayerIndicatorsConfig.HighlightSetting.class).equals(PlayerIndicatorsConfig.HighlightSetting.DISABLED) && this.partyService.getMemberByDisplayName(player.getName()) != null;
        if (isPartyMember) {
            return null;
        }
        int image = -1;
        Color color = null;
        if (this.config.highlightClanGuests() && this.clanGuestTracker.isClanGuest(player)) {
            ClanTitle clanTitle;
            color = this.config.getClanGuestColor();
            if (((Boolean)this.configManager.getConfiguration("playerindicators", "clanchatMenuIcons", Boolean.class)).booleanValue() && (clanTitle = this.guestIndicatorsService.getClanTitle(player)) != null) {
                image = this.chatIconManager.getIconNumber(clanTitle);
            }
        } else if (this.config.highlightGuestClanMembers() && this.clanGuestTracker.isGuestClanMember(player)) {
            ClanTitle clanTitle;
            color = this.config.getGuestClanMemberColor();
            if (this.config.showGuestClanChatRanks() && (clanTitle = this.guestIndicatorsService.getGuestClanTitle(player)) != null) {
                image = this.chatIconManager.getIconNumber(clanTitle);
            }
        } else if (this.config.highlightGuestClanGuests() && this.clanGuestTracker.isGuestClanGuest(player)) {
            ClanTitle clanTitle;
            color = this.config.getGuestClanGuestColor();
            if (this.config.showGuestClanChatRanks() && (clanTitle = this.guestIndicatorsService.getGuestClanTitle(player)) != null) {
                image = this.chatIconManager.getIconNumber(clanTitle);
            }
        }
        if (image == -1 && color == null) {
            return null;
        }
        return new Decorations(image, color);
    }

    private String decorateTarget(String oldTarget, Decorations decorations) {
        Object newTarget = oldTarget;
        if (decorations.getColor() != null && ((Boolean)this.configManager.getConfiguration("playerindicators", "colorPlayerMenu", Boolean.class)).booleanValue()) {
            int idx = oldTarget.indexOf(62);
            if (idx != -1) {
                newTarget = oldTarget.substring(idx + 1);
            }
            newTarget = ColorUtil.prependColorTag((String)newTarget, (Color)decorations.getColor());
        }
        if (decorations.getImage() != -1) {
            newTarget = "<img=" + decorations.getImage() + ">" + (String)newTarget;
        }
        return newTarget;
    }

    private Player findPlayer(String name) {
        for (Player player : this.client.getPlayers()) {
            if (!player.getName().equals(name)) continue;
            return player;
        }
        return null;
    }

    private static final class Decorations {
        private final int image;
        private final Color color;

        public Decorations(int image, Color color) {
            this.image = image;
            this.color = color;
        }

        public int getImage() {
            return this.image;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Decorations)) {
                return false;
            }
            Decorations other = (Decorations)o;
            if (this.getImage() != other.getImage()) {
                return false;
            }
            Color this$color = this.getColor();
            Color other$color = other.getColor();
            return !(this$color == null ? other$color != null : !((Object)this$color).equals(other$color));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getImage();
            Color $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
            return result;
        }

        public String toString() {
            return "GuestIndicatorsPlugin.Decorations(image=" + this.getImage() + ", color=" + this.getColor() + ")";
        }
    }
}

