/*
 * Decompiled with CFR 0.152.
 */
package com.guestindicators;

import com.guestindicators.ClanGuestTracker;
import com.guestindicators.GuestIndicatorsConfig;
import com.guestindicators.GuestIndicatorsService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.clan.ClanTitle;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ChatIconManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.Text;

@Singleton
public class GuestIndicatorsOverlay
extends Overlay {
    private static final int ACTOR_OVERHEAD_TEXT_MARGIN = 40;
    private static final int ACTOR_HORIZONTAL_TEXT_MARGIN = 10;
    private final GuestIndicatorsService guestIndicatorsService;
    private final GuestIndicatorsConfig config;
    private final ConfigManager configManager;
    private final ChatIconManager chatIconManager;
    private final ClanGuestTracker clanGuestTracker;

    @Inject
    private GuestIndicatorsOverlay(GuestIndicatorsConfig config, GuestIndicatorsService guestIndicatorsService, ConfigManager configManager, ChatIconManager chatIconManager, ClanGuestTracker clanGuestTracker) {
        this.config = config;
        this.guestIndicatorsService = guestIndicatorsService;
        this.configManager = configManager;
        this.chatIconManager = chatIconManager;
        this.clanGuestTracker = clanGuestTracker;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
    }

    public Dimension render(Graphics2D graphics) {
        this.guestIndicatorsService.forEachPlayer((player, color) -> this.renderPlayerOverlay(graphics, (Player)player, (Color)color));
        return null;
    }

    private void renderPlayerOverlay(Graphics2D graphics, Player actor, Color color) {
        ClanTitle clanTitle;
        int zOffset;
        String drawPlayerNamesConfig = (String)this.configManager.getConfiguration("playerindicators", "playerNamePosition", String.class);
        if ("DISABLED".equals(drawPlayerNamesConfig)) {
            return;
        }
        switch (drawPlayerNamesConfig) {
            case "MODEL_CENTER": 
            case "MODEL_RIGHT": {
                zOffset = actor.getLogicalHeight() / 2;
                break;
            }
            default: {
                zOffset = actor.getLogicalHeight() + 40;
            }
        }
        String name = Text.sanitize((String)actor.getName());
        Point textLocation = actor.getCanvasTextLocation(graphics, name, zOffset);
        if (drawPlayerNamesConfig.equals("MODEL_RIGHT")) {
            textLocation = actor.getCanvasTextLocation(graphics, "", zOffset);
            if (textLocation == null) {
                return;
            }
            textLocation = new Point(textLocation.getX() + 10, textLocation.getY());
        }
        if (textLocation == null) {
            return;
        }
        boolean other = (Boolean)this.configManager.getConfiguration("playerindicators", "highlightOthers", Boolean.class);
        BufferedImage rankImage = null;
        if (actor.isFriendsChatMember() && ((Boolean)this.configManager.getConfiguration("playerindicators", "highlightFriendsChat", Boolean.class)).booleanValue() && ((Boolean)this.configManager.getConfiguration("playerindicators", "clanMenuIcons", Boolean.class)).booleanValue() || actor.isClanMember() && ((Boolean)this.configManager.getConfiguration("playerindicators", "highlightClanMembers", Boolean.class)).booleanValue() && ((Boolean)this.configManager.getConfiguration("playerindicators", "clanchatMenuIcons", Boolean.class)).booleanValue()) {
            other = false;
        } else if (this.clanGuestTracker.isClanGuest(actor) && this.config.highlightClanGuests() && ((Boolean)this.configManager.getConfiguration("playerindicators", "clanchatMenuIcons", Boolean.class)).booleanValue()) {
            clanTitle = this.guestIndicatorsService.getClanTitle(actor);
            if (clanTitle != null) {
                rankImage = this.chatIconManager.getRankImage(clanTitle);
            }
        } else if (this.config.showGuestClanChatRanks() && (this.clanGuestTracker.isGuestClanMember(actor) && this.config.highlightGuestClanMembers() || this.clanGuestTracker.isGuestClanGuest(actor) && this.clanGuestTracker.isGuestClanGuest(actor)) && (clanTitle = this.guestIndicatorsService.getGuestClanTitle(actor)) != null) {
            rankImage = this.chatIconManager.getRankImage(clanTitle);
        }
        if (rankImage != null) {
            int imageNegativeMargin;
            int imageTextMargin;
            int imageWidth = rankImage.getWidth();
            if (drawPlayerNamesConfig.equals("MODEL_RIGHT")) {
                imageTextMargin = imageWidth;
                imageNegativeMargin = other ? imageWidth : 0;
            } else {
                imageTextMargin = imageWidth / 2;
                imageNegativeMargin = other ? imageWidth : imageWidth / 2;
            }
            int textHeight = graphics.getFontMetrics().getHeight() - graphics.getFontMetrics().getMaxDescent();
            Point imageLocation = new Point(textLocation.getX() - imageNegativeMargin - 1, textLocation.getY() - textHeight / 2 - rankImage.getHeight() / 2);
            OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)imageLocation, (BufferedImage)rankImage);
            if (!other) {
                textLocation = new Point(textLocation.getX() + imageTextMargin, textLocation.getY());
            }
        }
        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)name, (Color)color);
    }
}

