/*
 * Decompiled with CFR 0.152.
 */
package com.guestindicators;

import com.guestindicators.GuestIndicatorsConfig;
import com.guestindicators.GuestIndicatorsService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

@Singleton
public class GuestIndicatorsMinimapOverlay
extends Overlay {
    private final GuestIndicatorsService guestIndicatorsService;
    private final GuestIndicatorsConfig config;
    private final ConfigManager configManager;

    @Inject
    private GuestIndicatorsMinimapOverlay(GuestIndicatorsConfig config, GuestIndicatorsService guestIndicatorsService, ConfigManager configManager) {
        this.config = config;
        this.guestIndicatorsService = guestIndicatorsService;
        this.configManager = configManager;
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGHEST);
    }

    public Dimension render(Graphics2D graphics) {
        this.guestIndicatorsService.forEachPlayer((player, color) -> this.renderPlayerOverlay(graphics, (Player)player, (Color)color));
        return null;
    }

    private void renderPlayerOverlay(Graphics2D graphics, Player actor, Color color) {
        Point minimapLocation;
        String name = actor.getName().replace('\u00a0', ' ');
        if (((Boolean)this.configManager.getConfiguration("playerindicators", "drawMinimapNames", Boolean.class)).booleanValue() && (minimapLocation = actor.getMinimapLocation()) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)minimapLocation, (String)name, (Color)color);
        }
    }
}

