/*
 * Decompiled with CFR 0.152.
 */
package com.guestindicators;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.clan.ClanRank;

@Singleton
public class ClanGuestTracker {
    @Inject
    private Client client;
    private Map<String, ClanRank> clanPlayersToRank = new HashMap<String, ClanRank>();
    private Map<String, ClanRank> guestClanPlayersToRank = new HashMap<String, ClanRank>();

    void updateClan(boolean isGuestClan) {
        Map<String, ClanRank> playersToRank;
        ClanChannel clanChannel = isGuestClan ? this.client.getGuestClanChannel() : this.client.getClanChannel();
        Map<String, ClanRank> map = playersToRank = isGuestClan ? this.guestClanPlayersToRank : this.clanPlayersToRank;
        if (clanChannel == null) {
            playersToRank.clear();
            return;
        }
        HashMap<String, ClanRank> updatedMap = new HashMap<String, ClanRank>(playersToRank.size() * 4 / 3);
        for (ClanChannelMember member : clanChannel.getMembers()) {
            updatedMap.put(member.getName(), member.getRank());
        }
        if (isGuestClan) {
            this.guestClanPlayersToRank = updatedMap;
        } else {
            this.clanPlayersToRank = updatedMap;
        }
    }

    boolean isClanGuest(Player player) {
        if (this.clanPlayersToRank.containsKey(player.getName())) {
            return this.clanPlayersToRank.get(player.getName()).equals((Object)ClanRank.GUEST);
        }
        return false;
    }

    boolean isGuestClanGuest(Player player) {
        if (this.guestClanPlayersToRank.containsKey(player.getName())) {
            return this.guestClanPlayersToRank.get(player.getName()).equals((Object)ClanRank.GUEST);
        }
        return false;
    }

    public boolean isGuestClanMember(Player player) {
        if (this.guestClanPlayersToRank.containsKey(player.getName())) {
            return !this.guestClanPlayersToRank.get(player.getName()).equals((Object)ClanRank.GUEST);
        }
        return false;
    }
}

