/*
 * Decompiled with CFR 0.152.
 */
package com.osrsprofile.tracker;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.osrsprofile.OsrsProfileConfig;
import com.osrsprofile.api.Api;
import com.osrsprofile.tracker.AccountType;
import com.osrsprofile.tracker.dto.TrackingObject;
import com.osrsprofile.tracker.dto.TrackingRequest;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneScapeProfileType;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerTracker {
    private static final Logger log = LoggerFactory.getLogger(PlayerTracker.class);
    private Map<String, TrackingObject> playerData = new HashMap<String, TrackingObject>();
    @Inject
    private Client client;
    @Inject
    private Gson gson;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Api api;
    private String accountHash = null;

    public void setAccountHash(String accountHash, OsrsProfileConfig config) {
        log.debug("Account hash: " + accountHash);
        if (!StringUtils.equals((CharSequence)accountHash, (CharSequence)this.accountHash)) {
            this.accountHash = accountHash;
            this.fetchPlayerData(config);
        }
    }

    public void fetchPlayerData(OsrsProfileConfig config) {
        if (this.shouldNotMakeRequests()) {
            return;
        }
        try {
            Response response = this.api.get(this.accountHash + "?quests=" + config.trackQuests() + "&skills=" + config.trackSkills() + "&minigames=" + config.trackMinigames() + "&diaries=" + config.trackDiaries() + "&combat=" + config.trackCombat() + "&bosskills=" + config.trackBossKills() + "&slayermonsters=" + config.trackSlayerMonstersKills() + "&collectionlog=" + config.trackCollectionLog());
            if (response.code() == 200) {
                Type type = new TypeToken<Map<String, TrackingObject>>(){}.getType();
                String responseString = response.body().string();
                this.playerData = (Map)this.gson.fromJson(responseString, type);
            } else {
                log.error("Could not fetch player data from api, api returned: (" + response.code() + ") - " + response.body().string());
            }
        }
        catch (Exception e) {
            log.error("Could not fetch model from api", (Throwable)e);
        }
    }

    public void submitToApi() {
        if (this.shouldNotMakeRequests()) {
            return;
        }
        this.updatePlayerModel(this.client);
        try {
            TrackingRequest requestObj = new TrackingRequest();
            requestObj.data = this.playerData;
            requestObj.username = this.client.getLocalPlayer().getName();
            requestObj.accountType = this.getAccountType();
            Gson gson = this.gson.newBuilder().serializeNulls().create();
            String json = gson.toJson((Object)requestObj);
            this.api.post(this.accountHash, json);
        }
        catch (Exception e) {
            log.error("Could not submit player data to api", (Throwable)e);
        }
    }

    private void updatePlayerModel(Client client) {
        this.playerData.forEach((key, item) -> {
            item.value = this.getValue(item.index, item.type, client);
        });
    }

    private Integer getValue(String index, String type, Client client) {
        Integer value = null;
        switch (type) {
            case "skill": {
                value = client.getSkillExperience(Skill.valueOf((String)index));
                break;
            }
            case "varb": {
                value = client.getVarbitValue(Integer.parseInt(index));
                break;
            }
            case "varp": {
                value = client.getVarpValue(Integer.parseInt(index));
                break;
            }
            case "killcount": {
                value = (Integer)this.configManager.getRSProfileConfiguration("killcount", index, Integer.TYPE);
                break;
            }
            case "personalbest": {
                Double pb = (Double)this.configManager.getRSProfileConfiguration("personalbest", index, Double.TYPE);
                value = pb != null ? Integer.valueOf(Math.toIntExact(Math.round(pb))) : null;
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    private String getAccountType() {
        return AccountType.getType(this.client.getVarbitValue(1777)).toString();
    }

    private boolean shouldNotMakeRequests() {
        return this.accountHash == null || StringUtils.equals((CharSequence)this.accountHash, (CharSequence)"-1") || RuneScapeProfileType.getCurrent((Client)this.client) != RuneScapeProfileType.STANDARD || this.client.getGameState() == GameState.LOGIN_SCREEN || this.client.getGameState() == GameState.LOGIN_SCREEN_AUTHENTICATOR;
    }
}

