/*
 * Decompiled with CFR 0.152.
 */
package com.osrsprofile.exporter;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;

public class TextureColor {
    @Inject
    private Client client;
    private static final Map<Integer, Color> colorCache = new HashMap<Integer, Color>();

    public Color getColor(int textureId) {
        if (colorCache.containsKey(textureId)) {
            return colorCache.get(textureId);
        }
        if (this.client == null) {
            return new Color(255, 255, 255);
        }
        int[] pixels = this.client.getTextureProvider().load(textureId);
        int r = 0;
        int g = 0;
        int b = 0;
        int n = 0;
        for (int pixel : pixels) {
            if (pixel == 0) continue;
            Color c = new Color(pixel);
            r += c.getRed();
            g += c.getGreen();
            b += c.getBlue();
            ++n;
        }
        Color c = new Color(r / n, g / n, b / n);
        colorCache.put(textureId, c);
        return c;
    }
}

