/*
 * Decompiled with CFR 0.152.
 */
package com.osrsprofile.exporter;

import com.osrsprofile.exporter.JagexColor;
import com.osrsprofile.exporter.TextureColor;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Model;

public class PlayerModelExporter {
    @Inject
    private Client client;
    @Inject
    private TextureColor textureColor;

    public ByteArrayOutputStream export() throws IOException {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        Model model = this.client.getLocalPlayer().getModel();
        for (int fi = 0; fi < model.getFaceCount(); ++fi) {
            Color vc3;
            Object vc2;
            Color vc1;
            int textureId = -1;
            if (model.getFaceTextures() != null) {
                textureId = model.getFaceTextures()[fi];
            }
            if (textureId != -1) {
                vc1 = this.textureColor.getColor(textureId);
                vc2 = vc1;
                vc3 = vc1;
            } else {
                vc1 = new Color(JagexColor.HSLtoRGB((short)model.getFaceColors1()[fi], 0.9));
                vc2 = new Color(JagexColor.HSLtoRGB((short)model.getFaceColors2()[fi], 0.9));
                vc3 = new Color(JagexColor.HSLtoRGB((short)model.getFaceColors3()[fi], 0.9));
            }
            int vi1 = model.getFaceIndices1()[fi];
            int vi2 = model.getFaceIndices2()[fi];
            int vi3 = model.getFaceIndices3()[fi];
            int vx1 = model.getVerticesX()[vi1];
            int vx2 = model.getVerticesX()[vi2];
            int vx3 = model.getVerticesX()[vi3];
            int vy1 = -model.getVerticesY()[vi1];
            int vy2 = -model.getVerticesY()[vi2];
            int vy3 = -model.getVerticesY()[vi3];
            int vz1 = model.getVerticesZ()[vi1];
            int vz2 = model.getVerticesZ()[vi2];
            int vz3 = model.getVerticesZ()[vi3];
            vertices.add(new Vertex(vx1, vy1, vz1, vc1.getRed(), vc1.getGreen(), vc1.getBlue()));
            vertices.add(new Vertex(vx2, vy2, vz2, ((Color)vc2).getRed(), ((Color)vc2).getGreen(), ((Color)vc2).getBlue()));
            vertices.add(new Vertex(vx3, vy3, vz3, vc3.getRed(), vc3.getGreen(), vc3.getBlue()));
        }
        ByteArrayOutputStream ply = new ByteArrayOutputStream();
        PrintWriter plyHeader = new PrintWriter(ply);
        plyHeader.println("ply");
        plyHeader.println("format binary_little_endian 1.0");
        plyHeader.println("element vertex " + vertices.size());
        plyHeader.println("property int16 x");
        plyHeader.println("property int16 y");
        plyHeader.println("property int16 z");
        plyHeader.println("property uint8 red");
        plyHeader.println("property uint8 green");
        plyHeader.println("property uint8 blue");
        plyHeader.println("element face " + model.getFaceCount());
        plyHeader.println("property list uint8 int16 vertex_indices");
        plyHeader.println("end_header");
        plyHeader.flush();
        for (Vertex v : vertices) {
            ply.write(PlayerModelExporter.le(v.x));
            ply.write(PlayerModelExporter.le(v.z));
            ply.write(PlayerModelExporter.le(v.y));
            ply.write((byte)v.r);
            ply.write((byte)v.g);
            ply.write((byte)v.b);
        }
        for (int i = 0; i < model.getFaceCount(); ++i) {
            int vi = i * 3;
            ply.write(3);
            ply.write(PlayerModelExporter.le(vi));
            ply.write(PlayerModelExporter.le(vi + 1));
            ply.write(PlayerModelExporter.le(vi + 2));
        }
        ply.flush();
        return ply;
    }

    private static byte[] le(int n) {
        byte[] b = new byte[]{(byte)n, (byte)(n >> 8)};
        return b;
    }

    private static class Vertex {
        public int x;
        public int y;
        public int z;
        public int r;
        public int g;
        public int b;

        public Vertex(int x, int y, int z, int r, int g, int b) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Vertex vertex = (Vertex)o;
            return this.x == vertex.x && this.y == vertex.y && this.z == vertex.z && this.r == vertex.r && this.g == vertex.g && this.b == vertex.b;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z, this.r, this.g, this.b);
        }
    }
}

