/*
 * Decompiled with CFR 0.152.
 */
package com.osrsprofile.exporter;

import com.osrsprofile.api.Api;
import com.osrsprofile.exporter.PlayerModelExporter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.kit.KitType;
import net.runelite.client.RuneLite;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerExporter {
    private static final Logger log = LoggerFactory.getLogger(PlayerExporter.class);
    @Inject
    private Api api;
    @Inject
    private Client client;
    @Inject
    private PlayerModelExporter playerModelExporter;
    @Inject
    @Named(value="developerMode")
    boolean developerMode;
    private final int[] capeBlacklist = new int[]{6570, 21285, 21295};
    private final int[] weaponBlacklist = new int[]{12788};

    public void export() {
        try {
            if (this.hasBlacklistedEquipment(KitType.CAPE, this.capeBlacklist)) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "<col=ff0000>Animated capes are not allowed. Please unequip or switch for another cape", null);
                return;
            }
            if (this.hasBlacklistedEquipment(KitType.WEAPON, this.weaponBlacklist)) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "<col=ff0000>Animated weapons are not allowed. Please unequip or switch for another weapon", null);
                return;
            }
            ByteArrayOutputStream stream = this.playerModelExporter.export();
            String fileName = this.client.getAccountHash() + ".ply";
            if (this.developerMode) {
                boolean deleted;
                File file = new File(RuneLite.RUNELITE_DIR, fileName);
                if (file.isFile() && !(deleted = file.delete())) {
                    log.debug("Could not delete model file in runelite dir");
                }
                FileOutputStream fos = new FileOutputStream(file);
                stream.writeTo(fos);
            }
            MultipartBody formBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("model", fileName, RequestBody.create((MediaType)MediaType.parse((String)"application/ply"), (byte[])stream.toByteArray())).build();
            this.api.post(this.client.getAccountHash() + "/model", (RequestBody)formBody);
        }
        catch (Exception e) {
            log.error("Could not export player model", (Throwable)e);
        }
    }

    private boolean hasBlacklistedEquipment(KitType equipmentType, int[] blacklist) {
        int currentCape = this.client.getLocalPlayer().getPlayerComposition().getEquipmentId(equipmentType);
        return ArrayUtils.contains((int[])blacklist, (int)currentCape);
    }
}

