/*
 * Decompiled with CFR 0.152.
 */
package com.osrsprofile.api;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Api {
    private static final Logger log = LoggerFactory.getLogger(Api.class);
    private final String API_URL = "https://api.osrsprofile.com/runelite/player";
    private final String DEV_URL = "http://osrsprofilebackend.test/runelite/player";
    @Inject
    private OkHttpClient httpClient;
    @Inject
    @Named(value="developerMode")
    boolean developerMode;

    public Response get(String route) throws IOException {
        Request request = this.getDefaultRequestBuilder(route).build();
        Response response = this.httpClient.newCall(request).execute();
        log.debug("RECEIVED " + request.url() + ": " + response.peekBody(Long.MAX_VALUE).string());
        return response;
    }

    public Response post(String route, String json) throws IOException {
        Request request = this.getDefaultRequestBuilder(route).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json)).addHeader("Content-Type", "application/json").build();
        log.debug("SENT " + request.url() + ": " + json);
        Response response = this.httpClient.newCall(request).execute();
        log.debug("RECEIVED " + request.url() + ": " + response.peekBody(Long.MAX_VALUE).string());
        return response;
    }

    public Response post(String route, RequestBody formBody) throws IOException {
        Request request = this.getDefaultRequestBuilder(route).post(formBody).addHeader("Content-Type", "multipart/form-data").build();
        log.debug("SENT " + request.url() + ": " + formBody);
        Response response = this.httpClient.newCall(request).execute();
        log.debug("RECEIVED " + request.url() + ": " + response.peekBody(Long.MAX_VALUE).string());
        return response;
    }

    private Request.Builder getDefaultRequestBuilder(String route) {
        return new Request.Builder().url((this.developerMode ? "http://osrsprofilebackend.test/runelite/player" : "https://api.osrsprofile.com/runelite/player") + "/" + route).addHeader("User-Agent", "RuneLite");
    }
}

