/*
 * Decompiled with CFR 0.152.
 */
package com.osrsprofile;

import com.google.inject.Provides;
import com.osrsprofile.OsrsProfileConfig;
import com.osrsprofile.exporter.PlayerExporter;
import com.osrsprofile.tracker.PlayerTracker;
import java.awt.Desktop;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.menus.WidgetMenuOption;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="OSRS Profile")
public class OsrsProfilePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(OsrsProfilePlugin.class);
    @Inject
    private Client client;
    @Inject
    private OsrsProfileConfig config;
    @Inject
    private PlayerTracker playerTracker;
    @Inject
    private PlayerExporter playerExporter;
    @Inject
    private Provider<MenuManager> menuManager;
    private final int SECONDS_BETWEEN_UPLOADS = 60;
    private static final String MENU_OPTION = "Profile";
    private static final String MENU_TARGET = "Player";
    private static final String EXPORT_MODEL = "Export Model to OSRS Profile";
    private static final WidgetMenuOption FIXED_EQUIPMENT_TAB_EXPORT = new WidgetMenuOption("Export Model to OSRS Profile", "Player", WidgetInfo.FIXED_VIEWPORT_EQUIPMENT_TAB);
    private static final WidgetMenuOption RESIZABLE_EQUIPMENT_TAB_EXPORT = new WidgetMenuOption("Export Model to OSRS Profile", "Player", WidgetInfo.RESIZABLE_VIEWPORT_EQUIPMENT_TAB);
    private static final WidgetMenuOption RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB_EXPORT = new WidgetMenuOption("Export Model to OSRS Profile", "Player", WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB);

    protected void startUp() {
        log.info("Player tracker started");
        ((MenuManager)this.menuManager.get()).addPlayerMenuItem(MENU_OPTION);
        ((MenuManager)this.menuManager.get()).addManagedCustomMenu(FIXED_EQUIPMENT_TAB_EXPORT, this::exportLocalPlayerModel);
        ((MenuManager)this.menuManager.get()).addManagedCustomMenu(RESIZABLE_EQUIPMENT_TAB_EXPORT, this::exportLocalPlayerModel);
        ((MenuManager)this.menuManager.get()).addManagedCustomMenu(RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB_EXPORT, this::exportLocalPlayerModel);
    }

    protected void shutDown() {
        log.info("Player tracker stopped");
        ((MenuManager)this.menuManager.get()).removePlayerMenuItem(MENU_OPTION);
        ((MenuManager)this.menuManager.get()).removeManagedCustomMenu(FIXED_EQUIPMENT_TAB_EXPORT);
        ((MenuManager)this.menuManager.get()).removeManagedCustomMenu(RESIZABLE_EQUIPMENT_TAB_EXPORT);
        ((MenuManager)this.menuManager.get()).removeManagedCustomMenu(RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB_EXPORT);
    }

    @Provides
    OsrsProfileConfig provideConfig(ConfigManager configManager) {
        return (OsrsProfileConfig)configManager.getConfig(OsrsProfileConfig.class);
    }

    @Schedule(period=60L, unit=ChronoUnit.SECONDS)
    public void submitToAPI() {
        if (this.client != null) {
            this.playerTracker.submitToApi();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        String accountHash = String.valueOf(this.client.getAccountHash());
        this.playerTracker.setAccountHash(accountHash, this.config);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        block5: {
            if (event.getMenuAction() == MenuAction.RUNELITE_PLAYER && event.getMenuOption().equals(MENU_OPTION)) {
                Player player = event.getMenuEntry().getPlayer();
                if (player == null) {
                    return;
                }
                String target = player.getName();
                try {
                    if (!Desktop.isDesktopSupported()) break block5;
                    Desktop desktop = Desktop.getDesktop();
                    if (desktop.isSupported(Desktop.Action.BROWSE)) {
                        String playerName = URLEncoder.encode(target, StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20");
                        desktop.browse(URI.create("https://osrsprofile.com/player/" + playerName));
                        break block5;
                    }
                    throw new Exception("Desktop not supported");
                }
                catch (Exception e) {
                    log.error(e.toString());
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Unable to open the profile of the interacted player.", null);
                }
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("osrsprofile")) {
            this.playerTracker.fetchPlayerData(this.config);
        }
    }

    public void exportLocalPlayerModel(MenuEntry entry) {
        this.playerExporter.export();
    }
}

