/*
 * Decompiled with CFR 0.152.
 */
package net.antipixel.nexus.ui;

import net.antipixel.nexus.ui.ComponentEffect;
import net.antipixel.nexus.ui.UIComponent;

public class FadePulseEffect
implements ComponentEffect {
    private static final float MAX_OPACITY = 1.0f;
    private Direction fadeDirection = Direction.OUT;
    private float minimumOpacity;
    private float opacity;
    private float speed;

    public FadePulseEffect(float minOpacity, float speed) {
        this.minimumOpacity = minOpacity;
        this.opacity = 1.0f;
        this.speed = speed;
    }

    @Override
    public void onUpdate() {
        if (this.opacity <= this.minimumOpacity) {
            this.fadeDirection = Direction.IN;
        }
        if (this.opacity >= 1.0f) {
            this.fadeDirection = Direction.OUT;
        }
        this.opacity += this.fadeDirection == Direction.IN ? this.speed : -this.speed;
    }

    @Override
    public void apply(UIComponent component) {
        component.setOpacity(this.opacity);
    }

    @Override
    public void onRemoved(UIComponent component) {
        component.setOpacity(1.0f);
    }

    static enum Direction {
        IN,
        OUT;

    }
}

