/*
 * Decompiled with CFR 0.152.
 */
package net.antipixel.nexus;

import com.google.gson.Gson;
import com.google.inject.Provides;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.antipixel.nexus.SpoofMenuEntry;
import net.antipixel.nexus.Teleport;
import net.antipixel.nexus.config.NexusConfig;
import net.antipixel.nexus.config.TeleportNameMode;
import net.antipixel.nexus.definition.IconDefinition;
import net.antipixel.nexus.definition.RegionDefinition;
import net.antipixel.nexus.definition.TeleportDefinition;
import net.antipixel.nexus.sprites.SpriteDefinition;
import net.antipixel.nexus.ui.FadePulseEffect;
import net.antipixel.nexus.ui.UIButton;
import net.antipixel.nexus.ui.UICheckBox;
import net.antipixel.nexus.ui.UIComponent;
import net.antipixel.nexus.ui.UIFadeButton;
import net.antipixel.nexus.ui.UIGraphic;
import net.antipixel.nexus.ui.UIPage;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.SpriteOverride;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;

@PluginDescriptor(name="Nexus Menu Map", description="Replaces the player owned house teleport Nexus menu", tags={"poh", "portal", "teleport", "nexus"})
public class NexusMapPlugin
extends Plugin {
    private static final int GROUP_NEXUS_PORTAL = 17;
    private static final int ID_PORTAL_WINDOW = 0x110001;
    private static final int ID_PORTAL_PANEL = 0x110002;
    private static final int ID_PORTAL_MODEL = 0x110003;
    private static final int ID_SCRY_TEXT = 0x110004;
    private static final int ID_SCRY_SELECT = 0x110005;
    private static final int ID_KEYEVENTS_ALTERNATE = 0x110007;
    private static final int ID_KEYEVENTS_PRIMARY = 0x110008;
    private static final int ID_SCROLLBOX_BORDER = 0x110009;
    private static final int ID_SCRY_RADIO_PANE = 0x11000A;
    private static final int ID_TELEPORT_LIST = 0x11000B;
    private static final int ID_LOC_LABELS_PRIMARY = 0x11000C;
    private static final int ID_SCROLLBAR = 0x11000E;
    private static final int ID_LOC_LABELS_ALTERNATE = 0x110010;
    private static final int TELE_ICON_SIZE = 24;
    private static final int MAP_SPRITE_POS_X = 39;
    private static final int MAP_SPRITE_POS_Y = 53;
    private static final int INDEX_MAP_SPRITE_WIDTH = 400;
    private static final int INDEX_MAP_SPRITE_HEIGHT = 214;
    private static final int REGION_MAP_SPRITE_WIDTH = 478;
    private static final int REGION_MAP_SPRITE_HEIGHT = 272;
    private static final int MAP_ICON_WIDTH = 50;
    private static final int MAP_ICON_HEIGHT = 41;
    private static final int SCRIPT_TRIGGER_KEY = 1437;
    private static final int REGION_MAP_MAIN = 2721;
    private static final int VARBIT_NEXUS_MODE = 6671;
    private static final String ACTION_TEXT_TELE = "Teleport";
    private static final String ACTION_TEXT_SCRY = "Scry";
    private static final String ACTION_TEXT_SELECT = "Select";
    private static final String ACTION_TEXT_BACK = "Back";
    private static final String ACTION_TEXT_HOTKEY = "Set Hotkey";
    private static final String NAME_TEXT_TOGGLE = "Map Mode";
    private static final float FADE_EFFECT_MIN_OPACITY = 0.5f;
    private static final float FADE_EFFECT_SPEED = 0.01f;
    private static final String CFG_GROUP = "nexusMapCFG";
    private static final String CFG_KEY_STATE = "prevState";
    private static final String CFG_BTM_KEY = "keybind.telenexus";
    private static final String DEF_FILE_REGIONS = "RegionDef.json";
    private static final String DEF_FILE_SPRITES = "SpriteDef.json";
    private static final String TELE_NAME_PATTERN = "<col=ffffff>(.+)</col> :  (.+)";
    private static final String PARENTHESISED_ALIAS_FORMAT = "%s (%s)";
    private static final String SHORTCUT_COLOUR_TAG = "<col=ffffff>";
    private static final String PLUGIN_NAME_BTM = "Better Teleport Menu";
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private NexusConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private EventBus eventBus;
    @Inject
    private Gson gson;
    private RegionDefinition[] regionDefinitions;
    private SpriteDefinition[] spriteDefinitions;
    private Map<String, TeleportDefinition> teleportDefinitions;
    private boolean mapEnabled;
    private boolean switchingModes;
    private String teleportAction;
    private Map<String, Teleport> availableTeleports;
    private Map<String, UIButton> activeTeleportButtons;
    private List<Integer> hiddenWidgetIDs;
    private UIGraphic mapGraphic;
    private UIGraphic[] indexRegionGraphics;
    private UIButton[] indexRegionIcons;
    private UIPage indexPage;
    private List<UIPage> mapPages;
    private FadePulseEffect fadeEffect;
    private Queue<Runnable> clientTickQueue;

    protected void startUp() {
        this.loadDefinitions();
        this.buildTeleportDefinitionLookup();
        this.createHiddenWidgetList();
        this.spriteManager.addSpriteOverrides((SpriteOverride[])this.spriteDefinitions);
        this.activeTeleportButtons = new HashMap<String, UIButton>();
        this.clientTickQueue = new ArrayDeque<Runnable>();
        this.fadeEffect = new FadePulseEffect(0.5f, 0.01f);
    }

    @Subscribe
    public void onClientTick(ClientTick e) {
        if (!this.clientTickQueue.isEmpty()) {
            this.clientThread.invokeLater(this.clientTickQueue.remove());
        }
        this.fadeEffect.onUpdate();
        this.activeTeleportButtons.values().forEach(UIComponent::refreshEffect);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        switch (e.getKey()) {
            case "teleportIconBorder": {
                this.clientThread.invokeLater(this::updateIconBorderStyle);
                break;
            }
            case "teleportFade": {
                this.clientThread.invokeLater(this::resetFadeAnimation);
                break;
            }
            case "displayShortcuts": 
            case "teleportName": {
                this.clientThread.invokeLater(this::updateTeleportButtonNames);
                break;
            }
            default: {
                if (!e.getKey().startsWith(CFG_BTM_KEY)) break;
                this.clientTickQueue.add(this::updateTeleportButtonNames);
                this.clientTickQueue.add(this::updateTeleportButtonNames);
            }
        }
    }

    @Provides
    NexusConfig getConfig(ConfigManager configManager) {
        return (NexusConfig)configManager.getConfig(NexusConfig.class);
    }

    protected void shutDown() {
        this.spriteManager.removeSpriteOverrides((SpriteOverride[])this.spriteDefinitions);
        this.regionDefinitions = null;
        this.spriteDefinitions = null;
        this.teleportDefinitions.clear();
        this.hiddenWidgetIDs.clear();
    }

    private void loadDefinitions() {
        this.regionDefinitions = this.loadDefinitionResource(RegionDefinition[].class, DEF_FILE_REGIONS, this.gson);
        this.spriteDefinitions = this.loadDefinitionResource(SpriteDefinition[].class, DEF_FILE_SPRITES, this.gson);
    }

    private void buildTeleportDefinitionLookup() {
        this.teleportDefinitions = new HashMap<String, TeleportDefinition>();
        for (RegionDefinition regionDef : this.regionDefinitions) {
            for (TeleportDefinition teleportDef : regionDef.getTeleportDefinitions()) {
                this.teleportDefinitions.put(teleportDef.getName(), teleportDef);
                if (!teleportDef.hasAlias()) continue;
                this.teleportDefinitions.put(teleportDef.getAlias(), teleportDef);
                this.teleportDefinitions.put(this.getParenthesisedName(teleportDef), teleportDef);
            }
        }
    }

    private <T> T loadDefinitionResource(Class<T> classType, String resource, Gson gson) {
        InputStream resourceStream = classType.getResourceAsStream(resource);
        InputStreamReader definitionReader = new InputStreamReader(resourceStream);
        return (T)gson.fromJson((Reader)definitionReader, classType);
    }

    private void createHiddenWidgetList() {
        this.hiddenWidgetIDs = new ArrayList<Integer>();
        this.hiddenWidgetIDs.add(0x110003);
        this.hiddenWidgetIDs.add(0x110004);
        this.hiddenWidgetIDs.add(0x110005);
        this.hiddenWidgetIDs.add(0x110009);
        this.hiddenWidgetIDs.add(0x11000B);
        this.hiddenWidgetIDs.add(0x11000E);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked e) {
        if (e.getWidget() != null && e.getWidget().getId() == 0x11000A) {
            this.switchingModes = true;
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged e) {
        if (e.getVarbitId() != 6671) {
            return;
        }
        this.teleportAction = this.getModeAction();
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded e) {
        if (e.getGroupId() == 17) {
            Widget window = this.client.getWidget(0x110001);
            this.buildAvailableTeleportList();
            this.updateDisplayedMenu();
            this.createMenuPages();
            this.createIndexMenu(window);
            this.createMapGraphic(window);
            this.createBackButton(window);
            this.createTeleportWidgets(window);
            this.createToggleCheckbox(window);
            this.updateMapState(window);
        }
    }

    private void setDefaultWidgetVisibility(boolean visible) {
        for (Integer packedID : this.hiddenWidgetIDs) {
            this.client.getWidget(packedID.intValue()).setHidden(!visible);
        }
    }

    private void updateIconBorderStyle() {
        this.activeTeleportButtons.values().forEach(button -> button.setBorder(this.config.borderStyle()));
    }

    private void resetFadeAnimation() {
        this.activeTeleportButtons.values().forEach(teleButton -> {
            if (this.config.fadeAnimation()) {
                teleButton.setEffect(this.fadeEffect);
            } else {
                teleButton.clearEffect();
            }
        });
    }

    private void updateTeleportButtonNames() {
        this.buildAvailableTeleportList();
        for (String teleportName : this.activeTeleportButtons.keySet()) {
            UIButton teleportButton = this.activeTeleportButtons.get(teleportName);
            TeleportDefinition teleportDef = this.teleportDefinitions.get(teleportName);
            Teleport teleport = this.getAvailableTeleport(teleportDef);
            teleportButton.setName(this.generateTeleportName(teleport));
        }
    }

    private void buildAvailableTeleportList() {
        this.availableTeleports = new HashMap<String, Teleport>();
        Pattern labelPattern = Pattern.compile(TELE_NAME_PATTERN);
        Widget primaryParent = this.client.getWidget(0x11000C);
        Widget alternateParent = this.client.getWidget(0x110010);
        this.availableTeleports.putAll(this.getTeleportsFromLabelWidget(primaryParent, false, labelPattern));
        this.availableTeleports.putAll(this.getTeleportsFromLabelWidget(alternateParent, true, labelPattern));
    }

    private void updateDisplayedMenu() {
        if (this.switchingModes) {
            this.switchingModes = false;
        } else {
            this.mapEnabled = this.getInitialMapState();
        }
    }

    private boolean getInitialMapState() {
        switch (this.config.initialMode()) {
            case NEXUS_MAP: {
                return true;
            }
            case DEFAULT_MENU: {
                return false;
            }
            case REMEMBER_PREVIOUS: {
                return this.getPreviousDisplayMode();
            }
        }
        return false;
    }

    private Map<String, Teleport> getTeleportsFromLabelWidget(Widget labelParent, boolean alt, Pattern pattern) {
        Widget[] labelWidgets = labelParent.getDynamicChildren();
        HashMap<String, Teleport> teleports = new HashMap<String, Teleport>();
        for (Widget child : labelWidgets) {
            String teleportName;
            String shortcutKey;
            if (child.getText().contains(SHORTCUT_COLOUR_TAG)) {
                Matcher matcher = pattern.matcher(child.getText());
                if (!matcher.matches()) continue;
                shortcutKey = matcher.group(1);
                teleportName = matcher.group(2);
            } else {
                shortcutKey = null;
                teleportName = child.getText();
            }
            if (!this.teleportDefinitions.containsKey(teleportName)) continue;
            TeleportDefinition teleportDef = this.teleportDefinitions.get(teleportName);
            teleports.put(teleportName, new Teleport(teleportDef, child, shortcutKey, alt));
        }
        return teleports;
    }

    private void createMenuPages() {
        this.indexPage = new UIPage();
        this.mapPages = new ArrayList<UIPage>(this.regionDefinitions.length);
        for (int i = 0; i < this.regionDefinitions.length; ++i) {
            this.mapPages.add(new UIPage());
        }
    }

    private void createIndexMenu(Widget window) {
        Widget backingWidget = window.createChild(-1, 5);
        UIGraphic indexBackingGraphic = new UIGraphic(backingWidget);
        indexBackingGraphic.setPosition(39, 53);
        indexBackingGraphic.setSize(400, 214);
        indexBackingGraphic.setSprite(2721);
        this.indexRegionGraphics = new UIGraphic[this.regionDefinitions.length];
        this.indexRegionIcons = new UIButton[this.regionDefinitions.length];
        this.indexPage.add(indexBackingGraphic);
        for (int i = 0; i < this.regionDefinitions.length; ++i) {
            RegionDefinition regionDef = this.regionDefinitions[i];
            Widget regionGraphic = window.createChild(-1, 5);
            this.indexRegionGraphics[i] = new UIGraphic(regionGraphic);
            this.indexRegionGraphics[i].setPosition(39, 53);
            this.indexRegionGraphics[i].setSize(400, 214);
            this.indexRegionGraphics[i].setSprite(regionDef.getIndexSprite());
            this.indexPage.add(this.indexRegionGraphics[i]);
            if (!regionDef.hasTeleports()) continue;
            Widget regionIcon = window.createChild(-1, 5);
            IconDefinition iconDef = regionDef.getIcon();
            this.indexRegionIcons[i] = new UIButton(regionIcon);
            this.indexRegionIcons[i].setName(regionDef.getName());
            this.indexRegionIcons[i].setPosition(iconDef.getX(), iconDef.getY());
            this.indexRegionIcons[i].setSize(50, 41);
            this.indexRegionIcons[i].setSprites(iconDef.getSpriteStandard(), iconDef.getSpriteHover());
            this.indexRegionIcons[i].setOnHoverListener(c -> this.onIconHover(regionDef.getId()));
            this.indexRegionIcons[i].setOnLeaveListener(c -> this.onIconLeave(regionDef.getId()));
            this.indexRegionIcons[i].addAction(ACTION_TEXT_SELECT, () -> this.onIconClicked(regionDef.getId()));
            this.indexPage.add(this.indexRegionIcons[i]);
        }
    }

    private void createMapGraphic(Widget window) {
        Widget mapWidget = window.createChild(-1, 5);
        this.mapGraphic = new UIGraphic(mapWidget);
        this.mapGraphic.setPosition(7, 35);
        this.mapGraphic.setSize(478, 272);
        this.mapPages.forEach(page -> page.add(this.mapGraphic));
    }

    private void createBackButton(Widget window) {
        Widget backArrowWidget = window.createChild(-1, 5);
        UIFadeButton backArrowButton = new UIFadeButton(backArrowWidget);
        backArrowButton.setSprites(1122);
        backArrowButton.setPosition(13, 41);
        backArrowButton.setSize(30, 23);
        backArrowButton.addAction(ACTION_TEXT_BACK, this::onBackButtonPressed);
        this.mapPages.forEach(page -> page.add(backArrowButton));
    }

    private void createTeleportWidgets(Widget window) {
        this.activeTeleportButtons.clear();
        boolean betterTeleportMenuActive = this.isBetterTeleportMenuActive();
        for (int i = 0; i < this.regionDefinitions.length; ++i) {
            TeleportDefinition[] teleportDefs;
            RegionDefinition regionDef = this.regionDefinitions[i];
            for (TeleportDefinition teleportDef : teleportDefs = regionDef.getTeleportDefinitions()) {
                Widget teleportWidget = window.createChild(-1, 5);
                UIButton teleportButton = new UIButton(teleportWidget);
                teleportButton.setSize(24, 24);
                teleportButton.setX(teleportDef.getSpriteX());
                teleportButton.setY(teleportDef.getSpriteY());
                teleportButton.setVisibility(false);
                if (this.config.fadeAnimation()) {
                    teleportButton.setEffect(this.fadeEffect);
                }
                this.mapPages.get(i).add(teleportButton);
                if (this.isTeleportAvailable(teleportDef)) {
                    Teleport teleport = this.getAvailableTeleport(teleportDef);
                    teleportButton.setSprites(teleportDef.getEnabledSprite());
                    teleportButton.setBorder(this.config.borderStyle());
                    String teleportName = this.generateTeleportName(teleport);
                    teleportButton.setName(teleportName);
                    this.teleportAction = this.getModeAction();
                    teleportButton.addAction(this.teleportAction, () -> this.triggerTeleport(teleport));
                    if (betterTeleportMenuActive) {
                        teleportButton.addAction(ACTION_TEXT_HOTKEY, () -> this.triggerRebindDialog(teleport));
                    }
                    this.activeTeleportButtons.put(teleportDef.getName(), teleportButton);
                    continue;
                }
                teleportButton.setSprites(teleportDef.getDisabledSprite());
            }
        }
    }

    private String generateTeleportName(Teleport teleport) {
        TeleportNameMode nameMode = this.config.teleportName();
        String name = teleport.getName();
        if (teleport.hasAlias()) {
            switch (nameMode) {
                case BOTH: {
                    name = this.getParenthesisedAlias(teleport.getDefinition());
                    break;
                }
                case ALIAS: {
                    name = teleport.getAlias();
                }
            }
        }
        if (this.config.displayShortcuts() && teleport.hasShortcutKey()) {
            name = String.format("[%s] %s", teleport.getKeyShortcut(), name);
        }
        return name;
    }

    private String getParenthesisedName(TeleportDefinition teleportDef) {
        return String.format(PARENTHESISED_ALIAS_FORMAT, teleportDef.getAlias(), teleportDef.getName());
    }

    private String getParenthesisedAlias(TeleportDefinition teleportDef) {
        return String.format(PARENTHESISED_ALIAS_FORMAT, teleportDef.getName(), teleportDef.getAlias());
    }

    private void createToggleCheckbox(Widget window) {
        Widget toggleWidget = window.createChild(-1, 5);
        Widget labelWidget = window.createChild(-1, 4);
        UICheckBox mapToggle = new UICheckBox(toggleWidget, labelWidget);
        mapToggle.setPosition(10, 10);
        mapToggle.setName(NAME_TEXT_TOGGLE);
        mapToggle.setEnabled(this.mapEnabled);
        mapToggle.setText("Show Map");
        mapToggle.setToggleListener(this::onMapStateToggled);
    }

    private void updateMapState(Widget window) {
        if (this.mapEnabled) {
            this.setDefaultWidgetVisibility(false);
            this.displayIndexPage();
        } else {
            this.indexPage.setVisibility(false);
            this.mapPages.forEach(page -> page.setVisibility(false));
            this.setDefaultWidgetVisibility(true);
        }
        this.setPreviousDisplayMode(this.mapEnabled);
    }

    private void displayIndexPage() {
        this.indexPage.setVisibility(true);
        this.mapPages.forEach(page -> page.setVisibility(false));
    }

    private void displayMapPage(int regionID) {
        this.indexPage.setVisibility(false);
        this.mapPages.forEach(page -> page.setVisibility(false));
        this.mapPages.get(regionID).setVisibility(true);
        this.mapGraphic.setSprite(this.regionDefinitions[regionID].getMapSprite());
    }

    private void onMapStateToggled(UIComponent src) {
        UICheckBox toggleCheckbox = (UICheckBox)src;
        this.mapEnabled = toggleCheckbox.isEnabled();
        this.updateMapState(this.client.getWidget(0x110002));
        this.client.playSoundEffect(2266);
    }

    private void onIconHover(int regionID) {
        this.indexRegionGraphics[regionID].setY(51);
        this.indexRegionGraphics[regionID].setOpacity(0.75f);
        this.indexRegionGraphics[regionID].getWidget().revalidate();
    }

    private void onIconLeave(int regionID) {
        this.indexRegionGraphics[regionID].setY(53);
        this.indexRegionGraphics[regionID].setOpacity(1.0f);
        this.indexRegionGraphics[regionID].getWidget().revalidate();
    }

    private void onIconClicked(int regionID) {
        this.displayMapPage(regionID);
        this.client.playSoundEffect(2266);
    }

    private void onBackButtonPressed() {
        this.displayIndexPage();
        this.client.playSoundEffect(2266);
    }

    private void triggerTeleport(Teleport teleport) {
        int packedID = teleport.isAlt() ? 0x110007 : 0x110008;
        int widgetIndex = teleport.getChildIndex();
        this.clientThread.invokeLater(() -> this.client.runScript(new Object[]{1437, packedID, widgetIndex}));
    }

    private void triggerRebindDialog(Teleport teleport) {
        if (!this.isBetterTeleportMenuActive()) {
            return;
        }
        SpoofMenuEntry spoofMenuEntry = new SpoofMenuEntry(teleport.getWidget());
        this.eventBus.post((Object)new MenuOptionClicked((MenuEntry)spoofMenuEntry));
    }

    private boolean isBetterTeleportMenuActive() {
        for (Plugin plugin : this.pluginManager.getPlugins()) {
            boolean pluginNameMatches = plugin.getName().equals(PLUGIN_NAME_BTM);
            if (!pluginNameMatches || !this.pluginManager.isPluginEnabled(plugin)) continue;
            return true;
        }
        return false;
    }

    private boolean isTeleportAvailable(TeleportDefinition teleportDefinition) {
        return this.getAvailableTeleport(teleportDefinition) != null;
    }

    private Teleport getAvailableTeleport(TeleportDefinition teleportDefinition) {
        if (this.availableTeleports.containsKey(teleportDefinition.getAlias())) {
            return this.availableTeleports.get(teleportDefinition.getAlias());
        }
        if (this.availableTeleports.containsKey(this.getParenthesisedName(teleportDefinition))) {
            return this.availableTeleports.get(this.getParenthesisedName(teleportDefinition));
        }
        return this.availableTeleports.get(teleportDefinition.getName());
    }

    private boolean getPreviousDisplayMode() {
        Boolean mode = (Boolean)this.configManager.getConfiguration(CFG_GROUP, CFG_KEY_STATE, Boolean.class);
        if (mode == null) {
            return false;
        }
        return mode;
    }

    private void setPreviousDisplayMode(boolean mode) {
        this.configManager.setConfiguration(CFG_GROUP, CFG_KEY_STATE, (Object)mode);
    }

    private String getModeAction() {
        int mode = this.client.getVarbitValue(6671);
        return mode == 1 ? ACTION_TEXT_SCRY : ACTION_TEXT_TELE;
    }
}

