/*
 * Decompiled with CFR 0.152.
 */
package com.rolerandomizer.ui;

import com.rolerandomizer.RoleRandomizerConfig;
import com.rolerandomizer.ui.OptionsPanel;
import com.rolerandomizer.ui.RandomizeResultPanel;
import com.rolerandomizer.ui.RoleRandomizerPanel;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;

public class RoleRandomizerPluginPanel
extends PluginPanel {
    public RandomizeResultPanel resultPanel;
    public RoleRandomizerPanel inputPanel;
    public OptionsPanel optionsPanel;

    public RoleRandomizerPluginPanel(Client client, RoleRandomizerConfig config, ChatMessageManager chatMessageManager) {
        this.inputPanel = new RoleRandomizerPanel(client, config, chatMessageManager, this);
        this.resultPanel = new RandomizeResultPanel(this);
        this.optionsPanel = new OptionsPanel(this, this.inputPanel);
        JButton clearButton = new JButton("Clear");
        clearButton.setBackground(ColorScheme.PROGRESS_ERROR_COLOR);
        clearButton.setBorder(new EmptyBorder(5, 7, 5, 7));
        clearButton.setToolTipText("This wipes the slate clean!");
        clearButton.addActionListener(e -> {
            this.inputPanel.cleanSlate();
            this.resultPanel.cleanSlate();
        });
        JButton removePreviousButton = new JButton("Remove previous roles");
        removePreviousButton.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        removePreviousButton.setFocusable(false);
        removePreviousButton.addActionListener(e -> this.inputPanel.removePreviousRoles());
        this.add(this.inputPanel);
        this.add(removePreviousButton);
        this.add(this.resultPanel);
        this.add(clearButton);
        this.add(this.optionsPanel);
    }

    public boolean addPlayer(String stringSelection) {
        String player = stringSelection.toString();
        player = player.replaceAll("\\[.*\\]", "").trim().replace(":", "");
        if (this.inputPanel.uiFieldPlayer2.getText().isEmpty()) {
            this.inputPanel.uiFieldPlayer2.setText(player);
            this.inputPanel.addAllPreferences(this.inputPanel.uiFieldPlayer2Preferences);
            return true;
        }
        if (this.inputPanel.uiFieldPlayer3.getText().isEmpty()) {
            this.inputPanel.uiFieldPlayer3.setText(player);
            this.inputPanel.addAllPreferences(this.inputPanel.uiFieldPlayer3Preferences);
            return true;
        }
        if (this.inputPanel.uiFieldPlayer4.getText().isEmpty()) {
            this.inputPanel.uiFieldPlayer4.setText(player);
            this.inputPanel.addAllPreferences(this.inputPanel.uiFieldPlayer4Preferences);
            return true;
        }
        if (this.inputPanel.uiFieldPlayer5.getText().isEmpty()) {
            this.inputPanel.uiFieldPlayer5.setText(player);
            this.inputPanel.addAllPreferences(this.inputPanel.uiFieldPlayer5Preferences);
            return true;
        }
        return false;
    }
}

