/*
 * Decompiled with CFR 0.152.
 */
package com.rolerandomizer.ui;

import com.rolerandomizer.RoleRandomizer;
import com.rolerandomizer.RoleRandomizerConfig;
import com.rolerandomizer.exceptions.NoPermutationException;
import com.rolerandomizer.ui.RoleRandomizerPluginPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.FlatTextField;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleRandomizerPanel
extends JPanel
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(RoleRandomizerPanel.class);
    private final RoleRandomizerPluginPanel panel;
    public JTextField uiFieldPlayer1;
    public JCheckBox[] uiFieldPlayer1Preferences;
    public JTextField uiFieldPlayer2;
    public JCheckBox[] uiFieldPlayer2Preferences;
    public JTextField uiFieldPlayer3;
    public JCheckBox[] uiFieldPlayer3Preferences;
    public JTextField uiFieldPlayer4;
    public JCheckBox[] uiFieldPlayer4Preferences;
    public JTextField uiFieldPlayer5;
    public JCheckBox[] uiFieldPlayer5Preferences;
    public boolean[] initialPlayer1Preferences;
    public boolean isInitialPlayer1PreferencesSet;
    public boolean[] initialPlayer2Preferences;
    public boolean isInitialPlayer2PreferencesSet;
    public boolean[] initialPlayer3Preferences;
    public boolean isInitialPlayer3PreferencesSet;
    public boolean[] initialPlayer4Preferences;
    public boolean isInitialPlayer4PreferencesSet;
    public boolean[] initialPlayer5Preferences;
    public boolean isInitialPlayer5PreferencesSet;
    public boolean keepPreviousRolesSelected;
    private String[] previousRandom;
    private RoleRandomizer rr;
    private Client client;
    private RoleRandomizerConfig config;
    private final ChatMessageManager chatMessageManager;
    private JButton roleRandomizerButton;
    private JButton resetButton;

    protected RoleRandomizerPanel(Client client, RoleRandomizerConfig config, ChatMessageManager chatMessageManager, RoleRandomizerPluginPanel panel) {
        this.panel = panel;
        this.client = client;
        this.config = config;
        this.chatMessageManager = chatMessageManager;
        this.keepPreviousRolesSelected = false;
        this.setLayout(new GridLayout(6, 2, 5, 5));
        this.initializeComponents();
    }

    private void addFillListener(JCheckBox[] pPreferences) {
        pPreferences[5].addActionListener(e -> this.flipCheckboxes(pPreferences, pPreferences[5]));
    }

    public void addAllPreferences(JCheckBox[] pPreferences) {
        for (JCheckBox box : pPreferences) {
            box.setSelected(true);
        }
    }

    private void addCheckFillListener(JCheckBox[] playerPreferences) {
        for (int i = 0; i < playerPreferences.length - 1; ++i) {
            playerPreferences[i].addActionListener(e -> {
                if (playerPreferences[5].isSelected()) {
                    playerPreferences[5].setSelected(false);
                } else {
                    int isFill = 0;
                    for (int box = 0; box < playerPreferences.length - 1 && playerPreferences[box].isSelected(); ++box) {
                        ++isFill;
                    }
                    if (isFill == 5) {
                        playerPreferences[5].setSelected(true);
                    }
                }
            });
        }
    }

    public void flipCheckboxes(JCheckBox[] checkboxes, JCheckBox fillBox) {
        if (fillBox.isSelected()) {
            for (int i = 0; i < checkboxes.length - 1; ++i) {
                checkboxes[i].setSelected(true);
            }
        } else {
            for (int i = 0; i < checkboxes.length - 1; ++i) {
                checkboxes[i].setSelected(false);
            }
        }
    }

    private JCheckBox[] generatePlayerPreferences(JTextField textField, boolean[] initialPreferences, int playerNumber) {
        JCheckBox[] preferences = new JCheckBox[6];
        JPanel container = new JPanel();
        container.setLayout(new GridLayout(2, 6, 0, 0));
        container.add(this.generateRadioLabel("M"));
        container.add(this.generateRadioLabel("2"));
        container.add(this.generateRadioLabel("H"));
        container.add(this.generateRadioLabel("C"));
        container.add(this.generateRadioLabel("D"));
        container.add(this.generateRadioLabel("F"));
        JButton destroy = new JButton("x");
        destroy.setOpaque(false);
        destroy.setContentAreaFilled(false);
        destroy.setBorderPainted(false);
        destroy.setFocusable(false);
        destroy.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        destroy.setBorder(null);
        destroy.addActionListener(e -> {
            this.clearPlayerPreferences(preferences, initialPreferences, playerNumber);
            textField.setText("");
        });
        container.add(destroy);
        for (int i = 0; i < preferences.length; ++i) {
            preferences[i] = this.generateRadioComponent();
            container.add(preferences[i]);
        }
        this.add(container);
        return preferences;
    }

    private JCheckBox generateRadioComponent() {
        JCheckBox checkbox = new JCheckBox();
        checkbox.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        checkbox.setBorder(new EmptyBorder(0, 0, 0, 0));
        checkbox.setFocusPainted(false);
        checkbox.setFocusable(false);
        return checkbox;
    }

    private JLabel generateRadioLabel(String role) {
        JLabel label = new JLabel(role);
        label.setFont(FontManager.getRunescapeSmallFont());
        label.setBorder(new EmptyBorder(0, 5, 0, 0));
        label.setForeground(Color.WHITE);
        label.setFocusable(false);
        switch (role) {
            case "M": {
                label.setToolTipText("Main attacker");
                break;
            }
            case "2": {
                label.setToolTipText("Second attacker");
                break;
            }
            case "H": {
                label.setToolTipText("Healer");
                break;
            }
            case "C": {
                label.setToolTipText("Collector");
                break;
            }
            case "D": {
                label.setToolTipText("Defender");
                break;
            }
            case "F": {
                label.setToolTipText("Fill");
            }
        }
        return label;
    }

    private void clearPlayerPreferences(JCheckBox[] prefs, boolean[] initialPreferences, int playerNumber) {
        for (JCheckBox box : prefs) {
            box.setSelected(false);
        }
        for (int i = 0; i < initialPreferences.length; ++i) {
            initialPreferences[i] = false;
        }
        switch (playerNumber) {
            case 1: {
                this.isInitialPlayer1PreferencesSet = false;
                break;
            }
            case 2: {
                this.isInitialPlayer2PreferencesSet = false;
                break;
            }
            case 3: {
                this.isInitialPlayer3PreferencesSet = false;
                break;
            }
            case 4: {
                this.isInitialPlayer4PreferencesSet = false;
                break;
            }
            case 5: {
                this.isInitialPlayer5PreferencesSet = false;
            }
        }
    }

    private JTextField addComponent(String label) {
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        JLabel uiLabel = new JLabel(label);
        FlatTextField uiInput = new FlatTextField();
        uiInput.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        uiInput.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        uiInput.setBorder((Border)new EmptyBorder(5, 7, 5, 7));
        uiLabel.setFont(FontManager.getRunescapeSmallFont());
        uiLabel.setBorder(new EmptyBorder(0, 0, 4, 0));
        uiLabel.setForeground(Color.WHITE);
        container.add((Component)uiLabel, "North");
        container.add((Component)uiInput, "Center");
        this.add(container);
        return uiInput.getTextField();
    }

    private JButton addResetButtonComponent(String label) {
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        JButton resetButton = new JButton(label);
        resetButton.setBackground(ColorScheme.DARK_GRAY_COLOR);
        resetButton.setBorder(new EmptyBorder(5, 7, 5, 7));
        resetButton.setToolTipText("This resets preferences!");
        resetButton.setEnabled(false);
        resetButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    RoleRandomizerPanel.this.resetPreferences();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    RoleRandomizerPanel.this.resetPreferences();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    RoleRandomizerPanel.this.resetPreferences();
                }
            }
        });
        resetButton.addActionListener(e -> this.resetPreferences());
        container.add((Component)resetButton, "Center");
        this.add((Component)container, "North");
        return resetButton;
    }

    private void resetPlayerPreferences(JCheckBox[] prefs, boolean[] initial) {
        for (int i = 0; i < prefs.length; ++i) {
            prefs[i].setSelected(initial[i]);
        }
    }

    private void resetPreferences() {
        this.panel.resultPanel.roleRandomizerResultField.setText("");
        this.panel.resultPanel.roleRandomizerResultField.insert("\n", 0);
        this.resetPlayerPreferences(this.uiFieldPlayer1Preferences, this.initialPlayer1Preferences);
        this.resetPlayerPreferences(this.uiFieldPlayer2Preferences, this.initialPlayer2Preferences);
        this.resetPlayerPreferences(this.uiFieldPlayer3Preferences, this.initialPlayer3Preferences);
        this.resetPlayerPreferences(this.uiFieldPlayer4Preferences, this.initialPlayer4Preferences);
        this.resetPlayerPreferences(this.uiFieldPlayer5Preferences, this.initialPlayer5Preferences);
        this.rr.playerOnePreferences = null;
        this.rr.playerTwoPreferences = null;
        this.rr.playerThreePreferences = null;
        this.rr.playerFourPreferences = null;
        this.rr.playerFivePreferences = null;
        this.resetButton.setEnabled(false);
    }

    private void addRandomizeButtonComponent(String label) {
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        this.roleRandomizerButton = new JButton(label);
        this.roleRandomizerButton.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.roleRandomizerButton.setBorder(new EmptyBorder(5, 7, 5, 7));
        this.roleRandomizerButton.addActionListener(this);
        this.roleRandomizerButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    RoleRandomizerPanel.this.randomize();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        container.add((Component)this.roleRandomizerButton, "Center");
        this.add((Component)container, "South");
    }

    public void getUsernames() {
        if (!(this.uiFieldPlayer1.getText().isEmpty() || this.uiFieldPlayer2.getText().isEmpty() || this.uiFieldPlayer3.getText().isEmpty() || this.uiFieldPlayer4.getText().isEmpty() || this.uiFieldPlayer5.getText().isEmpty())) {
            HashMap<Integer, String> usernames = new HashMap<Integer, String>();
            usernames.put(0, this.uiFieldPlayer1.getText());
            usernames.put(1, this.uiFieldPlayer2.getText());
            usernames.put(2, this.uiFieldPlayer3.getText());
            usernames.put(3, this.uiFieldPlayer4.getText());
            usernames.put(4, this.uiFieldPlayer5.getText());
            this.rr.setUsernames(usernames);
        }
    }

    private int[] setPreferences(JCheckBox[] prefs) {
        int[] playerPrefs = new int[prefs.length - 1];
        for (int i = 0; i < playerPrefs.length; ++i) {
            playerPrefs[i] = prefs[i].isSelected() ? 1 : 0;
        }
        return playerPrefs;
    }

    public void setInitialPreferences(JCheckBox[] currentPrefs, boolean[] initPrefs) {
        for (int i = 0; i < initPrefs.length; ++i) {
            initPrefs[i] = currentPrefs[i].isSelected();
        }
    }

    public void getPreferences() {
        if (!this.isInitialPlayer1PreferencesSet) {
            this.setInitialPreferences(this.uiFieldPlayer1Preferences, this.initialPlayer1Preferences);
            this.isInitialPlayer1PreferencesSet = true;
        }
        this.rr.setPlayerOnePreferences(this.setPreferences(this.uiFieldPlayer1Preferences));
        if (!this.isInitialPlayer2PreferencesSet) {
            this.setInitialPreferences(this.uiFieldPlayer2Preferences, this.initialPlayer2Preferences);
            this.isInitialPlayer2PreferencesSet = true;
        }
        this.rr.setPlayerTwoPreferences(this.setPreferences(this.uiFieldPlayer2Preferences));
        if (!this.isInitialPlayer3PreferencesSet) {
            this.setInitialPreferences(this.uiFieldPlayer3Preferences, this.initialPlayer3Preferences);
            this.isInitialPlayer3PreferencesSet = true;
        }
        this.rr.setPlayerThreePreferences(this.setPreferences(this.uiFieldPlayer3Preferences));
        if (!this.isInitialPlayer4PreferencesSet) {
            this.setInitialPreferences(this.uiFieldPlayer4Preferences, this.initialPlayer4Preferences);
            this.isInitialPlayer4PreferencesSet = true;
        }
        this.rr.setPlayerFourPreferences(this.setPreferences(this.uiFieldPlayer4Preferences));
        if (!this.isInitialPlayer5PreferencesSet) {
            this.setInitialPreferences(this.uiFieldPlayer5Preferences, this.initialPlayer5Preferences);
            this.isInitialPlayer5PreferencesSet = true;
        }
        this.rr.setPlayerFivePreferences(this.setPreferences(this.uiFieldPlayer5Preferences));
        this.resetButton.setEnabled(true);
    }

    public void randomize() {
        this.panel.resultPanel.roleRandomizerResultField.setText("");
        this.panel.resultPanel.roleRandomizerResultField.insert("\n", 0);
        this.getUsernames();
        if (this.rr.usernames.size() != 5) {
            this.panel.resultPanel.roleRandomizerResultField.setText(" Set usernames in the above fields.");
            return;
        }
        if (!this.checkMinimumBoxesTicked()) {
            this.panel.resultPanel.roleRandomizerResultField.setText(" Minimum amount of roles not set!");
            return;
        }
        this.getPreferences();
        try {
            String[] roles = this.rr.randomize();
            this.previousRandom = roles;
            StringBuilder shortFormRoles = new StringBuilder();
            block9: for (int index = 0; index < 5; ++index) {
                switch (index) {
                    case 0: {
                        this.panel.resultPanel.roleRandomizerResultField.insert(" Main\t" + roles[index] + "\n", 1);
                        if (this.config.sendToChatBox() && this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
                            shortFormRoles.append(ColorUtil.wrapWithColorTag((String)roles[index], (Color)Color.RED.darker())).append(" / ");
                        }
                        if (this.keepPreviousRolesSelected) continue block9;
                        this.removeRolePreferences(roles, index);
                        continue block9;
                    }
                    case 1: {
                        this.panel.resultPanel.roleRandomizerResultField.append(" Second\t" + roles[index] + "\n");
                        if (this.config.sendToChatBox() && this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
                            shortFormRoles.append(ColorUtil.wrapWithColorTag((String)roles[index], (Color)Color.RED.darker())).append(" / ");
                        }
                        if (this.keepPreviousRolesSelected) continue block9;
                        this.removeRolePreferences(roles, index);
                        continue block9;
                    }
                    case 2: {
                        this.panel.resultPanel.roleRandomizerResultField.append(" Healer\t" + roles[index] + "\n");
                        if (this.config.sendToChatBox() && this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
                            shortFormRoles.append(ColorUtil.wrapWithColorTag((String)roles[index], (Color)Color.GREEN.darker().darker())).append(" / ");
                        }
                        if (this.keepPreviousRolesSelected) continue block9;
                        this.removeRolePreferences(roles, index);
                        continue block9;
                    }
                    case 3: {
                        this.panel.resultPanel.roleRandomizerResultField.append(" Collector\t" + roles[index] + "\n");
                        if (this.config.sendToChatBox() && this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
                            shortFormRoles.append(ColorUtil.wrapWithColorTag((String)roles[index], (Color)Color.YELLOW)).append(" / ");
                        }
                        if (this.keepPreviousRolesSelected) continue block9;
                        this.removeRolePreferences(roles, index);
                        continue block9;
                    }
                    case 4: {
                        this.panel.resultPanel.roleRandomizerResultField.append(" Defender\t" + roles[index]);
                        if (this.config.sendToChatBox() && this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
                            shortFormRoles.append(ColorUtil.wrapWithColorTag((String)roles[index], (Color)Color.BLUE.darker()));
                        }
                        if (this.keepPreviousRolesSelected) continue block9;
                        this.removeRolePreferences(roles, index);
                    }
                }
            }
            if (this.config.sendToChatBox() && this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(shortFormRoles.toString()).build());
            }
        }
        catch (NoPermutationException ex) {
            this.panel.resultPanel.roleRandomizerResultField.setText(this.missingRole());
        }
    }

    private String missingRole() {
        StringBuilder result = new StringBuilder();
        int[] p1Count = this.countRoles(this.uiFieldPlayer1Preferences);
        int[] p2Count = this.countRoles(this.uiFieldPlayer2Preferences);
        int[] p3Count = this.countRoles(this.uiFieldPlayer3Preferences);
        int[] p4Count = this.countRoles(this.uiFieldPlayer4Preferences);
        int[] p5Count = this.countRoles(this.uiFieldPlayer5Preferences);
        int main_attack = p1Count[0] + p2Count[0] + p3Count[0] + p4Count[0] + p5Count[0];
        int second_attack = p1Count[1] + p2Count[1] + p3Count[1] + p4Count[1] + p5Count[1];
        int healer = p1Count[2] + p2Count[2] + p3Count[2] + p4Count[2] + p5Count[2];
        int collector = p1Count[3] + p2Count[3] + p3Count[3] + p4Count[3] + p5Count[3];
        int defender = p1Count[4] + p2Count[4] + p3Count[4] + p4Count[4] + p5Count[4];
        if (main_attack == 0) {
            result.append(" No available Mains");
            result.append(System.getProperty("line.separator"));
        }
        if (second_attack == 0) {
            result.append(" No available 2nd Attackers");
            result.append(System.getProperty("line.separator"));
        }
        if (healer == 0) {
            result.append(" No available Healers");
            result.append(System.getProperty("line.separator"));
        }
        if (collector == 0) {
            result.append(" No available Collectors");
            result.append(System.getProperty("line.separator"));
        }
        if (defender == 0) {
            result.append(" No available Defenders");
            result.append(System.getProperty("line.separator"));
        }
        log.info(result.toString());
        return result.toString();
    }

    private int[] countRoles(JCheckBox[] rolesSelected) {
        int[] returnCount = new int[5];
        for (int i = 0; i < rolesSelected.length; ++i) {
            if (!rolesSelected[i].isSelected()) continue;
            returnCount[i] = 1;
        }
        return returnCount;
    }

    private boolean checkMinimumBoxesTicked() {
        return this.minimumRolesSet(this.uiFieldPlayer1Preferences) && this.minimumRolesSet(this.uiFieldPlayer2Preferences) && this.minimumRolesSet(this.uiFieldPlayer3Preferences) && this.minimumRolesSet(this.uiFieldPlayer4Preferences) && this.minimumRolesSet(this.uiFieldPlayer5Preferences);
    }

    private boolean minimumRolesSet(JCheckBox[] playerPreferences) {
        for (int i = 0; i < playerPreferences.length; ++i) {
            if (!playerPreferences[i].isSelected()) continue;
            return true;
        }
        return false;
    }

    public void removePreviousRoles() {
        for (int index = 0; index < 5; ++index) {
            this.removeRolePreferences(this.previousRandom, index);
        }
    }

    private void removeRolePreferences(String[] roles, int index) {
        for (Map.Entry<Integer, String> entry : this.rr.usernames.entrySet()) {
            if (!Objects.equals(entry.getValue(), roles[index])) continue;
            this.rr.popPreference(entry.getKey(), index);
            this.uncheckPreference(roles[index], index);
        }
    }

    private void uncheckPreference(String username, int role) {
        if (username.equalsIgnoreCase(this.uiFieldPlayer1.getText())) {
            this.uiFieldPlayer1Preferences[role].setSelected(false);
            if (this.uiFieldPlayer1Preferences[5].isSelected()) {
                this.uiFieldPlayer1Preferences[5].setSelected(false);
            }
        } else if (username.equalsIgnoreCase(this.uiFieldPlayer2.getText())) {
            this.uiFieldPlayer2Preferences[role].setSelected(false);
            if (this.uiFieldPlayer2Preferences[5].isSelected()) {
                this.uiFieldPlayer2Preferences[5].setSelected(false);
            }
        } else if (username.equalsIgnoreCase(this.uiFieldPlayer3.getText())) {
            this.uiFieldPlayer3Preferences[role].setSelected(false);
            if (this.uiFieldPlayer3Preferences[5].isSelected()) {
                this.uiFieldPlayer3Preferences[5].setSelected(false);
            }
        } else if (username.equalsIgnoreCase(this.uiFieldPlayer4.getText())) {
            this.uiFieldPlayer4Preferences[role].setSelected(false);
            if (this.uiFieldPlayer4Preferences[5].isSelected()) {
                this.uiFieldPlayer4Preferences[5].setSelected(false);
            }
        } else if (username.equalsIgnoreCase(this.uiFieldPlayer5.getText())) {
            this.uiFieldPlayer5Preferences[role].setSelected(false);
            if (this.uiFieldPlayer5Preferences[5].isSelected()) {
                this.uiFieldPlayer5Preferences[5].setSelected(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.randomize();
    }

    private void initializeComponents() {
        this.uiFieldPlayer1 = this.addComponent("Player 1");
        this.uiFieldPlayer1.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (RoleRandomizerPanel.this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
                    RoleRandomizerPanel.this.uiFieldPlayer1.setText(Objects.requireNonNull(RoleRandomizerPanel.this.client.getLocalPlayer()).getName());
                    RoleRandomizerPanel.this.addAllPreferences(RoleRandomizerPanel.this.uiFieldPlayer1Preferences);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.isInitialPlayer1PreferencesSet = false;
        this.initialPlayer1Preferences = new boolean[6];
        this.uiFieldPlayer1Preferences = this.generatePlayerPreferences(this.uiFieldPlayer1, this.initialPlayer1Preferences, 1);
        this.addFillListener(this.uiFieldPlayer1Preferences);
        this.addCheckFillListener(this.uiFieldPlayer1Preferences);
        this.uiFieldPlayer2 = this.addComponent("Player 2");
        this.initialPlayer2Preferences = new boolean[6];
        this.isInitialPlayer2PreferencesSet = false;
        this.uiFieldPlayer2Preferences = this.generatePlayerPreferences(this.uiFieldPlayer2, this.initialPlayer2Preferences, 2);
        this.addFillListener(this.uiFieldPlayer2Preferences);
        this.addCheckFillListener(this.uiFieldPlayer2Preferences);
        this.uiFieldPlayer3 = this.addComponent("Player 3");
        this.initialPlayer3Preferences = new boolean[6];
        this.isInitialPlayer3PreferencesSet = false;
        this.uiFieldPlayer3Preferences = this.generatePlayerPreferences(this.uiFieldPlayer3, this.initialPlayer3Preferences, 3);
        this.addFillListener(this.uiFieldPlayer3Preferences);
        this.addCheckFillListener(this.uiFieldPlayer3Preferences);
        this.uiFieldPlayer4 = this.addComponent("Player 4");
        this.initialPlayer4Preferences = new boolean[6];
        this.isInitialPlayer4PreferencesSet = false;
        this.uiFieldPlayer4Preferences = this.generatePlayerPreferences(this.uiFieldPlayer4, this.initialPlayer4Preferences, 4);
        this.addFillListener(this.uiFieldPlayer4Preferences);
        this.addCheckFillListener(this.uiFieldPlayer4Preferences);
        this.uiFieldPlayer5 = this.addComponent("Player 5");
        this.initialPlayer5Preferences = new boolean[6];
        this.isInitialPlayer5PreferencesSet = false;
        this.uiFieldPlayer5Preferences = this.generatePlayerPreferences(this.uiFieldPlayer5, this.initialPlayer5Preferences, 5);
        this.addFillListener(this.uiFieldPlayer5Preferences);
        this.addCheckFillListener(this.uiFieldPlayer5Preferences);
        this.resetButton = this.addResetButtonComponent("Reset");
        this.addRandomizeButtonComponent("Randomize!");
        this.rr = new RoleRandomizer();
    }

    public void cleanSlate() {
        this.initialPlayer1Preferences = new boolean[6];
        this.isInitialPlayer1PreferencesSet = false;
        this.initialPlayer2Preferences = new boolean[6];
        this.isInitialPlayer2PreferencesSet = false;
        this.initialPlayer3Preferences = new boolean[6];
        this.isInitialPlayer3PreferencesSet = false;
        this.initialPlayer4Preferences = new boolean[6];
        this.isInitialPlayer4PreferencesSet = false;
        this.initialPlayer5Preferences = new boolean[6];
        this.isInitialPlayer5PreferencesSet = false;
        this.resetCheckBoxes(this.uiFieldPlayer1Preferences);
        this.resetCheckBoxes(this.uiFieldPlayer2Preferences);
        this.resetCheckBoxes(this.uiFieldPlayer3Preferences);
        this.resetCheckBoxes(this.uiFieldPlayer4Preferences);
        this.resetCheckBoxes(this.uiFieldPlayer5Preferences);
        this.uiFieldPlayer1.setText("");
        this.uiFieldPlayer2.setText("");
        this.uiFieldPlayer3.setText("");
        this.uiFieldPlayer4.setText("");
        this.uiFieldPlayer5.setText("");
        this.resetButton.setEnabled(false);
        this.rr = new RoleRandomizer();
    }

    private void resetCheckBoxes(JCheckBox[] boxes) {
        for (JCheckBox jCheckBox : boxes) {
            jCheckBox.setSelected(false);
        }
    }
}

