/*
 * Decompiled with CFR 0.152.
 */
package com.rolerandomizer.ui;

import com.rolerandomizer.ui.RoleRandomizerPanel;
import com.rolerandomizer.ui.RoleRandomizerPluginPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

public class OptionsPanel
extends JPanel {
    private final RoleRandomizerPluginPanel panel;
    private final RoleRandomizerPanel main;
    private static final ImageIcon ON_SWITCH;
    private static final ImageIcon OFF_SWITCH;

    private void updateKeepRoleConfig(JToggleButton button) {
        button.setToolTipText(button.isSelected() ? "Disable" : "Enable");
        this.main.keepPreviousRolesSelected = button.isSelected();
    }

    protected OptionsPanel(RoleRandomizerPluginPanel panel, RoleRandomizerPanel main) {
        this.panel = panel;
        this.main = main;
        this.setLayout(new BorderLayout());
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.setBorder(new EmptyBorder(0, 5, 5, 5));
        JToggleButton button = new JToggleButton(OFF_SWITCH);
        button.setSelectedIcon(ON_SWITCH);
        button.setPreferredSize(new Dimension(25, 50));
        SwingUtil.removeButtonDecorations((AbstractButton)button);
        button.addItemListener(l -> this.updateKeepRoleConfig(button));
        JLabel optionLabel = new JLabel("Keep previous roles selected");
        optionLabel.setBorder(new EmptyBorder(0, 0, 0, 20));
        container.add((Component)optionLabel, "West");
        container.add((Component)button, "East");
        this.add((Component)container, "South");
    }

    static {
        BufferedImage onSwitch = ImageUtil.loadImageResource(OptionsPanel.class, (String)"green_egg.png");
        onSwitch = ImageUtil.resizeImage((BufferedImage)onSwitch, (int)15, (int)20);
        BufferedImage offSwitch = ImageUtil.loadImageResource(OptionsPanel.class, (String)"red_egg.png");
        offSwitch = ImageUtil.resizeImage((BufferedImage)offSwitch, (int)15, (int)20);
        ON_SWITCH = new ImageIcon(onSwitch);
        OFF_SWITCH = new ImageIcon(offSwitch);
    }
}

