/*
 * Decompiled with CFR 0.152.
 */
package com.rolerandomizer;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import com.rolerandomizer.MetaRoleInfo;
import com.rolerandomizer.PlayerPrefs;
import com.rolerandomizer.RoleParser;
import com.rolerandomizer.RoleRandomizer;
import com.rolerandomizer.RoleRandomizerConfig;
import com.rolerandomizer.ui.RoleRandomizerPluginPanel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="BA Role Randomizer")
public class RoleRandomizerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RoleRandomizerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private RoleRandomizerConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    private final RoleParser parser = new RoleParser();
    private RoleRandomizer randomizer;
    private static final String ADD_TO_RANDOMIZER = "Add to BA Role Randomizer";
    private static final String KICK_OPTION = "Kick";
    private static final ImmutableList<String> BEFORE_OPTIONS = ImmutableList.of((Object)"Add friend", (Object)"Remove friend", (Object)"Kick");
    private static final ImmutableList<String> AFTER_OPTIONS = ImmutableList.of((Object)"Message");
    private String currentMessage = null;
    private RoleRandomizerPluginPanel panel;
    private String[] player1Prefs;
    private String[] player2Prefs;
    private String[] player3Prefs;
    private String[] player4Prefs;
    private String[] player5Prefs;
    private HashMap<Integer, String> usernames;
    private NavigationButton navButton;
    @Inject
    private ClientToolbar clientToolbar;
    private String teamRoles;

    protected void startUp() {
        this.randomizer = new RoleRandomizer();
        this.usernames = new HashMap();
        this.panel = new RoleRandomizerPluginPanel(this.client, this.config, this.chatMessageManager);
        BufferedImage icon = ImageUtil.loadImageResource(RoleRandomizerPlugin.class, (String)"icon.png");
        this.navButton = NavigationButton.builder().tooltip("BA Role Randomizer").priority(9).icon(icon).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        this.usernames = null;
        this.randomizer = null;
        this.currentMessage = null;
        this.clientToolbar.removeNavigation(this.navButton);
        log.debug("Shutting down BA role randomizer plugin");
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (event.getMenuEntries().length < 2 || !this.config.addToRando()) {
            return;
        }
        MenuEntry entry = event.getMenuEntries()[event.getMenuEntries().length - 2];
        if (entry.getType() != MenuAction.CC_OP_LOW_PRIORITY && entry.getType() != MenuAction.RUNELITE) {
            return;
        }
        int groupId = WidgetInfo.TO_GROUP((int)entry.getParam1());
        int childId = WidgetInfo.TO_CHILD((int)entry.getParam1());
        if (groupId != WidgetInfo.CHATBOX.getGroupId()) {
            return;
        }
        Widget widget = this.client.getWidget(groupId, childId);
        Widget parent = widget.getParent();
        if (WidgetInfo.CHATBOX_MESSAGE_LINES.getId() != parent.getId()) {
            return;
        }
        int first = WidgetInfo.CHATBOX_FIRST_MESSAGE.getChildId();
        int dynamicChildId = (childId - first) * 4;
        Widget messageContents = parent.getChild(dynamicChildId);
        if (messageContents == null) {
            return;
        }
        String playerName = messageContents.getText();
        this.client.createMenuEntry(1).setOption(ADD_TO_RANDOMIZER).setTarget(entry.getTarget()).setType(MenuAction.RUNELITE).onClick(e -> this.panel.addPlayer(Text.removeTags((String)Text.toJagexName((String)playerName))));
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (!this.config.addToRando()) {
            return;
        }
        int componentId = event.getActionParam1();
        int groupId = WidgetInfo.TO_GROUP((int)componentId);
        String option = event.getOption();
        if (groupId == WidgetInfo.FRIENDS_LIST.getGroupId() || groupId == WidgetInfo.FRIENDS_CHAT.getGroupId() || componentId == WidgetInfo.CLAN_MEMBER_LIST.getId() || componentId == WidgetInfo.CLAN_GUEST_MEMBER_LIST.getId()) {
            boolean after;
            if (AFTER_OPTIONS.contains((Object)option)) {
                after = true;
            } else if (BEFORE_OPTIONS.contains((Object)option)) {
                after = false;
            } else {
                return;
            }
            this.client.createMenuEntry(after ? -2 : -1).setOption(ADD_TO_RANDOMIZER).setTarget(event.getTarget()).setType(MenuAction.RUNELITE).onClick(e -> this.panel.addPlayer(Text.removeTags((String)Text.toJagexName((String)event.getTarget()))));
        }
    }

    public String buildPrefsPrint() {
        Object prefs = "";
        prefs = (String)prefs + this.nounCapitalize(this.usernames.get(0)) + " " + this.stripArrayExtras(this.player1Prefs) + "  ";
        prefs = (String)prefs + this.nounCapitalize(this.usernames.get(1)) + " " + this.stripArrayExtras(this.player2Prefs) + "  ";
        prefs = (String)prefs + this.nounCapitalize(this.usernames.get(2)) + " " + this.stripArrayExtras(this.player3Prefs) + "  ";
        prefs = (String)prefs + this.nounCapitalize(this.usernames.get(3)) + " " + this.stripArrayExtras(this.player4Prefs) + "  ";
        prefs = (String)prefs + this.nounCapitalize(this.usernames.get(4)) + " " + this.stripArrayExtras(this.player5Prefs) + "  ";
        return prefs;
    }

    public String stripArrayExtras(String[] array) {
        return String.join((CharSequence)"", array).replace("m2hcd", "fill").replace("m2", "a");
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) throws Exception {
        List<PlayerPrefs> prefs;
        if (commandExecuted.getCommand().equals("prefs") && this.randomizer.isPreferencesSet()) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", this.buildPrefsPrint(), null);
        }
        if (commandExecuted.getCommand().equals("r") && (prefs = this.parser.parse(Arrays.asList(commandExecuted.getArguments()))).size() == 5) {
            this.setUsernames(prefs);
            if (!this.randomizer.isPreferencesSet()) {
                this.collectPreferences(prefs);
                this.setAllPreferences(prefs);
            }
            this.teamRoles = this.generateRandom();
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", this.teamRoles, null);
        }
        if (commandExecuted.getCommand().equals("prevr") && !this.teamRoles.isEmpty()) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", this.teamRoles, null);
        }
        if (commandExecuted.getCommand().equals("rr") && !this.teamRoles.isEmpty()) {
            this.teamRoles = this.generateRandom();
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", this.teamRoles, null);
        }
    }

    private void setUsernames(List<PlayerPrefs> prefs) {
        for (int i = 0; i < prefs.size(); ++i) {
            this.usernames.put(i, prefs.get(i).getName());
        }
        this.randomizer.setUsernames(this.usernames);
    }

    private void collectPreferences(List<PlayerPrefs> prefs) {
        this.player1Prefs = (String[])prefs.get(0).getPrefs().stream().map(MetaRoleInfo::getShortName).toArray(String[]::new);
        this.player2Prefs = (String[])prefs.get(1).getPrefs().stream().map(MetaRoleInfo::getShortName).toArray(String[]::new);
        this.player3Prefs = (String[])prefs.get(2).getPrefs().stream().map(MetaRoleInfo::getShortName).toArray(String[]::new);
        this.player4Prefs = (String[])prefs.get(3).getPrefs().stream().map(MetaRoleInfo::getShortName).toArray(String[]::new);
        this.player5Prefs = (String[])prefs.get(4).getPrefs().stream().map(MetaRoleInfo::getShortName).toArray(String[]::new);
    }

    private void setAllPreferences(List<PlayerPrefs> prefs) {
        this.randomizer.setPlayerOnePreferences(this.convertPreferences(prefs.get(0).getPrefs()));
        this.randomizer.setPlayerTwoPreferences(this.convertPreferences(prefs.get(1).getPrefs()));
        this.randomizer.setPlayerThreePreferences(this.convertPreferences(prefs.get(2).getPrefs()));
        this.randomizer.setPlayerFourPreferences(this.convertPreferences(prefs.get(3).getPrefs()));
        this.randomizer.setPlayerFivePreferences(this.convertPreferences(prefs.get(4).getPrefs()));
    }

    private String generateRandom() throws Exception {
        String[] roles = this.randomizer.randomize();
        StringBuilder shortFormRoles = new StringBuilder();
        block6: for (int index = 0; index < 5; ++index) {
            switch (index) {
                case 0: 
                case 1: {
                    shortFormRoles.append(ColorUtil.wrapWithColorTag((String)this.nounCapitalize(roles[index]), (Color)Color.RED.darker())).append(" / ");
                    for (Map.Entry<Integer, String> entry : this.randomizer.usernames.entrySet()) {
                        if (!Objects.equals(entry.getValue(), roles[index])) continue;
                        this.randomizer.popPreference(entry.getKey(), index);
                    }
                    continue block6;
                }
                case 2: {
                    shortFormRoles.append(ColorUtil.wrapWithColorTag((String)this.nounCapitalize(roles[index]), (Color)Color.GREEN.darker().darker())).append(" / ");
                    for (Map.Entry<Integer, String> entry : this.randomizer.usernames.entrySet()) {
                        if (!Objects.equals(entry.getValue(), roles[index])) continue;
                        this.randomizer.popPreference(entry.getKey(), index);
                    }
                    continue block6;
                }
                case 3: {
                    shortFormRoles.append(ColorUtil.wrapWithColorTag((String)this.nounCapitalize(roles[index]), (Color)Color.YELLOW)).append(" / ");
                    for (Map.Entry<Integer, String> entry : this.randomizer.usernames.entrySet()) {
                        if (!Objects.equals(entry.getValue(), roles[index])) continue;
                        this.randomizer.popPreference(entry.getKey(), index);
                    }
                    continue block6;
                }
                case 4: {
                    shortFormRoles.append(ColorUtil.wrapWithColorTag((String)this.nounCapitalize(roles[index]), (Color)Color.BLUE.darker()));
                    for (Map.Entry<Integer, String> entry : this.randomizer.usernames.entrySet()) {
                        if (!Objects.equals(entry.getValue(), roles[index])) continue;
                        this.randomizer.popPreference(entry.getKey(), index);
                    }
                    continue block6;
                }
            }
        }
        return shortFormRoles.toString();
    }

    private String nounCapitalize(String noun) {
        return noun.substring(0, 1).toUpperCase() + noun.substring(1);
    }

    public int[] convertPreferences(List<MetaRoleInfo> prefs) {
        int[] result = new int[]{0, 0, 0, 0, 0};
        for (MetaRoleInfo pref : prefs) {
            result[pref.ordinal()] = 1;
        }
        return result;
    }

    @Provides
    RoleRandomizerConfig provideConfig(ConfigManager configManager) {
        return (RoleRandomizerConfig)configManager.getConfig(RoleRandomizerConfig.class);
    }
}

