/*
 * Decompiled with CFR 0.152.
 */
package com.rolerandomizer;

import com.rolerandomizer.exceptions.NoPermutationException;
import java.util.ArrayList;
import java.util.HashMap;

public class RoleRandomizer {
    public HashMap<Integer, String> usernames = new HashMap();
    public int[] playerOnePreferences;
    public int[] playerTwoPreferences;
    public int[] playerThreePreferences;
    public int[] playerFourPreferences;
    public int[] playerFivePreferences;

    public ArrayList generatePermutations() throws NoPermutationException {
        ArrayList<int[]> permutations = new ArrayList<int[]>();
        for (int i = 0; i < 5; ++i) {
            if (this.playerOnePreferences[i] != 1) continue;
            for (int j = 0; j < 5; ++j) {
                if (j == i || this.playerTwoPreferences[j] != 1) continue;
                for (int k = 0; k < 5; ++k) {
                    if (k == i || k == j || this.playerThreePreferences[k] != 1) continue;
                    for (int l = 0; l < 5; ++l) {
                        if (l == i || l == j || l == k || this.playerFourPreferences[l] != 1) continue;
                        for (int m = 0; m < 5; ++m) {
                            if (m == i || m == j || m == k || m == l || this.playerFivePreferences[m] != 1) continue;
                            int[] tempPermutation = new int[]{i, j, k, l, m};
                            permutations.add(tempPermutation);
                        }
                    }
                }
            }
        }
        return permutations;
    }

    public String[] randomize() throws NoPermutationException {
        if (this.isPreferencesSet()) {
            ArrayList perms = this.generatePermutations();
            if (perms.size() > 0) {
                int chosenIndex = (int)Math.floor(Math.random() * (double)perms.size());
                return this.buildRolesString((int[])perms.get(chosenIndex));
            }
            throw new NoPermutationException("No permutations to choose from");
        }
        return null;
    }

    public boolean isPreferencesSet() {
        return this.playerOnePreferences != null && this.playerOnePreferences.length > 0 && this.playerTwoPreferences != null && this.playerTwoPreferences.length > 0 && this.playerThreePreferences != null && this.playerThreePreferences.length > 0 && this.playerFourPreferences != null && this.playerFourPreferences.length > 0 && this.playerFivePreferences != null && this.playerFivePreferences.length > 0;
    }

    public void setUsernames(HashMap<Integer, String> usernames) {
        this.usernames = usernames;
    }

    public void setPlayerOnePreferences(int[] prefs) {
        this.playerOnePreferences = prefs;
    }

    public void setPlayerTwoPreferences(int[] prefs) {
        this.playerTwoPreferences = prefs;
    }

    public void setPlayerThreePreferences(int[] prefs) {
        this.playerThreePreferences = prefs;
    }

    public void setPlayerFourPreferences(int[] prefs) {
        this.playerFourPreferences = prefs;
    }

    public void setPlayerFivePreferences(int[] prefs) {
        this.playerFivePreferences = prefs;
    }

    private String[] buildRolesString(int[] ints) throws NoPermutationException {
        String[] roles = new String[5];
        for (int i = 0; i < ints.length; ++i) {
            roles[ints[i]] = this.usernames.get(i);
        }
        return roles;
    }

    public void popPreference(Integer key, int role) {
        if (key == 0) {
            this.playerOnePreferences[role] = 0;
        } else if (key == 1) {
            this.playerTwoPreferences[role] = 0;
        } else if (key == 2) {
            this.playerThreePreferences[role] = 0;
        } else if (key == 3) {
            this.playerFourPreferences[role] = 0;
        } else if (key == 4) {
            this.playerFivePreferences[role] = 0;
        }
    }
}

