/*
 * Decompiled with CFR 0.152.
 */
package com.rolerandomizer;

import com.rolerandomizer.InputCandidate;
import com.rolerandomizer.MetaRoleInfo;
import com.rolerandomizer.PlayerPrefs;
import com.rolerandomizer.exceptions.CannotDetermineRolesException;
import com.rolerandomizer.exceptions.CannotParseArgException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class RoleParser {
    private static final List<MetaRoleInfo> ALL_ROLES = Arrays.asList((MetaRoleInfo[])MetaRoleInfo.values().clone());
    private final Set<Set<PlayerPrefs>> validPrefSets = new HashSet<Set<PlayerPrefs>>();
    private final List<String> args = new ArrayList<String>();
    private final List<Set<InputCandidate>> argCandidates = new ArrayList<Set<InputCandidate>>();

    public List<PlayerPrefs> parse(List<String> inputs) throws CannotParseArgException, CannotDetermineRolesException {
        this.validPrefSets.clear();
        this.argCandidates.clear();
        this.args.clear();
        this.args.addAll(inputs);
        this.determineCandidates();
        this.determinePrefs();
        Set bestResult = this.validPrefSets.stream().min(Comparator.comparingInt(set -> set.stream().mapToInt(prefs -> prefs.getName().length()).sum())).orElseThrow(CannotDetermineRolesException::new);
        return bestResult.stream().sorted(Comparator.comparing(PlayerPrefs::getName)).collect(Collectors.toList());
    }

    private void determineCandidates() throws CannotParseArgException {
        for (String input : this.args) {
            HashSet<InputCandidate> candidates = new HashSet<InputCandidate>();
            for (InputCandidate ic : InputCandidate.values()) {
                boolean match = ic.getPattern().matcher(input).matches();
                switch (ic) {
                    case NAME: {
                        break;
                    }
                    case ROLE: {
                        if (input.equals("fill")) break;
                        Set charSet = input.chars().mapToObj(e -> Character.valueOf((char)e)).filter(e -> e.charValue() != '/').collect(Collectors.toSet());
                        String noSlashInput = input.replace("/", "");
                        match &= charSet.size() == noSlashInput.length();
                    }
                }
                if (!match) continue;
                candidates.add(ic);
            }
            if (candidates.isEmpty()) {
                throw new CannotParseArgException(input);
            }
            this.argCandidates.add(candidates);
        }
    }

    private void determinePrefs() {
        this.recurse(this.argCandidates.size() - 1, new ArrayList<PlayerPrefs>());
    }

    private void recurse(int i, List<PlayerPrefs> pending) {
        ArrayList<PlayerPrefs> newPrefs;
        if (i == -1) {
            if (this.isValid(pending)) {
                this.validPrefSets.add(new HashSet<PlayerPrefs>(pending));
            }
            return;
        }
        if (this.isInvalid(pending)) {
            return;
        }
        String word = this.args.get(i);
        Set<InputCandidate> cands = this.argCandidates.get(i);
        PlayerPrefs lastPrefs = null;
        if (!pending.isEmpty()) {
            lastPrefs = pending.get(pending.size() - 1);
        }
        if (cands.contains((Object)InputCandidate.ROLE) && (lastPrefs == null || !lastPrefs.getName().isEmpty()) && i > 0) {
            newPrefs = new ArrayList<PlayerPrefs>(pending);
            newPrefs.add(new PlayerPrefs("", this.prefsFrom(word)));
            this.recurse(i - 1, newPrefs);
        }
        if (cands.contains((Object)InputCandidate.NAME)) {
            if (lastPrefs == null || !lastPrefs.getName().isEmpty()) {
                newPrefs = new ArrayList<PlayerPrefs>(pending);
                newPrefs.add(new PlayerPrefs(word, ALL_ROLES));
                this.recurse(i - 1, newPrefs);
            }
            if (lastPrefs != null && lastPrefs.getName().isEmpty()) {
                newPrefs = new ArrayList<PlayerPrefs>(pending);
                newPrefs.remove(newPrefs.size() - 1);
                newPrefs.add(new PlayerPrefs(word, lastPrefs.getPrefs()));
                this.recurse(i - 1, newPrefs);
            }
        }
    }

    private List<MetaRoleInfo> prefsFrom(String roleStr) {
        if (roleStr.equals("fill")) {
            return ALL_ROLES;
        }
        return Arrays.stream(MetaRoleInfo.values()).filter(info -> info.getMatches().stream().anyMatch(s -> Pattern.compile(s).matcher(roleStr).find())).collect(Collectors.toList());
    }

    private boolean isValid(List<PlayerPrefs> pending) {
        if (pending.size() != 5) {
            return false;
        }
        HashSet<String> names = new HashSet<String>();
        for (PlayerPrefs pref : pending) {
            String name = pref.getName();
            if (name.isEmpty() || names.contains(name) || name.length() > 12) {
                return false;
            }
            names.add(name);
        }
        return true;
    }

    private boolean isInvalid(List<PlayerPrefs> pending) {
        if (pending.size() > 5) {
            return true;
        }
        HashSet<String> names = new HashSet<String>();
        boolean hasEmptyNames = false;
        for (PlayerPrefs pref : pending) {
            String name = pref.getName();
            if (name.isEmpty()) {
                if (hasEmptyNames) {
                    return true;
                }
                hasEmptyNames = true;
            }
            if (names.contains(name) || name.length() > 12) {
                return true;
            }
            names.add(name);
        }
        return false;
    }
}

