/*
 * Decompiled with CFR 0.152.
 */
package com.undyingretributiontimer;

import com.google.inject.Provides;
import com.undyingretributiontimer.RaidRoom;
import com.undyingretributiontimer.UndyingRetributionTimerConfig;
import com.undyingretributiontimer.UndyingRetributionTimerInfoBox;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MessageNode;
import net.runelite.api.Player;
import net.runelite.api.WorldType;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Undying Retribution Timer", description="A timer to keep track of undying retribution cooldown", tags={"undying", "retribution", "timer", "relic"})
public class UndyingRetributionTimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(UndyingRetributionTimerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private UndyingRetributionTimerConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    private static final String CONFIG_GROUP = "undyingretributiontimer";
    private static final int maxTicks = 300;
    private static final int NOT_IN_RAID = 0;
    private boolean previouslyInRaid = false;
    private UndyingRetributionTimerInfoBox infoBox;
    private boolean previouslyInToa = false;
    private boolean leftRaid = false;
    public boolean onCooldown = false;
    public boolean pause = false;
    public int remainingTicks;
    private static final String cooldownNotification = "Your Undying Retribution Relic saves your life. The Relic has lost power for 3 minutes.";
    private static final String resetNotification1 = "You are able to benefit from the Undying Retribution Relic's effect.";
    private static final String resetNotification2 = "Your Undying Retribution Relic's cooldown has ended and you may now benefit from its effect.";
    private int raidLeaveTicks = 0;
    private static final int WIDGET_PARENT_ID = 481;
    private static final int WIDGET_CHILD_ID = 40;

    protected void startUp() throws Exception {
        if (this.configManager.getConfiguration(CONFIG_GROUP, "cooldown") == null) {
            this.configManager.setConfiguration(CONFIG_GROUP, "previouslyInRaid", "false");
            this.configManager.setConfiguration(CONFIG_GROUP, "cooldown", "-1");
        }
        if (this.client.getGameState().equals((Object)GameState.LOGGED_IN) && this.client.getWorldType().contains(WorldType.SEASONAL)) {
            this.previouslyInRaid = Boolean.parseBoolean(this.configManager.getConfiguration(CONFIG_GROUP, "previouslyInRaid"));
            if (this.previouslyInRaid && !this.inRaidNow()) {
                this.configManager.setConfiguration(CONFIG_GROUP, "previouslyInRaid", (Object)false);
                this.offCooldown();
                this.remainingTicks = 0;
                if (!this.config.onlyShowOnCooldown()) {
                    this.createInfobox();
                }
            } else {
                this.checkCooldown();
            }
        }
    }

    protected void shutDown() throws Exception {
        this.save(true);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            if (!this.client.getWorldType().contains(WorldType.SEASONAL)) {
                this.removeInfobox();
                return;
            }
            if (!this.config.onlyShowOnCooldown()) {
                this.createInfobox();
            }
            this.checkCooldown();
            this.pause = false;
            return;
        }
        if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.save(true);
            return;
        }
        if (event.getGameState() == GameState.HOPPING) {
            this.save(false);
            this.pause = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        boolean inToa;
        if (!this.onCooldown || this.pause || !this.client.getWorldType().contains(WorldType.SEASONAL)) {
            return;
        }
        LocalPoint lp = this.client.getLocalPlayer().getLocalLocation();
        int region = lp == null ? -1 : WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)lp).getRegionID();
        Widget w = this.client.getWidget(481, 40);
        RaidRoom currentRoom = RaidRoom.forRegionId(region);
        boolean inRaidRaw = currentRoom != null || w != null && !w.isHidden();
        this.raidLeaveTicks = inRaidRaw ? 3 : this.raidLeaveTicks - 1;
        boolean bl = inToa = this.raidLeaveTicks > 0;
        if (this.leftRaid || this.previouslyInToa && !inToa) {
            System.out.println("Leave raid detected, resetting cooldown");
            this.offCooldown();
            this.previouslyInToa = false;
            this.leftRaid = false;
            return;
        }
        if (this.remainingTicks >= 0) {
            --this.remainingTicks;
        }
        this.previouslyInToa = inToa;
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        MessageNode messageNode = chatMessage.getMessageNode();
        String message = messageNode.getValue();
        if (!messageNode.getType().equals((Object)ChatMessageType.GAMEMESSAGE)) {
            return;
        }
        if (message.contains(cooldownNotification)) {
            this.cooldown(300);
        }
        if (message.contains(resetNotification1) || message.contains(resetNotification2)) {
            this.offCooldown();
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        Player player;
        if (!this.client.getWorldType().contains(WorldType.SEASONAL)) {
            return;
        }
        Actor actor = actorDeath.getActor();
        if (actor instanceof Player && (player = (Player)actor) == this.client.getLocalPlayer() && this.onCooldown) {
            this.offCooldown();
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged e) {
        if (!this.client.getWorldType().contains(WorldType.SEASONAL) && e.getVarbitId() != 6440 && e.getVarbitId() != 5432) {
            return;
        }
        boolean currentlyInRaid = this.inRaidNow();
        if (currentlyInRaid && !this.previouslyInRaid) {
            System.out.println("Raid entered");
            this.configManager.setConfiguration(CONFIG_GROUP, "previouslyInRaid", "true");
        } else if (!currentlyInRaid && this.previouslyInRaid) {
            System.out.println("Raid left");
            this.configManager.setConfiguration(CONFIG_GROUP, "previouslyInRaid", "false");
            if (this.onCooldown) {
                this.leftRaid = true;
            }
        }
        this.previouslyInRaid = currentlyInRaid;
    }

    public boolean inRaidNow() {
        if (this.client.getVarbitValue(6440) == 2 || this.client.getVarbitValue(6440) == 3) {
            return true;
        }
        return this.client.getVarbitValue(5432) != 0;
    }

    private void offCooldown() {
        if (this.config.onlyShowOnCooldown()) {
            this.removeInfobox();
        }
        this.onCooldown = false;
        this.remainingTicks = 0;
        this.save(false);
    }

    private void createInfobox() {
        if (this.infoBox == null) {
            BufferedImage icon = ImageUtil.loadImageResource(UndyingRetributionTimerPlugin.class, (String)"/icons/infoboxIcon.png");
            this.infoBox = new UndyingRetributionTimerInfoBox(this, this.config);
            this.infoBox.setImage(icon);
            this.infoBoxManager.addInfoBox((InfoBox)this.infoBox);
        }
    }

    private void cooldown(int ticks) {
        if (ticks != 0) {
            this.createInfobox();
            this.onCooldown = true;
            this.remainingTicks = ticks;
        }
    }

    public static String to_mmss(int ticks) {
        int m;
        int s = (ticks - (m = ticks / 100) * 100) * 6 / 10;
        return m + (s < 10 ? ":0" : ":") + s;
    }

    public static String to_mmss_precise_short(int ticks) {
        int min = ticks / 100;
        int tmp = (ticks - min * 100) * 6;
        int sec = tmp / 10;
        int sec_tenth = tmp - sec * 10;
        return min + (sec < 10 ? ":0" : ":") + sec + "." + sec_tenth;
    }

    private void checkCooldown() {
        if (!this.onCooldown || this.pause) {
            int storedCooldown = Integer.parseInt(this.configManager.getConfiguration(CONFIG_GROUP, "cooldown"));
            if (storedCooldown > 0) {
                this.cooldown(storedCooldown);
                return;
            }
            this.remainingTicks = storedCooldown;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (!e.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        if (e.getKey().contains("onlyShowOnCooldown")) {
            if (Boolean.parseBoolean(e.getNewValue()) && !this.onCooldown) {
                this.removeInfobox();
                return;
            }
            if (!Boolean.parseBoolean(e.getNewValue())) {
                this.createInfobox();
            }
        }
    }

    private void save(boolean quitting) {
        if (this.infoBox != null && quitting) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.infoBox);
            this.infoBox = null;
        }
        this.configManager.setConfiguration(CONFIG_GROUP, "cooldown", Integer.toString(this.remainingTicks));
        this.configManager.setConfiguration(CONFIG_GROUP, "previouslyInRaid", (Object)this.previouslyInRaid);
    }

    private void removeInfobox() {
        if (this.infoBox != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.infoBox);
            this.infoBox = null;
        }
    }

    @Provides
    UndyingRetributionTimerConfig provideConfig(ConfigManager configManager) {
        return (UndyingRetributionTimerConfig)configManager.getConfig(UndyingRetributionTimerConfig.class);
    }
}

