/*
 * Decompiled with CFR 0.152.
 */
package com.erishiongames.memeeffects.sounds;

import com.erishiongames.memeeffects.AnimationIds;
import com.erishiongames.memeeffects.MemeEffectsPluginConfig;
import com.erishiongames.memeeffects.sounds.SoundEffectIds;
import com.erishiongames.memeeffects.sounds.SoundEngine;
import com.erishiongames.memeeffects.sounds.SoundFiles;
import javax.inject.Inject;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.SoundEffectPlayed;
import net.runelite.client.eventbus.Subscribe;

public class SoundManager {
    private int currentAnimationID = 0;
    @Inject
    private SoundEngine soundEngine;
    @Inject
    private MemeEffectsPluginConfig config;

    @Subscribe
    public void onAnimationChanged(AnimationChanged animationChanged) {
        this.currentAnimationID = animationChanged.getActor().getAnimation();
        if (this.config.enableMortarPestleBonk()) {
            this.tryPlayMortarPestleBonk(this.currentAnimationID);
        }
    }

    public void tryPlayMortarPestleBonk(int currentAnimationID) {
        if (currentAnimationID == AnimationIds.MORTAR_AND_PESTLE.getAnimationID()) {
            this.soundEngine.playClip(SoundFiles.MORTAR_PESTLE_BONK);
        }
    }

    public void tryRemoveMortarPestleSound(SoundEffectPlayed soundEffectPlayed) {
        if (soundEffectPlayed.getSoundId() == SoundEffectIds.MORTAR_AND_PESTLE.getSoundEffectID() && this.currentAnimationID == AnimationIds.MORTAR_AND_PESTLE.getAnimationID()) {
            soundEffectPlayed.consume();
        }
    }

    @Subscribe
    public void onSoundEffectPlayed(SoundEffectPlayed soundEffectPlayed) {
        if (this.config.enableMortarPestleBonk()) {
            this.tryRemoveMortarPestleSound(soundEffectPlayed);
        }
    }
}

