/*
 * Decompiled with CFR 0.152.
 */
package com.erishiongames.memeeffects.sounds;

import com.erishiongames.memeeffects.MemeEffectsPluginConfig;
import com.erishiongames.memeeffects.sounds.SoundFileManager;
import com.erishiongames.memeeffects.sounds.SoundFiles;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SoundEngine {
    private static final Logger log = LoggerFactory.getLogger(SoundEngine.class);
    @Inject
    private MemeEffectsPluginConfig config;
    private static final long CLIP_MTIME_UNLOADED = -2L;
    private long lastClipMTime = -2L;
    private Clip clip = null;

    private boolean loadClip(SoundFiles sound) {
        boolean bl;
        BufferedInputStream stream = new BufferedInputStream(SoundFileManager.getSoundStream(sound));
        try {
            try (AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(stream);){
                this.clip.open(audioInputStream);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException exception) {
                return false;
            }
        }
        ((InputStream)stream).close();
        return bl;
    }

    public void playClip(SoundFiles sound) {
        long currentMTime = System.currentTimeMillis();
        if (this.clip == null || currentMTime != this.lastClipMTime || !this.clip.isOpen()) {
            if (this.clip != null && this.clip.isOpen()) {
                this.clip.close();
            }
            try {
                this.clip = AudioSystem.getClip();
            }
            catch (LineUnavailableException e) {
                this.lastClipMTime = -2L;
                return;
            }
            this.lastClipMTime = currentMTime;
            if (!this.loadClip(sound)) {
                return;
            }
        }
        FloatControl volume = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float gain = 20.0f * (float)Math.log10((float)this.config.Volume() / 100.0f);
        gain = Math.min(gain, volume.getMaximum());
        gain = Math.max(gain, volume.getMinimum());
        volume.setValue(gain);
        this.clip.loop(0);
    }
}

