/*
 * Decompiled with CFR 0.152.
 */
package com.erishiongames.memeeffects.messages;

import com.erishiongames.memeeffects.MemeEffectsPluginConfig;
import com.erishiongames.memeeffects.messages.MessageValues;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.client.eventbus.Subscribe;

public class MessageManager {
    @Inject
    private MemeEffectsPluginConfig config;

    @Subscribe(priority=-10.0f)
    public void onOverheadTextChanged(OverheadTextChanged textChanged) {
        MessageValues messageValue = this.getMessageValue(textChanged.getOverheadText());
        if (messageValue == null) {
            return;
        }
        if (!this.shouldEnableMessage(messageValue)) {
            return;
        }
        String message = this.getConfigMessage(messageValue);
        Actor actor = textChanged.getActor();
        if (message == null || message.isEmpty()) {
            actor.setOverheadText("Meme Effects: Message is empty. TEST");
        } else {
            actor.setOverheadText(message);
        }
    }

    private MessageValues getMessageValue(String message) {
        for (MessageValues messageValue : MessageValues.values()) {
            if (!messageValue.getMessage().equals(message)) continue;
            return messageValue;
        }
        return null;
    }

    private boolean shouldEnableMessage(MessageValues messageValue) {
        switch (messageValue) {
            case EXCALIBUR: {
                return this.config.enableExcalibur();
            }
            case DRAGON_BATTLEAXE: {
                return this.config.enableDragonBattleaxe();
            }
            case DRAGON_AXE: {
                return this.config.enableDragonAxe();
            }
            case DRAGON_HARPOON: {
                return this.config.enableDragonHarpoon();
            }
            case DRAGON_PICKAXE: {
                return this.config.enableDragonPick();
            }
        }
        return false;
    }

    private String getConfigMessage(MessageValues messageValue) {
        switch (messageValue) {
            case EXCALIBUR: {
                return this.config.excaliburMessage();
            }
            case DRAGON_BATTLEAXE: {
                return this.config.dBattleaxeMessage();
            }
            case DRAGON_AXE: {
                return this.config.dAxeMessage();
            }
            case DRAGON_HARPOON: {
                return this.config.dHarpoonMessage();
            }
            case DRAGON_PICKAXE: {
                return this.config.dPickMessage();
            }
        }
        return null;
    }
}

