/*
 * Decompiled with CFR 0.152.
 */
package com.erishiongames.memeeffects;

import com.erishiongames.memeeffects.MemeEffectsPluginConfig;
import com.erishiongames.memeeffects.messages.MessageManager;
import com.erishiongames.memeeffects.sounds.SoundFileManager;
import com.erishiongames.memeeffects.sounds.SoundManager;
import com.google.inject.Provides;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Meme Effects")
public class MemeEffectsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MemeEffectsPlugin.class);
    public static final String CONFIG_GROUP = "memeeffects";
    @Inject
    private Client client;
    @Inject
    private MemeEffectsPluginConfig config;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private SoundManager soundManager;
    @Inject
    private MessageManager messageManager;
    @Inject
    private EventBus eventBus;

    protected void startUp() throws Exception {
        this.eventBus.register((Object)this.soundManager);
        this.eventBus.register((Object)this.messageManager);
        this.executor.submit(() -> {
            SoundFileManager.ensureDownloadDirectoryExists();
            SoundFileManager.downloadAllMissingSounds(this.okHttpClient);
        });
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this.soundManager);
        this.eventBus.unregister((Object)this.messageManager);
    }

    @Provides
    MemeEffectsPluginConfig provideConfig(ConfigManager configManager) {
        return (MemeEffectsPluginConfig)configManager.getConfig(MemeEffectsPluginConfig.class);
    }
}

