/*
 * Decompiled with CFR 0.152.
 */
package com.nexkchelper;

import com.google.inject.Provides;
import com.nexkchelper.NexKcHelperConfig;
import com.nexkchelper.NexKcHelperOverlay;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.NpcUtil;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Nex Kc Helper")
public class NexKcHelperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NexKcHelperPlugin.class);
    @Inject
    private Client client;
    @Inject
    private NexKcHelperConfig config;
    @Inject
    private NexKcHelperOverlay npcMarkerOverlay;
    @Inject
    private NpcUtil npcUtil;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    private final BufferedImage image = ImageUtil.loadImageResource(NexKcHelperPlugin.class, (String)"/util/nexling.png");
    private final InfoBox activeBox = new InfoBox(this.image, this){

        public String getText() {
            return "";
        }

        public Color getTextColor() {
            return Color.CYAN;
        }

        public String getTooltip() {
            return "Nex Kc Helper";
        }
    };
    private boolean active;
    private final ArrayList<NPC> npcs = new ArrayList();
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.keybind()){

        public void keyPressed(KeyEvent e) {
            if (NexKcHelperPlugin.this.config.keybind().matches(e)) {
                if (NexKcHelperPlugin.this.active) {
                    NexKcHelperPlugin.this.reset();
                } else {
                    NexKcHelperPlugin.this.infoBoxManager.addInfoBox(NexKcHelperPlugin.this.activeBox);
                    NexKcHelperPlugin.this.active = true;
                }
            }
        }
    };

    protected void startUp() throws Exception {
        this.reset();
        this.overlayManager.add((Overlay)this.npcMarkerOverlay);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
    }

    protected void shutDown() throws Exception {
        this.reset();
        this.overlayManager.remove((Overlay)this.npcMarkerOverlay);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc;
        String npcName;
        if (this.active && ((npcName = (npc = npcSpawned.getNpc()).getName()) != null || !this.npcs.contains(npc))) {
            if (this.config.excludeRangeMelee() && (npcName.equals("Spiritual Warrior") || npcName.equals("Spiritual Ranger"))) {
                return;
            }
            this.npcs.add(npc);
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        if (this.active && hitsplatApplied.getHitsplat().getHitsplatType() == 5 && hitsplatApplied.getActor() instanceof NPC) {
            this.npcs.remove((NPC)hitsplatApplied.getActor());
        }
    }

    private void reset() {
        this.active = false;
        if (!this.infoBoxManager.getInfoBoxes().isEmpty()) {
            this.infoBoxManager.removeInfoBox(this.activeBox);
        }
        this.npcs.clear();
    }

    @Provides
    NexKcHelperConfig provideConfig(ConfigManager configManager) {
        return (NexKcHelperConfig)configManager.getConfig(NexKcHelperConfig.class);
    }

    ArrayList<NPC> getNpcs() {
        return this.npcs;
    }
}

