/*
 * Decompiled with CFR 0.152.
 */
package com.nexkchelper;

import com.nexkchelper.NexKcHelperConfig;
import com.nexkchelper.NexKcHelperPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;

public class NexKcHelperOverlay
extends Overlay {
    private final NexKcHelperPlugin plugin;
    private final NexKcHelperConfig config;
    @Inject
    private Client client;
    @Inject
    private ModelOutlineRenderer modelOutlineRenderer;

    @Inject
    private NexKcHelperOverlay(NexKcHelperPlugin plugin, NexKcHelperConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        Color outlineColor = this.config.outlineColor();
        Color fillColor = this.config.fillColor();
        for (NPC npc : this.plugin.getNpcs()) {
            if (this.config.outline() == NexKcHelperConfig.Outline.CLICKBOX) {
                this.hullOutline(npc, graphics, outlineColor, fillColor);
                continue;
            }
            this.modelOutlineRenderer.drawOutline(npc, this.config.outlineWidth(), outlineColor, this.config.outlineFeather());
        }
        return null;
    }

    private void hullOutline(NPC npc, Graphics2D graphics, Color outlineColor, Color fillColor) {
        Shape objectClickbox;
        NPCComposition npcComposition = npc.getTransformedComposition();
        if (npcComposition != null && (objectClickbox = npc.getConvexHull()) != null) {
            this.renderPoly(graphics, outlineColor, fillColor, objectClickbox);
        }
    }

    private void renderPoly(Graphics2D graphics, Color outlineColor, Color fillColor, Shape polygon) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(outlineColor);
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.draw(polygon);
        graphics.setColor(fillColor);
        graphics.fill(polygon);
    }
}

