/*
 * Decompiled with CFR 0.152.
 */
package com.pinggraph;

import com.google.inject.Provides;
import com.pinggraph.PingGraphConfig;
import com.pinggraph.PingGraphOverlay;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.worldhopper.ping.Ping;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Ping Grapher")
public class PingGraphPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PingGraphPlugin.class);
    private final int numCells = 100;
    private final ReadWriteLock pingLock = new ReentrantReadWriteLock();
    private final ReadWriteLock tickLock = new ReentrantReadWriteLock();
    private final LinkedList<Integer> pingList = new LinkedList();
    private final LinkedList<Integer> tickTimeList = new LinkedList();
    @Inject
    private Client client;
    @Inject
    private PingGraphConfig config;
    @Inject
    private WorldService worldService;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PingGraphOverlay pingGraphOverlay;
    private ScheduledFuture<?> currPingFuture;
    private volatile int currentPing = 1;
    private volatile int maxPing = -1;
    private volatile int minPing = Integer.MAX_VALUE;
    private volatile int currentTick = 600;
    private volatile int maxTick = -1;
    private volatile int minTick = Integer.MAX_VALUE;
    private boolean isLagging;
    private long lastTickTime;
    private volatile int graphStart;
    @Inject
    private ScheduledExecutorService pingExecutorService;

    protected void startUp() throws Exception {
        PingGraphPlugin.write(this.pingLock, () -> {
            this.pingList.clear();
            for (int i = 0; i < 100; ++i) {
                this.pingList.add(1);
            }
            return null;
        });
        PingGraphPlugin.write(this.tickLock, () -> {
            this.tickTimeList.clear();
            for (int i = 0; i < 100; ++i) {
                this.tickTimeList.add(600);
            }
            return null;
        });
        log.info("Ping Graph started!");
        this.overlayManager.add((Overlay)this.pingGraphOverlay);
        this.currPingFuture = this.pingExecutorService.scheduleWithFixedDelay(this::pingCurrentWorld, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    protected void shutDown() throws Exception {
        this.currPingFuture.cancel(true);
        this.currPingFuture = null;
        this.overlayManager.remove((Overlay)this.pingGraphOverlay);
        PingGraphPlugin.write(this.pingLock, () -> {
            this.pingList.clear();
            return null;
        });
        PingGraphPlugin.write(this.tickLock, () -> {
            this.tickTimeList.clear();
            return null;
        });
        log.info("Ping Graph stopped!");
    }

    @Provides
    PingGraphConfig provideConfig(ConfigManager configManager) {
        return (PingGraphConfig)configManager.getConfig(PingGraphConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        int tickDiff;
        long tickTime = new Date().getTime();
        this.currentTick = tickDiff = (int)(tickTime - this.lastTickTime);
        PingGraphPlugin.write(this.tickLock, () -> {
            if (tickDiff < 10000) {
                this.tickTimeList.add(tickDiff);
            } else {
                this.tickTimeList.add(600);
            }
            return this.tickTimeList.remove();
        });
        this.lastTickTime = new Date().getTime();
    }

    @Subscribe
    public void onClientTick(ClientTick tick) {
        long now = new Date().getTime();
        this.isLagging = now - this.lastTickTime > 700L;
        int[] temp = PingGraphPlugin.read(this.tickLock, () -> PingGraphPlugin.getMaxMinFromList(this.tickTimeList, this.graphStart));
        this.maxTick = temp[0];
        this.minTick = temp[1];
        temp = PingGraphPlugin.read(this.pingLock, () -> PingGraphPlugin.getMaxMinFromList(this.pingList, this.graphStart));
        this.maxPing = temp[0];
        this.minPing = temp[1];
    }

    private void pingCurrentWorld() {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null || this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        World currentWorld = worldResult.findWorld(this.client.getWorld());
        if (currentWorld == null) {
            return;
        }
        this.currentPing = Ping.ping((World)currentWorld);
        PingGraphPlugin.write(this.pingLock, () -> {
            this.pingList.add(this.currentPing);
            return this.pingList.remove();
        });
        if (!this.config.graphTicks()) {
            int[] temp = PingGraphPlugin.read(this.pingLock, () -> PingGraphPlugin.getMaxMinFromList(this.pingList, this.graphStart));
            this.maxPing = temp[0];
            this.minPing = temp[1];
        }
    }

    private static int[] getMaxMinFromList(List<Integer> list, int start) {
        int maxVal = -1;
        int minVal = Integer.MAX_VALUE;
        for (int i = start; i < list.size(); ++i) {
            int val = list.get(i);
            if (val <= 0) continue;
            if (maxVal < val) {
                maxVal = val;
            }
            if (minVal <= val) continue;
            minVal = val;
        }
        return new int[]{maxVal, minVal};
    }

    public static <T> T read(ReadWriteLock lock, Supplier<T> supplier) {
        return PingGraphPlugin.supplyLocked(lock.readLock(), supplier);
    }

    public static <T> T write(ReadWriteLock lock, Supplier<T> supplier) {
        return PingGraphPlugin.supplyLocked(lock.writeLock(), supplier);
    }

    private static <T> T supplyLocked(Lock lock, Supplier<T> supplier) {
        lock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public ReadWriteLock getPingLock() {
        return this.pingLock;
    }

    public ReadWriteLock getTickLock() {
        return this.tickLock;
    }

    public LinkedList<Integer> getPingList() {
        return this.pingList;
    }

    public LinkedList<Integer> getTickTimeList() {
        return this.tickTimeList;
    }

    public int getCurrentPing() {
        return this.currentPing;
    }

    public int getMaxPing() {
        return this.maxPing;
    }

    public int getMinPing() {
        return this.minPing;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public int getMaxTick() {
        return this.maxTick;
    }

    public int getMinTick() {
        return this.minTick;
    }

    public boolean isLagging() {
        return this.isLagging;
    }

    public void setGraphStart(int graphStart) {
        this.graphStart = graphStart;
    }
}

