/*
 * Decompiled with CFR 0.152.
 */
package com.pinggraph;

import com.pinggraph.PingGraphConfig;
import com.pinggraph.PingGraphPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingGraphOverlay
extends OverlayPanel {
    private static final Logger log = LoggerFactory.getLogger(PingGraphOverlay.class);
    private final Client client;
    private final PingGraphPlugin pingGraphPlugin;
    private final PingGraphConfig pingGraphConfig;
    public int marginGraphHeight;
    public int marginGraphWidth = 10;
    LayoutableRenderableEntity graphEntity = new LayoutableRenderableEntity(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension render(Graphics2D graphics) {
            double round;
            int minValue;
            int maxValue;
            int dataSize;
            ReadWriteLock lock;
            LinkedList<Integer> data;
            int height;
            int width;
            int overlayHeight;
            int overlayWidth;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            int tempPing = PingGraphOverlay.this.pingGraphPlugin.getCurrentPing();
            int tempTick = PingGraphOverlay.this.pingGraphPlugin.getCurrentTick();
            if (PingGraphOverlay.this.pingGraphConfig.warnMaxToggle()) {
                tempTick = PingGraphOverlay.this.pingGraphPlugin.getMaxTick();
                tempPing = PingGraphOverlay.this.pingGraphPlugin.getMaxPing();
            }
            boolean warning = tempPing > PingGraphOverlay.this.pingGraphConfig.warnPingVal() || tempTick > PingGraphOverlay.this.pingGraphConfig.warnTickVal();
            boolean bl = warning = warning || PingGraphOverlay.this.pingGraphPlugin.getCurrentPing() < 0;
            if (PingGraphOverlay.this.pingGraphConfig.toggleBehind()) {
                PingGraphOverlay.this.setLayer(OverlayLayer.ABOVE_SCENE);
            } else {
                PingGraphOverlay.this.setLayer(OverlayLayer.ABOVE_WIDGETS);
            }
            try {
                overlayWidth = PingGraphOverlay.this.getPreferredSize().width;
                overlayHeight = PingGraphOverlay.this.getPreferredSize().height;
            }
            catch (NullPointerException e) {
                overlayWidth = 180;
                overlayHeight = 60;
                PingGraphOverlay.this.setPreferredSize(new Dimension(overlayWidth, overlayHeight));
            }
            PingGraphOverlay.this.marginGraphHeight = PingGraphOverlay.this.pingGraphConfig.fontSize();
            if (PingGraphOverlay.this.pingGraphConfig.hideMargin()) {
                width = overlayWidth;
                height = overlayHeight - PingGraphOverlay.this.marginGraphHeight;
            } else {
                width = overlayWidth - PingGraphOverlay.this.marginGraphWidth * 2;
                height = overlayHeight - (PingGraphOverlay.this.marginGraphHeight + 15);
            }
            if (PingGraphOverlay.this.pingGraphConfig.hideGraph()) {
                width = 0;
                height = 0;
                overlayHeight = PingGraphOverlay.this.pingGraphConfig.fontSize();
            }
            if (PingGraphOverlay.this.pingGraphConfig.warningBGToggle() && warning) {
                graphics.setColor(PingGraphOverlay.this.pingGraphConfig.warningBGColor());
            } else {
                graphics.setColor(PingGraphOverlay.this.pingGraphConfig.overlayBackgroundColor());
            }
            graphics.fillRect(0, 0, overlayWidth, overlayHeight);
            graphics.setColor(PingGraphOverlay.this.pingGraphConfig.overlayBorderColor());
            graphics.drawRect(0, 0, overlayWidth, overlayHeight);
            if (!PingGraphOverlay.this.pingGraphConfig.toggleLineOnly()) {
                Font userFont;
                graphics.setColor(PingGraphOverlay.this.pingGraphConfig.graphBorderColor());
                int x = PingGraphOverlay.this.pingGraphConfig.hideMargin() ? 0 : PingGraphOverlay.this.marginGraphWidth - 1;
                graphics.drawRect(x, PingGraphOverlay.this.marginGraphHeight + 1, width, height);
                if (PingGraphOverlay.this.pingGraphConfig.warningGraphBGToggle() && warning) {
                    graphics.setColor(PingGraphOverlay.this.pingGraphConfig.warningGraphBGColor());
                } else {
                    graphics.setColor(PingGraphOverlay.this.pingGraphConfig.graphBackgroundColor());
                }
                graphics.fillRect(x, PingGraphOverlay.this.marginGraphHeight + 1, width, height);
                if (PingGraphOverlay.this.pingGraphConfig.warningFontToggle() && warning) {
                    graphics.setColor(PingGraphOverlay.this.pingGraphConfig.warningFontColor());
                } else {
                    graphics.setColor(PingGraphOverlay.this.pingGraphConfig.graphTextColor());
                }
                String fontName = PingGraphOverlay.this.pingGraphConfig.fontName();
                if (PingGraphOverlay.this.pingGraphConfig.fontName().equals("")) {
                    fontName = "Runescape Small";
                }
                if ((userFont = new Font(fontName, PingGraphOverlay.this.pingGraphConfig.fontStyle().getValue(), PingGraphOverlay.this.pingGraphConfig.fontSize())).getFamily().equals("Dialog")) {
                    userFont = new Font("Runescape Small", PingGraphOverlay.this.pingGraphConfig.fontStyle().getValue(), PingGraphOverlay.this.pingGraphConfig.fontSize());
                }
                graphics.setFont(userFont);
                String rightLabel = PingGraphOverlay.this.labelText(PingGraphOverlay.this.pingGraphConfig.rightLabel());
                int strWidth = graphics.getFontMetrics().stringWidth(rightLabel);
                graphics.drawString(rightLabel, overlayWidth - strWidth - PingGraphOverlay.this.marginGraphWidth, PingGraphOverlay.this.marginGraphHeight - 1);
                String leftLabel = PingGraphOverlay.this.labelText(PingGraphOverlay.this.pingGraphConfig.leftLabel());
                graphics.drawString(leftLabel, PingGraphOverlay.this.marginGraphWidth, PingGraphOverlay.this.marginGraphHeight - 1);
            } else {
                width = overlayWidth;
                height = overlayHeight;
            }
            if (PingGraphOverlay.this.pingGraphConfig.graphTicks()) {
                data = PingGraphOverlay.this.pingGraphPlugin.getTickTimeList();
                lock = PingGraphOverlay.this.pingGraphPlugin.getTickLock();
            } else {
                data = PingGraphOverlay.this.pingGraphPlugin.getPingList();
                lock = PingGraphOverlay.this.pingGraphPlugin.getPingLock();
            }
            int dataStart = (dataSize = PingGraphPlugin.read(lock, data::size).intValue()) > overlayWidth ? dataSize - overlayWidth : 0;
            PingGraphOverlay.this.pingGraphPlugin.setGraphStart(dataStart);
            if (PingGraphOverlay.this.pingGraphConfig.graphTicks()) {
                maxValue = PingGraphOverlay.this.pingGraphPlugin.getMaxTick();
                minValue = PingGraphOverlay.this.pingGraphPlugin.getMinTick();
            } else {
                maxValue = PingGraphOverlay.this.pingGraphPlugin.getMaxPing();
                minValue = PingGraphOverlay.this.pingGraphPlugin.getMinPing();
            }
            if (maxValue <= 0) {
                maxValue = 100;
            }
            int tempMax = maxValue;
            if (!PingGraphOverlay.this.pingGraphConfig.toggleRange() && (double)((maxValue = (int)(Math.ceil((double)tempMax / (round = maxValue > 50 ? 50.0 : 10.0)) * round)) - tempMax) <= 0.2 * (double)maxValue) {
                maxValue = (int)((double)maxValue + round);
            }
            if (maxValue == minValue) {
                ++maxValue;
                --minValue;
            }
            if (!PingGraphOverlay.this.pingGraphConfig.hideGraph()) {
                Lock l = lock.readLock();
                l.lock();
                try {
                    PingGraphOverlay.this.drawGraph(graphics, dataStart, data, height, width, maxValue, minValue);
                }
                finally {
                    l.unlock();
                }
            }
            return new Dimension(overlayWidth - 8, overlayHeight - 8);
        }

        public Rectangle getBounds() {
            return new Rectangle(PingGraphOverlay.this.getPreferredSize().width, PingGraphOverlay.this.getPreferredSize().height);
        }

        public void setPreferredLocation(Point position) {
        }

        public void setPreferredSize(Dimension dimension) {
        }
    };

    @Inject
    private PingGraphOverlay(Client client, PingGraphPlugin pingGraphPlugin, PingGraphConfig pingGraphConfig) {
        this.client = client;
        this.pingGraphPlugin = pingGraphPlugin;
        this.pingGraphConfig = pingGraphConfig;
        if (this.getPreferredSize() == null) {
            this.setPreferredSize(new Dimension(180, 60));
        }
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setMinimumSize(15);
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.render(graphics);
        this.panelComponent.getChildren().add(this.graphEntity);
        this.panelComponent.setBackgroundColor(new Color(0, 0, 0, 0));
        return super.render(graphics);
    }

    private String labelText(PingGraphConfig.Labels setting) {
        Object tempLabel = "Label Error";
        switch (setting) {
            case LATENCY: {
                tempLabel = "Latency:" + this.pingGraphPlugin.getCurrentPing() + "ms";
                if (this.pingGraphPlugin.getCurrentPing() >= 0) break;
                tempLabel = "Timed out";
                break;
            }
            case PING: {
                tempLabel = "Ping:" + this.pingGraphPlugin.getCurrentPing() + "ms";
                if (this.pingGraphPlugin.getCurrentPing() >= 0) break;
                tempLabel = "Timed out";
                break;
            }
            case PINGMAX: {
                tempLabel = "Max(P):" + this.pingGraphPlugin.getMaxPing() + "ms";
                break;
            }
            case PINGMIN: {
                tempLabel = "Min(P):" + this.pingGraphPlugin.getMinPing() + "ms";
                break;
            }
            case TICK: {
                tempLabel = "Tick:" + this.pingGraphPlugin.getCurrentTick() + "ms";
                break;
            }
            case TICKMAX: {
                tempLabel = "Max(T):" + this.pingGraphPlugin.getMaxTick() + "ms";
                break;
            }
            case TICKMIN: {
                tempLabel = "Min(T):" + this.pingGraphPlugin.getMinTick() + "ms";
                break;
            }
            case NONE: {
                tempLabel = "";
            }
        }
        return tempLabel;
    }

    private void drawGraph(Graphics2D graphics, int dataStart, LinkedList<Integer> data, int height, int width, int maxValue, int minValue) {
        graphics.setColor(this.pingGraphConfig.graphLineColor());
        int oldX = -1;
        int oldY = -1;
        for (int x = dataStart; x < data.size(); ++x) {
            int y = data.get(x);
            y = y < 0 ? maxValue - 1 : y;
            y = this.pingGraphConfig.toggleRange() ? height - ((height - 2) * (y - minValue) / (maxValue - minValue) + 1) : height - height * y / maxValue;
            int tempX = width * (x - dataStart) / (data.size() - dataStart);
            y += this.marginGraphHeight;
            if (!this.pingGraphConfig.hideMargin()) {
                tempX += this.marginGraphWidth;
            }
            if (this.pingGraphConfig.toggleLineOnly()) {
                if (!this.pingGraphConfig.hideMargin()) {
                    tempX -= this.marginGraphWidth;
                }
                y -= this.marginGraphHeight;
            }
            if (y >= 0) {
                graphics.drawLine(tempX, y, tempX, y);
            }
            if (oldX != -1 && y >= 0) {
                graphics.drawLine(oldX, oldY, tempX, y);
            }
            oldX = tempX;
            oldY = y;
        }
    }
}

