/*
 * Decompiled with CFR 0.152.
 */
package com.ywcode.resourceareanotifier;

import com.ywcode.resourceareanotifier.NotificationOverlay;
import com.ywcode.resourceareanotifier.ResourceAreaNotifierPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

public class BoxNotificationOverlay
extends OverlayPanel {
    private final Client client;

    @Inject
    private BoxNotificationOverlay(Client client) {
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(LineComponent.builder().left("Wilderness Resource Area gate opened!" + System.lineSeparator().repeat(ResourceAreaNotifierPlugin.getBoxHeight()) + " ".repeat(ResourceAreaNotifierPlugin.getBoxWidth())).build());
        this.panelComponent.setPreferredSize(new Dimension(ResourceAreaNotifierPlugin.getBoxWidth(), 0));
        if (ResourceAreaNotifierPlugin.getNotificationOverlay() == NotificationOverlay.BoxFlash) {
            if (this.client.getGameCycle() % 40 >= 20) {
                this.panelComponent.setBackgroundColor(ResourceAreaNotifierPlugin.getBoxColorPrimary());
            } else {
                this.panelComponent.setBackgroundColor(ResourceAreaNotifierPlugin.getBoxColorSecondary());
            }
        }
        if (ResourceAreaNotifierPlugin.getNotificationOverlay() == NotificationOverlay.BoxSolid) {
            this.panelComponent.setBackgroundColor(ResourceAreaNotifierPlugin.getBoxColorPrimary());
        }
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        return this.panelComponent.render(graphics);
    }
}

